/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.campaign.client.CampaignClient;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignCondVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignProductCondVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignSectionProductVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignSectionVO;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.utils.ApiUtils;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.DateRange;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.PsProductDomain;
import com.thebeastshop.pegasus.merchandise.domain.PsSkuDomain;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.service.impl.BasePsServiceImpl;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.collect.Maps;
import org.forest.core.ForestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsProductDomainImpl
extends BasePsServiceImpl<PsProductVO>
implements PsProductDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsProductDomainImpl.class);
    @Autowired
    private ForestConfiguration forestConfiguration;
    private CampaignClient campaignClient;
    @Autowired
    private ProductClient client;
    @Autowired
    private PcsSkuCategoryDomain pcsSkuCategoryService;
    @Autowired
    private PcsSkuDomain pcsSkuService;
    @Autowired
    private PsSkuDomain psSkuService;

    public static List<PsCampaignVO> convertCampaignList(List<CampaignVO> voList) {
        ArrayList<PsCampaignVO> psList = new ArrayList<PsCampaignVO>();
        for (CampaignVO vo : voList) {
            PsCampaignVO ps = new PsCampaignVO();
            ps.setId(vo.getId());
            ps.setName(vo.getName());
            ps.setTitle(vo.getTitle());
            ps.setState(vo.getState());
            ps.setCumulative(vo.getCumulative());
            ps.setDiscountTypeId(vo.getDiscountTypeId());
            TypeVO dicountType = vo.getDiscountType();
            if (dicountType != null) {
                ps.setDiscountTypeName(dicountType.getName());
            }
            ps.setMemberLevels(vo.getMemberLevels());
            ps.setAccessWayIds(vo.getAccessWayIds());
            ps.setCreateTime(vo.getCreateTime());
            ps.setStartTime(vo.getStartTime());
            ps.setExpireTime(vo.getExpireTime());
            ps.setProductScopeId(vo.getProductScopeId());
            List campaignSectionVOList = vo.getCampaignSectionList();
            if (EmptyUtil.isNotEmpty((List)campaignSectionVOList)) {
                ArrayList<PsCampaignSectionVO> psCampaignSectionList = new ArrayList<PsCampaignSectionVO>();
                for (CampaignSectionVO campaignSectionVO : campaignSectionVOList) {
                    PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                    psCampaignSectionVO.setId(campaignSectionVO.getId());
                    psCampaignSectionVO.setCampaignId(campaignSectionVO.getId());
                    TypeVO conditionType = campaignSectionVO.getConditionType();
                    if (conditionType != null) {
                        psCampaignSectionVO.setConditionType(conditionType.getId());
                    }
                    psCampaignSectionVO.setLine(campaignSectionVO.getLine());
                    psCampaignSectionVO.setFactor(campaignSectionVO.getFactor());
                    psCampaignSectionVO.setRanking(campaignSectionVO.getRanking());
                    List campaignSectionProductVOList = campaignSectionVO.getCampaignSectionProductList();
                    if (EmptyUtil.isNotEmpty((List)campaignSectionProductVOList)) {
                        ArrayList<PsCampaignSectionProductVO> psCampaignSectionProductList = new ArrayList<PsCampaignSectionProductVO>();
                        for (CampaignSectionProductVO campaignSectionProductVO : campaignSectionProductVOList) {
                            PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                            psCampaignSectionProductVO.setId(campaignSectionProductVO.getId());
                            psCampaignSectionProductVO.setCampaignId(campaignSectionProductVO.getCampaignId());
                            psCampaignSectionProductVO.setCampaignSectionId(campaignSectionProductVO.getCampaignSectionId());
                            psCampaignSectionProductVO.setProductId(campaignSectionProductVO.getAdditionalProductId());
                            psCampaignSectionProductVO.setPricePrice(campaignSectionProductVO.getAdditionalProductPrice());
                            psCampaignSectionProductVO.setPriceCount(campaignSectionProductVO.getAdditionalProductCount());
                            psCampaignSectionProductList.add(psCampaignSectionProductVO);
                        }
                        psCampaignSectionVO.setCampaignSectionProducts(psCampaignSectionProductList);
                    }
                    psCampaignSectionList.add(psCampaignSectionVO);
                }
                ps.setCampaignSectionList(psCampaignSectionList);
            }
            psList.add(ps);
        }
        return psList;
    }

    @Autowired
    public void init() {
        this.campaignClient = (CampaignClient)this.forestConfiguration.createInstance(CampaignClient.class);
    }

    @Override
    public AbstractESClient<PsProductVO> getESClient() {
        return this.client;
    }

    @Override
    public List<PsProductVO> findByProdName(String name) {
        return this.client.findByField("name", name);
    }

    @Override
    public List<PsProductVO> findByProdCode(String code) {
        return this.client.findByField("code", code);
    }

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        if (CollectionUtils.isNotEmpty((Collection)cond.getIds())) {
            params.put("id", cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        if (CollectionUtils.isNotEmpty((Collection)cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        if (cond.getMatchCampaign().booleanValue() && CollectionUtils.isEmpty((Collection)cond.getCodes()) && CollectionUtils.isEmpty((Collection)cond.getIds())) {
            return new ArrayList<PsProductVO>();
        }
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, (PsMatchCampaignCond)cond, true);
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByCond(PsProductCond cond, boolean matchGlobalCampaigns) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        if (CollectionUtils.isNotEmpty((Collection)cond.getIds())) {
            params.put("id", cond.getIds());
        }
        params.remove("ids");
        params.remove("memberLevel");
        params.remove("accessWay");
        if (CollectionUtils.isNotEmpty((Collection)cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        if (cond.getMatchCampaign().booleanValue() && CollectionUtils.isEmpty((Collection)cond.getCodes()) && CollectionUtils.isEmpty((Collection)cond.getIds())) {
            return new ArrayList<PsProductVO>();
        }
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, (PsMatchCampaignCond)cond, matchGlobalCampaigns);
        }
        return productVOList;
    }

    private void matchProductsCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond cond, boolean matchGlobalCampaigns) {
        if (matchGlobalCampaigns) {
            ArrayList<CampaignProductCondVO> productCondList = new ArrayList<CampaignProductCondVO>();
            for (PsProductVO productVO : productVOList) {
                CampaignProductCondVO productCondVO = new CampaignProductCondVO();
                productCondVO.setProductId(Long.valueOf(productVO.getId()));
                productCondVO.setCategoryId(productVO.getCategoryId());
                productCondList.add(productCondVO);
            }
            Map<String, List<PsCampaignVO>> campaignListMap = this.getProductCampaignListMapV2(productCondList, true, cond.getMemberLevel(), cond.getAccessWay());
            for (PsProductVO productVO : productVOList) {
                List<PsCampaignVO> campList = campaignListMap.get(productVO.getId());
                ArrayList<PsCampaignVO> list = new ArrayList<PsCampaignVO>();
                if (CollectionUtils.isNotEmpty(campList)) {
                    list.addAll(campList);
                }
                productVO.setCampaignList(list);
            }
        }
        this.matchProductCampaigns(productVOList, cond);
    }

    @Override
    public Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond) {
        List<PsProductVO> productList = this.findByCond(cond);
        if (EmptyUtil.isEmpty(productList)) {
            return new HashMap<String, List<PsCampaignVO>>();
        }
        HashMap<String, List<PsCampaignVO>> map = new HashMap<String, List<PsCampaignVO>>();
        for (PsProductVO productVO : productList) {
            List prodList = productVO.getCampaignList();
            map.put(productVO.getCode(), prodList);
        }
        return map;
    }

    @Deprecated
    public Map<String, List<PsCampaignVO>> getProductCampaignListMap(List<Long> productIdList, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(Integer.valueOf(1));
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductIdList(productIdList);
        cond.setCategoryId(cateId);
        cond.setFromRedis(Boolean.valueOf(true));
        cond.setContainsGlobal(Boolean.valueOf(containsGlobal));
        String params = JSON.toJSONString((Object)cond);
        ApiResult campaignResult = this.campaignClient.mapListCampaign(params);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            HashMap<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<String, List<PsCampaignVO>>();
            Map campaignVOListMap = (Map)campaignResult.getData();
            for (Long id : campaignVOListMap.keySet()) {
                List campaignVOList = (List)campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = PsProductDomainImpl.convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<String, List<PsCampaignVO>>();
    }

    public Map<String, List<PsCampaignVO>> getProductCampaignListMapV2(List<CampaignProductCondVO> productCondList, boolean containsGlobal, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setStateId(Integer.valueOf(1));
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductCondList(productCondList);
        cond.setFromRedis(Boolean.valueOf(true));
        cond.setContainsGlobal(Boolean.valueOf(containsGlobal));
        String params = JSON.toJSONString((Object)cond);
        ApiResult campaignResult = this.campaignClient.mapListCampaign_V1_0_1(params);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            HashMap<String, List<PsCampaignVO>> psCampaignListMap = new HashMap<String, List<PsCampaignVO>>();
            Map campaignVOListMap = (Map)campaignResult.getData();
            for (Long id : campaignVOListMap.keySet()) {
                List campaignVOList = (List)campaignVOListMap.get(id);
                List<PsCampaignVO> psCampaignVOList = PsProductDomainImpl.convertCampaignList(campaignVOList);
                psCampaignListMap.put(String.valueOf(id), psCampaignVOList);
            }
            return psCampaignListMap;
        }
        return new HashMap<String, List<PsCampaignVO>>();
    }

    public List<PsCampaignVO> getProductCampaignList(Long productId, boolean containsGlobal, Long cateId, Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setProductId(productId);
        cond.setCategoryId(cateId);
        cond.setFromRedis(Boolean.valueOf(true));
        cond.setContainsGlobal(Boolean.valueOf(containsGlobal));
        ApiResult campaignResult = this.campaignClient.listCampaign(cond);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            List campaignVOList = (List)campaignResult.getData();
            List<PsCampaignVO> psCampaignList = PsProductDomainImpl.convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<PsCampaignVO>();
    }

    @Override
    public List<PsCampaignVO> getGlobalCampaignList(Integer memberLevel, Integer accessWay) {
        CampaignCondVO cond = new CampaignCondVO();
        cond.setProductScope(Integer.valueOf(3));
        cond.setMemberLevel(memberLevel);
        cond.setAccessWay(accessWay);
        cond.setFromRedis(Boolean.valueOf(true));
        ApiResult campaignResult = this.campaignClient.listCampaign(cond);
        if (ApiUtils.isSuccess((ApiResult)campaignResult)) {
            List campaignVOList = (List)campaignResult.getData();
            List<PsCampaignVO> psCampaignList = PsProductDomainImpl.convertCampaignList(campaignVOList);
            return psCampaignList;
        }
        return new ArrayList<PsCampaignVO>();
    }

    private void matchProductCampaigns(List<PsProductVO> productVOList, PsMatchCampaignCond matchCampaignCond) {
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign() != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchProductCampaigns(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay());
        }
    }

    private void matchProductCampaigns(List<PsProductVO> productVOList, Integer memberLavel, Integer accessWay) {
        for (PsProductVO productVO : productVOList) {
            List campaignList = productVO.getCampaignList();
            if (EmptyUtil.isEmpty((List)campaignList)) continue;
            List<PsCampaignVO> matchedCampaignList = this.matchCampaignList(campaignList, memberLavel, accessWay);
            productVO.setCampaignList(matchedCampaignList);
        }
    }

    public List<PsCampaignVO> matchCampaignList(List<PsCampaignVO> campaignList, Integer memberLavel, Integer accessWay) {
        ArrayList<PsCampaignVO> results = new ArrayList<PsCampaignVO>();
        for (PsCampaignVO campaignVO : campaignList) {
            if (!this.matchCampaign(campaignVO, memberLavel, accessWay)) continue;
            results.add(campaignVO);
        }
        return results;
    }

    private boolean matchCampaign(PsCampaignVO campaignVO, Integer memberLavel, Integer accessWay) {
        Date now;
        List memberLevels = campaignVO.getMemberLevels();
        if (campaignVO.getState() != 1) {
            return false;
        }
        if (EmptyUtil.isNotEmpty((List)memberLevels) && memberLavel != null && !memberLevels.contains(memberLavel)) {
            return false;
        }
        List accessWayIds = campaignVO.getAccessWayIds();
        if (EmptyUtil.isNotEmpty((List)accessWayIds) && accessWay != null && !accessWayIds.contains(accessWay)) {
            return false;
        }
        Date startTime = campaignVO.getStartTime();
        Date expiredTime = campaignVO.getExpireTime();
        return startTime == null || expiredTime == null || !(now = new Date()).before(startTime) && !now.after(expiredTime);
    }

    @Override
    public List<PsProductVO> findByFields(Map<String, Object> params) {
        return this.client.findByFields(params, SearchType.ANDLIKE);
    }

    @Override
    public List<PsProductVO> findByNameOrNameCN(Map<String, Object> params) {
        return this.client.findByFields(params, SearchType.ORLIKE);
    }

    @Override
    public void calculateDiscountPrice(List<PsProductVO> productList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        for (PsProductVO productVO : productList) {
            this.calulateProductDiscountPrice(productVO, memberLevel, accessWay, discountAmount);
        }
    }

    @Override
    public void calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond) {
        BigDecimal originalPrice = new BigDecimal(String.valueOf(skuVO.getSalesPrice()));
        if (cond.getMatchCampaign() != null && cond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(Arrays.asList(productVO), cond, true);
            List campaignList = productVO.getCampaignList();
            skuVO.setCampaignList(campaignList);
            boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
            BigDecimal targetPrice = this.calculateDiscountPrice(allowVipDiscount, originalPrice, campaignList, cond.getMemberLevel(), cond.getAccessWay(), cond.getDiscount());
            skuVO.setDiscountPrice(targetPrice);
        }
    }

    @Override
    public void calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond) {
        PsProductVO productVO = this.findProdBySkuCode(skuVO.getSkuCode());
        if (productVO == null) {
            return;
        }
        this.calculateDiscountPrice(productVO, skuVO, cond);
    }

    private void calulateProductDiscountPrice(PsProductVO productVO, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        List campaignList = productVO.getCampaignList();
        BigDecimal originalPrice = productVO.getListPrice();
        boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
        BigDecimal targetPrice = this.calculateDiscountPrice(allowVipDiscount, originalPrice, campaignList, memberLevel, accessWay, discountAmount);
        productVO.setDiscountPrice(targetPrice);
    }

    private BigDecimal calculateDiscountPrice(Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount) {
        BigDecimal targetPrice = originalPrice;
        if (allowVipDiscount != null && allowVipDiscount.booleanValue()) {
            targetPrice = targetPrice.multiply(discountAmount);
        }
        for (PsCampaignVO campaign : campaignList) {
            PsCampaignSectionVO section;
            BigDecimal factor;
            List sectionList;
            if (campaign.getState() == null || campaign.getState() != 1 || campaign.getDiscountTypeId() != 1 || campaign.getStartTime() == null || campaign.getExpireTime() == null) continue;
            Date now = new Date();
            if (campaign.getStartTime().after(now) || campaign.getExpireTime().before(now) || CollectionUtils.isEmpty((Collection)(sectionList = campaign.getCampaignSectionList())) || (factor = (section = (PsCampaignSectionVO)sectionList.get(0)).getFactor()) == null) continue;
            targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
        }
        return targetPrice;
    }

    @Override
    public boolean updateBySkuCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return true;
        }
        if (skuCodes.size() > 100) {
            int all = skuCodes.size() / 100;
            int i = 0;
            while (i < all) {
                List<String> subSkuCodes = skuCodes.subList(i * 100, (i + 1) * 100);
                if (!this.updateBySkuCodes100(subSkuCodes)) {
                    throw new PublicException("\u66f4\u65b0prod updateTime \u51fa\u9519");
                }
                ++i;
            }
            if (skuCodes.size() > all * 100) {
                List<String> subSkuCodes = skuCodes.subList(all * 100, skuCodes.size());
                this.updateBySkuCodes100(subSkuCodes);
            }
            return true;
        }
        return this.updateBySkuCodes100(skuCodes);
    }

    private boolean updateBySkuCodes100(List<String> skuCodes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodes", skuCodes);
        params.put("pagenum", Integer.MAX_VALUE);
        List updateProds = this.client.findByFields(params, SearchType.OR);
        for (PsProductVO updateProd : updateProds) {
            List<PsSkuVO> prodSkus;
            if (CollectionUtils.isEmpty((Collection)updateProd.getSkuCodes()) || CollectionUtils.isEmpty(prodSkus = this.psSkuService.findBySkuCodes(updateProd.getSkuCodes()))) continue;
            PsSkuVO psSkuVO = prodSkus.get(0);
            if (updateProd.getSkuCodes().size() == 1) {
                updateProd.setListPrice(new BigDecimal(psSkuVO.getSalesPrice()));
            } else {
                for (PsSkuVO prodSku : prodSkus) {
                    if (!(updateProd.getListPrice().doubleValue() > prodSku.getSalesPrice())) continue;
                    updateProd.setListPrice(new BigDecimal(prodSku.getSalesPrice()).setScale(2, 5));
                }
            }
            updateProd.setCategoryId(psSkuVO.getCategoryId());
            updateProd.setCategoryCode(this.pcsSkuCategoryService.findById(psSkuVO.getCategoryId()).getCode());
        }
        if (CollectionUtils.isEmpty(updateProds)) {
            return true;
        }
        return this.update(updateProds);
    }

    public PsProductVO updateCategory(PsProductVO updateProd) {
        PsSkuVO psSkuVO = this.psSkuService.findBySkuCode((String)updateProd.getSkuCodes().get(0));
        if (NumberUtil.isNullOrZero((Number)psSkuVO.getCategoryId())) {
            return updateProd;
        }
        updateProd.setCategoryId(psSkuVO.getCategoryId());
        return updateProd;
    }

    @Override
    public PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.canSkus", skuCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("skuCodes", skuCode);
        params.put("onShelfChnCodes", chnCode);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return (PsProductVO)fs.get(0);
    }

    @Override
    public PsProductVO findProdBySkuCode(String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodes", skuCode);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return (PsProductVO)fs.get(0);
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode) {
        List<PcsSkuCategory> list = this.pcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List categories = BeanUtil.buildListFrom(list, PcsSkuCategoryVO.class);
        ArrayList<Long> cateIds = new ArrayList<Long>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryId", cateIds);
        int currpage = 1;
        params.put("pagenum", 20);
        params.put("currpage", currpage);
        ArrayList seqList = new ArrayList();
        ArrayList<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        ArrayList<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
        params.put("sort", seqList);
        ArrayList<PsProductVO> productVOs = new ArrayList<PsProductVO>(100);
        List prodVos = this.client.findByFields(params, SearchType.ANDLIKE);
        productVOs.addAll(prodVos);
        while (prodVos.size() == 20) {
            params.put("currpage", ++currpage);
            params.put("pagenum", 20);
            params.put("sort", seqList);
            prodVos = this.client.findByFields(params, SearchType.ANDLIKE);
            productVOs.addAll(prodVos);
        }
        return productVOs;
    }

    @Override
    public List<PsProductVO> findByProdSearchCondVO(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        LOGGER.info("===\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},prodSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        String key = prodSearchCondVO.getKeywords();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (Strings.isNullOrEmpty((String)key)) {
            ArrayList categoriesList = new ArrayList();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    List<PcsSkuCategory> list = this.pcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    List category = BeanUtil.buildListFrom((Collection)list, PcsSkuCategoryVO.class);
                    categoriesList.addAll(category);
                }
            }
            ArrayList<Long> cateIds = new ArrayList<Long>(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
            if (CollectionUtils.isEmpty(cateIds)) {
                return Collections.emptyList();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            if (isNew.booleanValue()) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    Date end = new Date();
                    dateRange.setEnd(end);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    ((Calendar)calendar).add(5, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }
            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();
            seqMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");
            if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
                seqMap.put("saleStartDate", "desc");
            } else if ("create_time".equals(sortField)) {
                seqMap.put("channelProdInfo.createTime", sortOrder);
            } else if ("price".equals(sortField)) {
                seqMap.put("listPrice", sortOrder);
            }
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);
            params.put("sort", seqMap);
            List<PsProductVO> productVOList = this.client.findByFieldWithProdSearchCondVO(params, SearchType.ANDLIKE, from, size);
            if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
                this.matchProductsCampaigns(productVOList, matchCampaignCond, true);
                this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
            }
            return productVOList;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");
        LOGGER.info("\u5173\u952e\u5b57\u67e5\u8be2\u7684\u53c2\u6570    params={} from={},size={},key={}", new Object[]{params, from, size, key});
        List<PsProductVO> productVOList = this.client.findByFieldWithKeyWords(params, SearchType.ANDLIKE, key, from, size);
        LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, matchCampaignCond, true);
            this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }
        List<PcsSkuCategory> list = this.pcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        List categories = BeanUtil.buildListFrom(list, PcsSkuCategoryVO.class);
        ArrayList<Long> cateIds = new ArrayList<Long>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        ArrayList seqList = new ArrayList();
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        String fieldName = categories.size() > 1 ? "sort1" : "sort2";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        seqMap.put("_script", map);
        map.put("script", "frontCategorySort");
        map.put("params", paramsMap);
        paramsMap.put("categoryIds", cateIds);
        paramsMap.put("fieldName", fieldName);
        map.put("order", "asc");
        map.put("mode", "min");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, matchCampaignCond, true);
            this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCodeCreateTime(String chnCode, Map<String, Date> dateRange, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("channelProdInfo.channelCode", chnCode);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("channelProdInfo.createTime", "desc");
        seqMap.put("code", "asc");
        params.put("sort", seqMap);
        HashMap<String, Date> chanelProdTime = new HashMap<String, Date>();
        chanelProdTime.put("createTimeStart", dateRange.get("createTimeStart"));
        chanelProdTime.put("createTimeEnd", dateRange.get("createTimeEnd"));
        params.put("chanelProdTime", chanelProdTime);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.matchProductsCampaigns(productVOList, matchCampaignCond, true);
            this.calculateDiscountPrice(productVOList, matchCampaignCond.getMemberLevel(), matchCampaignCond.getAccessWay(), matchCampaignCond.getDiscount());
        }
        return productVOList;
    }

    @Override
    public List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode) {
        ArrayList<PsProductVO> allProds = new ArrayList<PsProductVO>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryCode", cateCode);
        List productVOs = this.client.findByFields(params, SearchType.AND);
        if (CollectionUtils.isNotEmpty(productVOs)) {
            allProds.addAll(productVOs);
        }
        params.remove("categoryCode");
        params.put("categoryCodePRE", String.valueOf(cateCode) + "_");
        List productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isNotEmpty(productVOList)) {
            allProds.addAll(productVOList);
        }
        return allProds;
    }

    @Override
    public Map<String, PsProductVO> mapByProdCodes(List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            HashMap rt = Maps.newHashMapWithExpectedSize((int)codes.size());
            PsProductCond cond = new PsProductCond();
            cond.setCodes(codes);
            List<PsProductVO> prods = this.findByCond(cond);
            for (PsProductVO prod : prods) {
                rt.put(prod.getCode(), prod);
            }
            return rt;
        }
        return null;
    }
}

