/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsWatermarkMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsWatermarkDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuWatermark;
import com.thebeastshop.pegasus.merchandise.model.ProdWatermark;
import com.thebeastshop.pegasus.merchandise.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductWatermarkVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.management.OperationsException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsWatermarkDomain")
public class PcsWatermarkDomainImpl
implements PcsWatermarkDomain {
    private final Logger log = LoggerFactory.getLogger(PcsWatermarkDomainImpl.class);
    @Autowired
    private PcsWatermarkMapper pcsWatermarkMapper;
    @Autowired
    private PcsClPsDomain pcsClPsDomain;

    @Override
    @Transactional
    public int addIcon(PcsWatermarkVO watermarkVO) {
        int ret = this.pcsWatermarkMapper.insert(watermarkVO);
        if (ret > 0) {
            Random random = new Random();
            int n = random.nextInt(99);
            watermarkVO.setCode("W0" + n + watermarkVO.getId());
            this.pcsWatermarkMapper.update(watermarkVO);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateIcon(PcsWatermarkVO watermarkVO) {
        int ret = this.pcsWatermarkMapper.update(watermarkVO);
        if (ret > 0) {
            List<String> codeList = this.pcsWatermarkMapper.querySkuCodeListByWatermarkId(watermarkVO.getId());
            this.pcsClPsDomain.saveSkuCodeList(codeList, 1);
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList) {
        PcsSkuWatermark skuWatermark;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCode", skuCode);
        params.put("nowCodeList", codeList);
        List<PcsSkuWatermark> toDeleteSkuWatermarkList = this.pcsWatermarkMapper.queryToDeleteSkuWatermarkList(params);
        if (!toDeleteSkuWatermarkList.isEmpty()) {
            ArrayList<Long> toDelIdList = new ArrayList<Long>();
            int i = 0;
            while (i < toDeleteSkuWatermarkList.size()) {
                PcsSkuWatermark toDelSkuWatermark = toDeleteSkuWatermarkList.get(i);
                toDelIdList.add(toDelSkuWatermark.getId());
                ++i;
            }
            HashMap<String, Object> delParams = new HashMap<String, Object>();
            delParams.put("ids", toDelIdList);
            this.pcsWatermarkMapper.deleteSkuWatermarkByIds(delParams);
        }
        ArrayList<PcsSkuWatermark> skuWatermarkList = new ArrayList<PcsSkuWatermark>();
        int i = 0;
        while (i < codeList.size()) {
            String code = codeList.get(i);
            skuWatermark = new PcsSkuWatermark();
            skuWatermark.setSkuCode(skuCode);
            skuWatermark.setWatermarkCode(code);
            skuWatermarkList.add(skuWatermark);
            ++i;
        }
        int ret = 0;
        int i2 = 0;
        while (i2 < skuWatermarkList.size()) {
            skuWatermark = (PcsSkuWatermark)skuWatermarkList.get(i2);
            skuWatermark.setSort(i2);
            ret += this.saveOrUpdateSkuWatermark(skuWatermark);
            ++i2;
        }
        return ret;
    }

    @Override
    @Transactional
    public int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList, boolean isEmptyBeforeUpdate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isEmptyBeforeUpdate) {
            params.put("productId", prod.getProdId());
            List<ProdWatermark> toDeleteProdWatermarkList = this.pcsWatermarkMapper.queryToDeleteProductWatermarkList(params);
            if (!toDeleteProdWatermarkList.isEmpty()) {
                ArrayList<Long> toDelIdList = new ArrayList<Long>();
                int i = 0;
                while (i < toDeleteProdWatermarkList.size()) {
                    ProdWatermark toDelProdWatermark = toDeleteProdWatermarkList.get(i);
                    toDelIdList.add(toDelProdWatermark.getId());
                    ++i;
                }
                HashMap<String, Object> delParams = new HashMap<String, Object>();
                delParams.put("ids", toDelIdList);
                delParams.put("active", 0);
                int count = this.pcsWatermarkMapper.updateProdWatermarkActiveByIds(delParams);
                this.log.info("\u5220\u9664\uff1a" + count);
            }
        }
        ArrayList<ProdWatermark> prodWatermarkList = new ArrayList<ProdWatermark>();
        int i = 0;
        while (i < watermarkCodeList.size()) {
            String code = watermarkCodeList.get(i);
            ProdWatermark prodWatermark = new ProdWatermark();
            prodWatermark.setProductCode(prod.getProdCode());
            prodWatermark.setProductId(prod.getProdId());
            prodWatermark.setWatermarkCode(code);
            prodWatermarkList.add(prodWatermark);
            ++i;
        }
        int ret = 0;
        int i2 = 0;
        while (i2 < prodWatermarkList.size()) {
            ProdWatermark prodWatermark = (ProdWatermark)prodWatermarkList.get(i2);
            prodWatermark.setSort(i2);
            try {
                ret = this.saveOrUpdateProdWatermark(prodWatermark);
            }
            catch (OperationsException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        return ret;
    }

    @Override
    @Transactional
    public int deleteProdWatermarkByIds(List<String> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", idList);
        params.put("active", 0);
        int ret = this.pcsWatermarkMapper.updateProdWatermarkActiveByIds(params);
        return ret;
    }

    @Override
    public int saveOrUpdateSkuWatermark(PcsSkuWatermark skuWatermark) {
        int count = this.pcsWatermarkMapper.countOfSkuWatermark(skuWatermark);
        if (count == 0) {
            return this.pcsWatermarkMapper.insertSkuWatermark(skuWatermark);
        }
        return this.pcsWatermarkMapper.updateSkuWatermark(skuWatermark);
    }

    @Override
    public int saveOrUpdateProdWatermark(ProdWatermark prodWatermark) throws OperationsException {
        int count = this.pcsWatermarkMapper.countOfProdWatermark(prodWatermark);
        if (count == 0) {
            count = this.pcsWatermarkMapper.insertProdWatermark(prodWatermark);
            this.log.info("add record:" + prodWatermark.toString());
            if (count == 0) {
                throw new OperationsException("\u65b0\u589e\u5931\u8d25!");
            }
            return 1;
        }
        prodWatermark.setActive(1);
        count = this.pcsWatermarkMapper.updateProdWatermark(prodWatermark);
        if (count == 0) {
            throw new OperationsException("\u66f4\u65b0\u5931\u8d25!");
        }
        this.log.info("update record:" + prodWatermark.toString());
        return 2;
    }

    @Override
    public PcsWatermarkVO findWatermarkById(Long id) {
        return this.pcsWatermarkMapper.findWatermarkById(id);
    }

    @Override
    public List<PcsWatermarkVO> queryWatermarkList(Map<String, Object> params) {
        return this.pcsWatermarkMapper.queryWatermarkList(params);
    }

    @Override
    public List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond) {
        return this.pcsWatermarkMapper.queryProdWatermarkList(cond);
    }

    @Override
    public List<ProdSkuVO> queryProdWatermarkListByParams(List<String> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", idList);
        List<ProdSkuVO> prodWatermarkList = this.pcsWatermarkMapper.queryProdWatermarkListByParams(params);
        return prodWatermarkList;
    }

    @Override
    public List<ProdSkuVO> querySkuListByProd(Long prodId) {
        return this.pcsWatermarkMapper.querySkuListByProd(prodId);
    }

    @Override
    public List<ProdSkuVO> queryProdListBySkuCode(String code) {
        return this.pcsWatermarkMapper.queryProdListBySkuCode(code);
    }

    @Override
    public ProdSkuVO queryProductByProdId(Long prodId) {
        return this.pcsWatermarkMapper.queryProductByProdId(prodId);
    }

    @Override
    public Map<String, ProductWatermarkVO> seleckWatermarkByProductCodes(List<String> productCodes) {
        List<ProductWatermarkVO> productWatermarkVOs;
        this.log.info("===\u901a\u8fc7productcodes \u67e5\u8be2\u53ef\u4ee5\u4f7f\u7528\u7684\u6c34\u5370\u6807\u7b7e\u7684\u53c2\u6570\u4e3a productCodes={} ", productCodes);
        HashMap<String, ProductWatermarkVO> returnMap = new HashMap<String, ProductWatermarkVO>();
        if (CollectionUtils.isNotEmpty(productCodes) && CollectionUtils.isNotEmpty(productWatermarkVOs = this.pcsWatermarkMapper.seleckWatermarkByProductCodes(productCodes))) {
            for (ProductWatermarkVO productWatermarkVO : productWatermarkVOs) {
                returnMap.put(productWatermarkVO.getProductCode(), productWatermarkVO);
            }
        }
        return returnMap;
    }
}

