/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCmSplMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCmSplDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCmSplExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsSkuCmSplDomain")
public class PcsSkuCmSplDomainImpl
extends AbstractBaseDomain<PcsSkuCmSplVO, PcsSkuCmSpl>
implements PcsSkuCmSplDomain,
CheckAble {
    @Autowired
    private PcsSkuCmSplMapper pcsSkuCmSplMapper;

    @Override
    @Transactional
    public Long create(PcsSkuCmSpl record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setIsSelected(0);
            this.pcsSkuCmSplMapper.insertSelective(record);
            return record.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsSkuCmSpl record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsSkuCmSplMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsSkuCmSpl findById(long id) {
        return this.pcsSkuCmSplMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuCmSplVO> findBySkuCustomMadeId(long skuCustomMadeId) {
        List<PcsSkuCmSplVO> recordList = this.pcsSkuCmSplMapper.findPcsSkuCmSplBySkuCustomMadeId(skuCustomMadeId);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    @Transactional
    public boolean deleteById(long id) {
        PcsSkuCmSpl record = this.findById(id);
        if (EmptyUtil.isNotEmpty((Object)record)) {
            return this.pcsSkuCmSplMapper.deleteByPrimaryKey(id) != 0;
        }
        return false;
    }

    public Boolean check(Object obj) {
        PcsSkuCmSpl record = (PcsSkuCmSpl)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (EmptyUtil.isEmpty((Object)record.getSupplierId())) {
            throw new PurchaseException("PC0001", "\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (EmptyUtil.isEmpty((Object)record.getSkuCustomMadeId())) {
            throw new PurchaseException("PC0001", "SKU\u5b9a\u5236\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return true;
    }

    private Boolean check(PcsSkuCmSpl record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PcsSkuCmSplExample example = new PcsSkuCmSplExample();
        example.createCriteria().andSupplierIdEqualTo(record.getSupplierId()).andSkuCustomMadeIdEqualTo(record.getSkuCustomMadeId());
        List<PcsSkuCmSpl> oldList = this.pcsSkuCmSplMapper.selectByExample(example);
        if (oldList.size() > 0 && isCreate.booleanValue()) {
            throw new PurchaseException("PC0005", "supplierId\u548cskuCustomMadeId\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
        }
        if (oldList.size() > 0 && !isCreate.booleanValue() && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException("PC0005", "supplierId\u548cskuCustomMadeId\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
        }
        return true;
    }
}

