/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpProdCanSelfDeliveryMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdCanSelfDeliveryDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProdCanSelfDelivery;
import com.thebeastshop.pegasus.merchandise.model.OpProdCanSelfDeliveryExample;
import com.thebeastshop.pegasus.merchandise.vo.OpProdCanSelfDeliveryVO;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opProdCanSelfDeliveryDomain")
public class OpProdCanSelfDeliveryDomainImpl
extends AbstractBaseDomain<OpProdCanSelfDeliveryVO, OpProdCanSelfDelivery>
implements OpProdCanSelfDeliveryDomain {
    private static final Logger log = LoggerFactory.getLogger(OpProdCanSelfDeliveryDomainImpl.class);
    @Autowired
    private OpProdCanSelfDeliveryMapper opProdCanDeliveryMapper;

    @Override
    public boolean create(OpProdCanSelfDelivery delivery) {
        if (CollectionUtils.isNotEmpty(this.findByProdIdDistId(delivery.getProductId(), delivery.getDistrictId()))) {
            return false;
        }
        return this.opProdCanDeliveryMapper.insert(delivery) != 0;
    }

    @Override
    public boolean update(OpProdCanSelfDelivery delivery) {
        return this.opProdCanDeliveryMapper.updateByPrimaryKeySelective(delivery) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return this.opProdCanDeliveryMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public List<OpProdCanSelfDelivery> findByProdId(Long prodId) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        OpProdCanSelfDeliveryExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        return this.opProdCanDeliveryMapper.selectByExample(example);
    }

    private List<OpProdCanSelfDelivery> findByProdIdDistId(Long prodId, Long distId) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        OpProdCanSelfDeliveryExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        criteria.andDistrictIdEqualTo(distId);
        return this.opProdCanDeliveryMapper.selectByExample(example);
    }

    public boolean deleteByProdDistIds(Long prodId, List<Long> distIds) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        OpProdCanSelfDeliveryExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        criteria.andDistrictIdIn((List)distIds);
        return this.opProdCanDeliveryMapper.deleteByExample(example) != 0;
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        return this.opProdCanDeliveryMapper.deleteByExample(example) != 0;
    }
}

