/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpAttributeCond;
import com.thebeastshop.pegasus.merchandise.dao.OpAttributeMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeValueDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.model.OpAttribute;
import com.thebeastshop.pegasus.merchandise.model.OpAttributeExample;
import com.thebeastshop.pegasus.merchandise.model.OpAttributeValue;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeVO;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opAttributeDomain")
public class OpAttributeDomainImpl
extends AbstractBaseDomain<OpAttributeVO, OpAttribute>
implements OpAttributeDomain {
    @Autowired
    private OpAttributeMapper opAttributeMapper;
    @Autowired
    private OpAttributeValueDomain opAttributeValueDomain;

    @Override
    public int create(OpAttribute attribute) {
        attribute.setActive(true);
        attribute.setCreateTime(new Date());
        attribute.setUpdateTime(new Date());
        return this.opAttributeMapper.insert(attribute);
    }

    @Override
    public int createWithValues(OpAttributeVO attrVO) {
        OpAttribute attr = (OpAttribute)this.buildFromVO(attrVO);
        int ret = this.create(attr);
        if (ret == 0) {
            return 0;
        }
        attrVO.setId(attr.getId());
        List attrValueList = attrVO.getAttributeValueList();
        if (CollectionUtils.isNotEmpty((Collection)attrValueList)) {
            int i = 0;
            while (i < attrValueList.size()) {
                OpAttributeValueVO attrValueVO = (OpAttributeValueVO)attrValueList.get(i);
                attrValueVO.setAttributeId(attrVO.getId());
                OpAttributeValue attrValue = (OpAttributeValue)this.opAttributeValueDomain.buildFromVO(attrValueVO);
                ret += this.opAttributeValueDomain.create(attrValue);
                attrValueVO.setId(attrValue.getId());
                attrVO.getAttributeValueMap().put(attrValueVO.getValueText(), attrValueVO);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public boolean updateWithValues(OpAttributeVO attrVO) {
        OpAttribute attribute = (OpAttribute)this.buildFromVO(attrVO);
        int flag = this.opAttributeMapper.updateByPrimaryKeySelective(attribute);
        if (flag < 1) {
            return false;
        }
        List attrValueList = attrVO.getAttributeValueList();
        if (CollectionUtils.isNotEmpty((Collection)attrValueList)) {
            int i = 0;
            while (i < attrValueList.size()) {
                OpAttributeValueVO attrValueVO = (OpAttributeValueVO)attrValueList.get(i);
                OpAttributeValue attrValue = new OpAttributeValue();
                attrValue.setValueText(attrValueVO.getValueText());
                attrValue.setId(attrValueVO.getId());
                int ret = this.opAttributeValueDomain.update(attrValue);
                if (ret < 1) {
                    return false;
                }
                attrVO.getAttributeValueMap().put(attrValueVO.getValueText(), attrValueVO);
                ++i;
            }
        }
        return true;
    }

    @Override
    public Boolean update(OpAttribute attributeVO) {
        return null;
    }

    @Override
    public OpAttribute getById(Long id) {
        return null;
    }

    @Override
    public List<OpAttributeVO> findByCondition(OpAttributeCond cond) {
        OpAttributeExample example = new OpAttributeExample();
        OpAttributeExample.Criteria criteria = example.createCriteria();
        if (cond.getId() != null) {
            criteria.andIdEqualTo(cond.getId());
        }
        if (cond.getProductId() != null) {
            criteria.andProductIdEqualTo(cond.getProductId());
        }
        if (cond.getCombined() != null) {
            criteria.andCombinedEqualTo(cond.getCombined() != false ? 1 : 0);
        }
        if (cond.getActive() != null) {
            criteria.andActiveEqualTo(cond.getActive());
        }
        List<OpAttribute> list = this.opAttributeMapper.selectByExample(example);
        List<OpAttributeVO> attributeList = this.buildFromModelList(list);
        for (OpAttributeVO attributeVO : attributeList) {
            List<OpAttributeValueVO> attrValueList = this.opAttributeValueDomain.findOpAttributeValueByAttributeId(attributeVO.getId());
            attributeVO.setAttributeValueList(attrValueList);
        }
        return attributeList;
    }
}

