/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCustomizationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsTagVO;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;

public class SkuESClient
extends AbstractESClient<PsSkuVO> {
    public SkuESClient(String index, String type) {
        super(index, type);
    }

    public SkuESClient(String index, String type, String host, int port) {
        super(index, type, host, port);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode) {
        return this.build(hit, chnCode, null);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode, Long total) {
        PsSkuVO vo = new PsSkuVO();
        Map params = hit.getSource();
        vo.setSkuId(Long.valueOf((long)((Integer)params.get("skuId")).intValue() + 0L));
        vo.setSkuCode((String)params.get("skuCode"));
        vo.setSkuName((String)params.get("skuName"));
        vo.setSkuNameCN((String)params.get("skuNameCN"));
        vo.setSkuType((Integer)params.get("skuType"));
        vo.setIsMadeBySelf((Integer)params.get("isMadeBySelf"));
        vo.setIsImported((Integer)params.get("isImported"));
        vo.setSkuCustomMadeCode((String)params.get("customMadeCode"));
        vo.setCombinedSkuRecipeCode((String)params.get("combinedSkuRecipeCode"));
        vo.setEan13((String)params.get("ean13"));
        vo.setBarcode((String)params.get("barcode"));
        vo.setCanPurchase((Integer)params.get("canPurchase"));
        vo.setCanRemark((Integer)params.get("canRemark"));
        vo.setIsJit((Integer)params.get("isJit"));
        vo.setSalesPrice(Double.valueOf(MapUtils.getDoubleValue((Map)params, (Object)"salesPrice")));
        vo.setCategoryId(Long.valueOf((long)((Integer)params.get("categoryId")).intValue() + 0L));
        vo.setCategoryName((String)params.get("categoryName"));
        vo.setBrandId(Long.valueOf(MapUtils.getLongValue((Map)params, (Object)"brandId")));
        vo.setBrandName((String)params.get("brandName"));
        vo.setBrandNameCN((String)params.get("brandNameCN"));
        if (params.get("brandCountryId") != null) {
            vo.setBrandCountryId(Long.valueOf((long)((Integer)params.get("brandCountryId")).intValue() + 0L));
        }
        if (params.get("brandCountryName") != null) {
            vo.setBrandCountryName((String)params.get("brandCountryName"));
        }
        vo.setCanCustomize(MapUtils.getInteger((Map)params, (Object)"canCustomize"));
        if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
            vo.setCustomizationPrice(new BigDecimal(MapUtils.getString((Map)params, (Object)"customizationPrice")));
            List customizationMapList = (List)params.get("customizationList");
            ArrayList<PsSkuCustomizationVO> customizations = new ArrayList<PsSkuCustomizationVO>();
            if (CollectionUtils.isNotEmpty((Collection)customizationMapList)) {
                for (Map customizationMap : customizationMapList) {
                    PsSkuCustomizationVO customizationVO = new PsSkuCustomizationVO();
                    customizationVO.setId(MapUtils.getLong((Map)customizationMap, (Object)"id"));
                    customizationVO.setImageUrl(MapUtils.getString((Map)customizationMap, (Object)"imageUrl"));
                    customizationVO.setWordsLimit(MapUtils.getInteger((Map)customizationMap, (Object)"wordsLimit"));
                    customizationVO.setDescription(MapUtils.getString((Map)customizationMap, (Object)"description"));
                    customizations.add(customizationVO);
                }
                vo.setCustomizationList(customizations);
            }
        }
        vo.setSupplierId(Long.valueOf((long)((Integer)params.get("supplierId")).intValue() + 0L));
        vo.setSupplierName((String)params.get("supplierName"));
        vo.setSupplierNameCN((String)params.get("supplierNameCN"));
        vo.setPlaceOfOrigin((String)params.get("placeOfOrigin"));
        vo.setSkuCateName((String)params.get("skuCategoryName"));
        vo.setPointDeductPoint(new BigDecimal(MapUtils.getDoubleValue((Map)params, (Object)"pointDeductPoint")).setScale(2, 1));
        vo.setPointDeductRule((Integer)params.get("pointDeductRule"));
        vo.setPointDuductPrice(new BigDecimal(MapUtils.getDoubleValue((Map)params, (Object)"pointDuductPrice")).setScale(2, 1));
        vo.setCostPrice(new BigDecimal(MapUtils.getDoubleValue((Map)params, (Object)"costPrice")).setScale(2, 1));
        vo.setCrossBorderFlag((Integer)params.get("crossBorderFlag"));
        if (params.get("clearanceWay") != null) {
            Integer bd = (Integer)params.get("clearanceWay");
            String db = "" + bd;
            vo.setClearanceWay(Short.valueOf(db));
        }
        vo.setWeight((String)params.get("weight"));
        vo.setTaxNo((String)params.get("taxNo"));
        vo.setUpdateTime((String)params.get("updateTime"));
        vo.setWhetherConsignment((Integer)params.get("whetherConsignment"));
        return vo;
    }

    private List<PsTagVO> makeTagList(List<Map<String, String>> list) {
        ArrayList<PsTagVO> results = new ArrayList<PsTagVO>();
        int i = 0;
        while (i < list.size()) {
            Map<String, String> map = list.get(i);
            String icon = map.get("icon");
            String text = map.get("text");
            PsTagVO tagVO = new PsTagVO();
            tagVO.setIcon(icon);
            tagVO.setText(text);
            results.add(tagVO);
            ++i;
        }
        return results;
    }

    private List<Map<String, String>> makeTagMapList(List<PsTagVO> voList) {
        if (voList == null || voList.isEmpty()) {
            return ListUtils.EMPTY_LIST;
        }
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < voList.size()) {
            PsTagVO vo = voList.get(i);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("icon", vo.getIcon());
            map.put("text", vo.getText());
            mapList.add(map);
            ++i;
        }
        return mapList;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsSkuVO vo) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject().field("id", vo.getSkuCode()).field("skuId", vo.getSkuId()).field("skuCode", vo.getSkuCode()).field("skuName", vo.getSkuName()).field("skuNameCN", vo.getSkuNameCN()).field("skuType", vo.getSkuType()).field("isMadeBySelf", vo.getIsMadeBySelf()).field("isImported", vo.getIsImported()).field("skuCustomMadeCode", this.avoidNull(vo.getSkuCustomMadeCode())).field("combinedSkuRecipeCode", this.avoidNull(vo.getCombinedSkuRecipeCode())).field("isSkuCustomMade", vo.getIsSkuCustomMade()).field("isCombinedSkuRecipeCode", vo.getIsCombinedSkuRecipeCode()).field("ean13", this.avoidNull(vo.getEan13())).field("barcode", this.avoidNull(vo.getBarcode())).field("canPurchase", vo.getCanPurchase()).field("salesPrice", vo.getSalesPrice()).field("categoryId", (Object)NumberUtil.avoidNull((Number)vo.getCategoryId())).field("categoryName", this.avoidNull(vo.getCategoryName())).field("brandId", (Object)NumberUtil.avoidNull((Number)vo.getBrandId())).field("brandName", vo.getBrandName()).field("brandNameCN", vo.getBrandNameCN()).field("brandCountryId", vo.getBrandCountryId()).field("brandCountryName", vo.getBrandCountryName()).field("skuCategoryName", vo.getSkuCateName()).field("canRemark", vo.getCanRemark()).field("placeOfOrigin", vo.getPlaceOfOrigin()).field("isJit", vo.getIsJit()).field("supplierId", (Object)NumberUtil.avoidNull((Number)vo.getSupplierId())).field("supplierName", this.avoidNull(vo.getSupplierName())).field("supplierNameCN", this.avoidNull(vo.getSupplierNameCN())).field("pointDeductPoint", vo.getPointDeductPoint()).field("pointDeductRule", vo.getPointDeductRule()).field("pointDuductPrice", vo.getPointDuductPrice()).field("costPrice", vo.getCostPrice()).field("updateTime", vo.getUpdateTime()).field("crossBorderFlag", vo.getCrossBorderFlag()).field("clearanceWay", (Object)vo.getClearanceWay()).field("weight", vo.getWeight()).field("taxNo", vo.getTaxNo()).endObject();
            return builder;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String avoidNull(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getPrimaryKeyName() {
        return "skuCode";
    }
}

