/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.google.common.base.Strings;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.DateRange;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PsBaseVO;
import com.thebeastshop.pegasus.merchandise.vo.PsUpdateVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.lang3.StringUtils;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractESClient<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String host;
    protected int port;
    protected String index;
    protected String type;
    private static final String DEFAULT_HOME = "127.0.0.1";
    private static final int DEFAULT_PORT = 9300;
    private static final int DEFAULT_FROM = 0;
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int DEFAULT_PAGE_MAX_SIZE = Integer.MAX_VALUE;
    protected TransportClient client;

    public AbstractESClient(String index, String type) {
        this(index, type, DEFAULT_HOME, 9300);
    }

    public AbstractESClient(String index, String type, String host, int port) {
        this.index = index;
        this.type = type;
        this.host = host;
        this.port = port;
        this.client = new TransportClient().addTransportAddress((TransportAddress)new InetSocketTransportAddress(host, port));
    }

    public List<T> findAllByField(String name, String value) {
        return this.findByField(name, value, Integer.MAX_VALUE);
    }

    private void createMapping() {
        PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{this.index}).type(this.type);
        PutMappingResponse response = (PutMappingResponse)this.client.admin().indices().putMapping(mappingRequest).actionGet();
    }

    public List<T> findByField(String name, Object value, int count) {
        if (count < 1) {
            count = 20;
        }
        MatchAllQueryBuilder builder = null;
        if (StringUtils.isBlank((CharSequence)name)) {
            builder = QueryBuilders.matchAllQuery();
        } else {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            builder = boolQueryBuilder;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])new String[]{name}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<T> result = this.searchByQryBuilderWithSortList((QueryBuilder)builder, null, 0, count, null);
        return result;
    }

    public List<T> findByField(String name, Object value) {
        return this.findByField(name, value, 0);
    }

    private void setOrder(SortBuilder sortBuilder, String order) {
        if ("asc".equals(order.toLowerCase())) {
            sortBuilder.order(SortOrder.ASC);
        } else if ("desc".equals(order.toLowerCase())) {
            sortBuilder.order(SortOrder.DESC);
        }
    }

    private void setFilterMap(SortBuilder sortBuilder, Map map) {
        Map nestedFilterMap;
        String mode;
        String order = (String)map.get("order");
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            this.setOrder(sortBuilder, order);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mode = (String)map.get("mode")))) {
            if (sortBuilder instanceof FieldSortBuilder) {
                ((FieldSortBuilder)sortBuilder).sortMode(mode);
            } else if (sortBuilder instanceof ScriptSortBuilder) {
                ((ScriptSortBuilder)sortBuilder).sortMode(mode);
            }
        }
        if (EmptyUtil.isNotEmpty((Map)(nestedFilterMap = (Map)map.get("nested_filter")))) {
            if (EmptyUtil.isNotEmpty(nestedFilterMap.get("range"))) {
                Map rangeMap = (Map)nestedFilterMap.get("range");
                for (String key : rangeMap.keySet()) {
                    RangeFilterBuilder filterBuilder = FilterBuilders.rangeFilter((String)key);
                    Map value = (Map)rangeMap.get(key);
                    filterBuilder.from(value.get("from"));
                    filterBuilder.to(value.get("to"));
                    this.setNestedFilterByCond(sortBuilder, (BaseFilterBuilder)filterBuilder);
                }
            } else {
                BoolFilterBuilder filterBuilder = FilterBuilders.boolFilter();
                for (String key : nestedFilterMap.keySet()) {
                    Object value = nestedFilterMap.get(key);
                    filterBuilder.must((FilterBuilder)FilterBuilders.termFilter((String)key, value));
                }
                this.setNestedFilterByCond(sortBuilder, (BaseFilterBuilder)filterBuilder);
            }
        }
    }

    private void setNestedFilterByCond(SortBuilder sortBuilder, BaseFilterBuilder filterBuilder) {
        if (sortBuilder instanceof FieldSortBuilder) {
            ((FieldSortBuilder)sortBuilder).setNestedFilter((FilterBuilder)filterBuilder);
        } else if (sortBuilder instanceof ScriptSortBuilder) {
            ((ScriptSortBuilder)sortBuilder).setNestedFilter((FilterBuilder)filterBuilder);
        }
    }

    public List<T> searchByQryBuilderWithSortMap(QueryBuilder queryBuilder, String chnCode, int from, int size, Map sort) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false));
            if (sort != null && sort.size() > 0) {
                for (String key : sort.keySet()) {
                    Object value = sort.get(key);
                    if (key.equals("_script") && value instanceof Map) {
                        Map scriptMap = (Map)value;
                        String script = (String)scriptMap.get("script");
                        ScriptSortBuilder scriptSortBuilder = SortBuilders.scriptSort((String)script, (String)"number");
                        if (scriptMap.containsKey("params")) {
                            Map params = (Map)scriptMap.get("params");
                            scriptSortBuilder.setParams(params);
                        }
                        this.setFilterMap((SortBuilder)scriptSortBuilder, (Map)value);
                        searchRequestBuilder.addSort((SortBuilder)scriptSortBuilder);
                        continue;
                    }
                    FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)key);
                    if (value instanceof String) {
                        this.setOrder((SortBuilder)sortBuilder, (String)value);
                    } else if (value instanceof Map) {
                        this.setFilterMap((SortBuilder)sortBuilder, (Map)value);
                    }
                    searchRequestBuilder.addSort((SortBuilder)sortBuilder);
                }
            }
            searchRequestBuilder.addSort((SortBuilder)SortBuilders.fieldSort((String)this.getPrimaryKeyName()).order(SortOrder.ASC));
            SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.addSort((SortBuilder)SortBuilders.fieldSort((String)this.getPrimaryKeyName()).order(SortOrder.ASC)).execute().actionGet();
            SearchHits hits = searchResponse.getHits();
            long total = hits.getTotalHits();
            this.log.info("\u67e5\u8be2\u5230\u8bb0\u5f55\u6570=" + hits.getTotalHits());
            SearchHit[] searchHists = hits.getHits();
            if (searchHists.length > 0) {
                SearchHit[] searchHitArray = searchHists;
                int n = searchHists.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchHit hit = searchHitArray[n2];
                    if (this instanceof ProductClient) {
                        list.add(this.build(hit, chnCode, total));
                    } else {
                        list.add(this.build(hit, chnCode));
                    }
                    ++n2;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01");
        }
        return list;
    }

    public List<T> searchByQryBuilderWithSortList(QueryBuilder queryBuilder, String chnCode, int from, int size, List<List<String>> sort) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false));
            if (sort != null && sort.size() > 0) {
                for (List<String> mySort : sort) {
                    if (mySort.size() != 2) continue;
                    searchRequestBuilder.addSort((SortBuilder)SortBuilders.fieldSort((String)mySort.get(0)).order(mySort.get(1).equals(SortOrder.ASC.toString()) ? SortOrder.ASC : SortOrder.DESC));
                }
            }
            searchRequestBuilder.addSort((SortBuilder)SortBuilders.fieldSort((String)this.getPrimaryKeyName()).order(SortOrder.ASC));
            SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
            SearchHits hits = searchResponse.getHits();
            this.log.info("\u67e5\u8be2\u5230\u8bb0\u5f55\u6570=" + hits.getTotalHits());
            SearchHit[] searchHists = hits.getHits();
            if (searchHists.length > 0) {
                SearchHit[] searchHitArray = searchHists;
                int n = searchHists.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchHit hit = searchHitArray[n2];
                    list.add(this.build(hit, chnCode));
                    ++n2;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01" + e);
        }
        return list;
    }

    private List<T> searchByQryBuilderJoin(QueryBuilder queryBuilder, String chnCode, int from, int size) {
        ArrayList<T> list = new ArrayList<T>();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        QueryBuilders.disMaxQuery();
        QueryBuilders.prefixQuery((String)"", (String)"110");
        try {
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type, "pubsku"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false)).addSort((SortBuilder)SortBuilders.fieldSort((String)"id").order(SortOrder.ASC)).execute().actionGet();
            SearchHits hits = searchResponse.getHits();
            this.log.info("\u67e5\u8be2\u5230\u8bb0\u5f55\u6570=" + hits.getTotalHits());
            SearchHit[] searchHists = hits.getHits();
            if (searchHists.length > 0) {
                SearchHit[] searchHitArray = searchHists;
                int n = searchHists.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchHit hit = searchHitArray[n2];
                    list.add(this.build(hit, chnCode));
                    ++n2;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01");
        }
        return list;
    }

    public List<T> findByFields(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        Integer currage = (Integer)params.remove("currpage");
        Integer pagenum = (Integer)params.remove("pagenum");
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof Map && "chanelProdTime".equals(key)) {
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"channelProdInfo.channelCode", ((Map)val).get("channelCode"))).must((QueryBuilder)QueryBuilders.rangeQuery((String)"channelProdInfo.createTime").gt(((Map)val).get("createTimeStart")).lte(((Map)val).get("createTimeEnd")));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"channelProdInfo", (QueryBuilder)nestedBoolQuery));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        int size = pagenum != null && pagenum > 0 ? pagenum : 20;
        int start = currage != null && currage > 0 ? (currage - 1) * pagenum : 0;
        List<T> result = null;
        result = sortList != null ? this.searchByQryBuilderWithSortList((QueryBuilder)boolQueryBuilder, chnCode, start, size, sortList) : this.searchByQryBuilderWithSortMap((QueryBuilder)boolQueryBuilder, chnCode, start, size, sortMap);
        return result;
    }

    public boolean create(T vo) {
        String primaryKeyName = this.getPrimaryKeyName();
        this.updateTime(vo);
        Object primaryKeyValue = McReflectionUtil.getFieldValue(vo, (String)primaryKeyName);
        IndexResponse response = (IndexResponse)this.client.prepareIndex(this.index, this.type).setRefresh(true).setSource(this.getXContentBuilder(vo)).setId(primaryKeyValue.toString()).execute().actionGet();
        return response.isCreated();
    }

    public boolean create(List<T> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return false;
        }
        BulkRequestBuilder bulkBuilder = this.client.prepareBulk().setRefresh(true);
        String primaryKeyName = this.getPrimaryKeyName();
        for (T vo : vos) {
            this.updateTime(vo);
            Object primaryKeyValue = this.getPrimaryKeyValue(vo);
            bulkBuilder.add(this.client.prepareIndex(this.index, this.type).setRefresh(true).setSource(this.getXContentBuilder(vo)).setId(primaryKeyValue.toString()));
        }
        BulkResponse responses = (BulkResponse)bulkBuilder.execute().actionGet();
        return !responses.hasFailures();
    }

    public boolean deleteByPrimaryKey(Object id) {
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk().setRefresh(true);
        bulkRequestBuilder.add(new DeleteRequest(this.index, this.type, id.toString()));
        return !((BulkResponse)bulkRequestBuilder.execute().actionGet()).hasFailures();
    }

    public boolean deleteByPrimaryKey(List<String> ids) {
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk().setRefresh(true);
        for (String id : ids) {
            bulkRequestBuilder.add(new DeleteRequest(this.index, this.type, id.toString()));
        }
        return !((BulkResponse)bulkRequestBuilder.execute().actionGet()).hasFailures();
    }

    public boolean deleteAll() {
        DeleteMappingRequest deleteMappingRequest = new DeleteMappingRequest(new String[]{this.index}).types(new String[]{this.type});
        DeleteMappingResponse deleteMappingResponse = (DeleteMappingResponse)this.client.admin().indices().deleteMapping(deleteMappingRequest).actionGet();
        return deleteMappingResponse.isAcknowledged();
    }

    public boolean createOrUpdate(T vo) {
        Object primaryKeyValue;
        String primaryKeyName = this.getPrimaryKeyName();
        List<T> exists = this.findByField(primaryKeyName, primaryKeyValue = McReflectionUtil.getFieldValue(vo, (String)primaryKeyName));
        if (CollectionUtils.isEmpty(exists)) {
            return this.create(vo);
        }
        T exist = exists.get(0);
        return this.update(exist);
    }

    public boolean createOrUpdate(List<T> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return Boolean.TRUE;
        }
        for (T vo : vos) {
            this.createOrUpdate(vo);
        }
        return Boolean.TRUE;
    }

    public boolean update(List<T> vos) {
        BulkRequestBuilder bulkBuilder = this.client.prepareBulk().setRefresh(true);
        for (T vo : vos) {
            UpdateRequest request = this.buildUpdateRequest(vo);
            bulkBuilder.add(request);
        }
        return !((BulkResponse)bulkBuilder.execute().actionGet()).hasFailures();
    }

    public boolean update(T vo) {
        String primaryKeyName = this.getPrimaryKeyName();
        Object primaryKeyValue = this.getPrimaryKeyValue(vo);
        if (primaryKeyValue == null || StringUtils.isBlank((CharSequence)primaryKeyValue.toString())) {
            throw new PublicException("PB0001", "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map params = McReflectionUtil.getFieldNameValue(vo);
        if (MapUtils.isEmpty((Map)params)) {
            return true;
        }
        try {
            UpdateResponse response = (UpdateResponse)this.client.update(this.buildUpdateRequest(vo)).actionGet();
            return response.getVersion() > 0L;
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            throw new PublicException("PB0002", "\u66f4\u65b0\u51fa\u9519\uff01");
        }
    }

    private UpdateRequest buildUpdateRequest(T vo) {
        Object primaryKeyValue = this.getPrimaryKeyValue(vo);
        if (primaryKeyValue == null) {
            throw new PublicException("PB0001", "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.updateTime(vo);
        Map params = McReflectionUtil.getFieldNameValue(vo);
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.index(this.index);
        updateRequest.type(this.type);
        updateRequest.id(primaryKeyValue.toString());
        updateRequest.refresh(true);
        UpdateRequestBuilder updateRequestBuilder = this.client.prepareUpdate(this.index, this.type, (String)primaryKeyValue).setRefresh(true);
        params.remove(this.getPrimaryKeyName());
        XContentBuilder builder = null;
        try {
            builder = XContentFactory.jsonBuilder();
            String updateTime = (String)params.get("updateTime");
            if (StringUtils.isNotBlank((CharSequence)updateTime)) {
                params.put("updateLong", DateUtil.parse((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            }
            this.buildUpdateParams(builder, params);
            updateRequest.doc(builder);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PublicException("PB0002", "\u6279\u91cf\u66f4\u65b0\u51fa\u9519\uff01");
        }
        return updateRequest;
    }

    private void buildUpdateParams(XContentBuilder builder, Map<String, Object> params) {
        try {
            builder.startObject();
            for (String key : params.keySet()) {
                List vos;
                Object val = params.get(key);
                if (val instanceof List && CollectionUtils.isNotEmpty((Collection)(vos = (List)val)) && vos.get(0) instanceof PsBaseVO) {
                    builder.startArray(key);
                    for (Object obj : vos) {
                        this.updateTime(obj);
                        this.buildUpdateParams(builder, McReflectionUtil.getFieldNameValue(obj));
                    }
                    builder.endArray();
                    continue;
                }
                builder.field(key, val);
            }
            builder.endObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object getPrimaryKeyValue(T vo) {
        return McReflectionUtil.getFieldValue(vo, (String)this.getPrimaryKeyName());
    }

    private void updateTime(Object obj) {
        if (obj instanceof PsUpdateVO) {
            ((PsUpdateVO)obj).setUpdateTime(this.getNow());
        }
    }

    String getNow() {
        return DateUtil.format((Date)DateUtil.getNow(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public abstract T build(SearchHit var1, String var2);

    public abstract T build(SearchHit var1, String var2, Long var3);

    public abstract XContentBuilder getXContentBuilder(T var1);

    public abstract String getPrimaryKeyName();

    public void queryCondPrepare(BoolQueryBuilder queryBuilder, Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        String updateTime = (String)params.get("updateTime");
        String updateTimeEnd = this.getNow();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{updateTime})) {
            RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)"updateLong");
            rangeBuilder.gte(DateUtil.parse((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                queryBuilder.should((QueryBuilder)rangeBuilder);
            } else {
                queryBuilder.must((QueryBuilder)rangeBuilder);
            }
        }
        params.remove("updateTime");
        String primaryUpdateTime = (String)params.get("primaryUpdateTime");
        String primaryUpdateTimeEnd = this.getNow();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{primaryUpdateTime})) {
            RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)"primaryUpdateLong");
            rangeBuilder.gte(DateUtil.parse((String)primaryUpdateTime, (String)"yyyy-MM-dd HH:mm:ss").getTime());
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                queryBuilder.should((QueryBuilder)rangeBuilder);
            } else {
                queryBuilder.must((QueryBuilder)rangeBuilder);
            }
        }
        params.remove("primaryUpdateTime");
    }

    void addQueryBuilder(BoolQueryBuilder boolQueryBuilder, QueryBuilder queryBuilder, com.thebeastshop.pegasus.merchandise.constants.SearchType type) {
        if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
            boolQueryBuilder.should(queryBuilder);
        } else {
            boolQueryBuilder.must(queryBuilder);
        }
    }

    public void testQuery() {
        this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setExtraSource("");
    }

    public List<T> findByFieldWithProdSearchCondVO(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type, Integer from, Integer size) {
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof DateRange) {
                Date start = ((DateRange)val).getStart();
                Date end = ((DateRange)val).getEnd();
                BoolQueryBuilder nestedBoolQuery = QueryBuilders.boolQuery();
                nestedBoolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).gt((Object)start).lte((Object)end));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.nestedQuery((String)"channelProdInfo", (QueryBuilder)nestedBoolQuery));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<T> result = null;
        result = sortList != null ? this.searchByQryBuilderWithSortList((QueryBuilder)boolQueryBuilder, chnCode, from, size, sortList) : this.searchByQryBuilderWithSortMap((QueryBuilder)boolQueryBuilder, chnCode, from, size, sortMap);
        return result;
    }

    public List<T> findByFieldWithKeyWords(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type, String keyWords, Integer from, Integer size) {
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof DateRange) {
                Date start = ((DateRange)val).getStart();
                Date end = ((DateRange)val).getEnd();
                RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)key);
                rangeBuilder.from((Object)start).to((Object)end).includeLower(true).includeUpper(true);
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)rangeBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)rangeBuilder);
                continue;
            }
            if (!Strings.isNullOrEmpty((String)keyWords)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"stocks.soldOut", (String)"0"));
                String[] fields = new String[]{"name", "nameCn", "brandList.brandName", "brandList.brandNameCN", "labels", "frontCategories.categoryFullName", "description", "campaignList.discountTypeName", "campaignList.title"};
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)keyWords).field("name")).should((QueryBuilder)QueryBuilders.queryStringQuery((String)keyWords).field("nameCn")).should((QueryBuilder)QueryBuilders.queryStringQuery((String)keyWords).field("brandList.brandNameCN")).should((QueryBuilder)QueryBuilders.queryStringQuery((String)keyWords).field("frontCategories.categoryFullName")).should((QueryBuilder)QueryBuilders.queryStringQuery((String)keyWords).field("description")).should((QueryBuilder)QueryBuilders.queryStringQuery((String)keyWords).field("campaignList.discountTypeName")).should((QueryBuilder)QueryBuilders.queryStringQuery((String)keyWords).field("campaignList.title")).should((QueryBuilder)QueryBuilders.fuzzyLikeThisQuery((String[])fields).likeText(keyWords).analyzer("ik"));
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<T> result = null;
        result = this.searchByQryBuilderWithKeyWordsSortMap((QueryBuilder)boolQueryBuilder, chnCode, from, size, sortMap);
        return result;
    }

    public List<T> findByFieldWithSelectMap(Map<String, Object> params, com.thebeastshop.pegasus.merchandise.constants.SearchType type, Map<String, Object> selectMap, Integer from, Integer size) {
        String queryString = params.values().toString();
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)queryString);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        String chnCode = MapUtils.getString(params, (Object)"chnCode");
        if (chnCode != null) {
            params.remove("chnCode");
        }
        List sortList = null;
        Map sortMap = null;
        if (params.get("sort") != null) {
            Object sortObj = params.remove("sort");
            if (sortObj instanceof List) {
                sortList = (List)sortObj;
            } else if (sortObj instanceof Map) {
                sortMap = (Map)sortObj;
            }
        }
        this.queryCondPrepare(boolQueryBuilder, params, type);
        for (String key : params.keySet()) {
            Object val = params.get(key);
            if (key.endsWith("List")) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)val.toString()).field(key));
                continue;
            }
            if (val instanceof List) {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                for (Object obj : (List)val) {
                    orBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)obj.toString()).field(key));
                }
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)orBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)orBuilder);
                continue;
            }
            if (val instanceof DateRange) {
                Date start = ((DateRange)val).getStart();
                Date end = ((DateRange)val).getEnd();
                RangeQueryBuilder rangeBuilder = QueryBuilders.rangeQuery((String)key);
                rangeBuilder.from((Object)start).to((Object)end).includeLower(true).includeUpper(true);
                if (com.thebeastshop.pegasus.merchandise.constants.SearchType.isOr(type)) {
                    boolQueryBuilder.should((QueryBuilder)rangeBuilder);
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)rangeBuilder);
                continue;
            }
            Object isCrossBorder = selectMap.get("isCrossBorder");
            Object labels = selectMap.get("labels");
            if (isCrossBorder != null) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"stocks.soldOut", (String)"0"));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"crossBorderFlag", (String)"1"));
            }
            if (labels != null) {
                String labelsObj = labels.toString();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"stocks.soldOut", (String)"0"));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"labels", (String)labelsObj));
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.OR.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.AND.equals((Object)type)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                continue;
            }
            if (com.thebeastshop.pegasus.merchandise.constants.SearchType.ORLIKE.equals((Object)type)) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
                continue;
            }
            if (!com.thebeastshop.pegasus.merchandise.constants.SearchType.ANDLIKE.equals((Object)type)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)val, (String[])new String[]{key}).type((Object)MatchQueryBuilder.Type.PHRASE_PREFIX));
        }
        List<T> result = null;
        result = this.searchByQryBuilderWithKeyWordsSortMap((QueryBuilder)boolQueryBuilder, chnCode, from, size, sortMap);
        return result;
    }

    public List<T> searchByQryBuilderWithKeyWordsSortMap(QueryBuilder queryBuilder, String chnCode, int from, int size, Map sort) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery(queryBuilder).setFrom(from).setSize(size).setQueryCache(Boolean.valueOf(false));
            if (sort != null && sort.size() > 0) {
                for (String key : sort.keySet()) {
                    Object value = sort.get(key);
                    if (key.equals("_script") && value instanceof Map) {
                        Map scriptMap = (Map)value;
                        String script = (String)scriptMap.get("script");
                        ScriptSortBuilder scriptSortBuilder = SortBuilders.scriptSort((String)script, (String)"number");
                        if (scriptMap.containsKey("params")) {
                            Map params = (Map)scriptMap.get("params");
                            scriptSortBuilder.setParams(params);
                        }
                        this.setFilterMap((SortBuilder)scriptSortBuilder, (Map)value);
                        searchRequestBuilder.addSort((SortBuilder)scriptSortBuilder);
                        continue;
                    }
                    FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)key);
                    if (value instanceof String) {
                        this.setOrder((SortBuilder)sortBuilder, (String)value);
                    } else if (value instanceof Map) {
                        this.setFilterMap((SortBuilder)sortBuilder, (Map)value);
                    }
                    searchRequestBuilder.addSort((SortBuilder)sortBuilder);
                }
            }
            SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
            SearchHits hits = searchResponse.getHits();
            long total = hits.getTotalHits();
            this.log.info("\u67e5\u8be2\u5230\u8bb0\u5f55\u6570=" + hits.getTotalHits());
            SearchHit[] searchHists = hits.getHits();
            if (searchHists.length > 0) {
                SearchHit[] searchHitArray = searchHists;
                int n = searchHists.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchHit hit = searchHitArray[n2];
                    list.add(this.build(hit, chnCode, total));
                    ++n2;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new PublicException("PB0005", "\u67e5\u8be2\u51fa\u9519\uff01");
        }
        return list;
    }
}

