package com.thebeastshop.pegasus.merchandise.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsSku;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Service("mcPcsSkuService")
public class McPcsSkuServiceImpl implements McPcsSkuService {

    @Autowired
    private PcsSkuDomain pcsSkuDomain;

    @Autowired
    private PcsSkuSalesPriceChangeDomain pcsSkuSalesPriceChangeDomain;
    
    @Override
    public Long create(PcsSkuVO vo) {
        return pcsSkuDomain.create(pcsSkuDomain.buildFromVO(vo));
    }

    @Override
    public List<Long> createSkus(List<PcsSkuVO> list) {
        List<PcsSku> skuList = new ArrayList<>();
        for (PcsSkuVO pcsSkuVO : list) {
            pcsSkuVO.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
            skuList.add(pcsSkuDomain.buildFromVO(pcsSkuVO));
        }
        return pcsSkuDomain.createSkus(skuList);
    }


    @Override
    public boolean update(PcsSkuVO vo) {
        return pcsSkuDomain.update(pcsSkuDomain.buildFromVO(vo));
    }

    @Override
    public PcsSkuVO findById(long id) {
        PcsSku record = pcsSkuDomain.findById(id);
        PcsSkuVO vo = pcsSkuDomain.buildFromModel(record);
        return vo;
    }

    @Override
    public PcsSkuVO findByCode(String code) {
        return pcsSkuDomain.findByCode(code);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories) {
        return pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories);
    }

    @Override
    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories, boolean withBuyerName) {
        return pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories, withBuyerName);
    }

    @Override
    public List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode) {
        return pcsSkuDomain.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }

    @Override
    public Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode) {
        return pcsSkuDomain.findSkuCanSaleAndCanSeeInfo(channelCode,skuCode);
    }

    @Override
    public List<PcsSkuVO> findByNameOrCode(String nameCode) {
        return pcsSkuDomain.findByNameOrCode(nameCode);
    }

    @Override
    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return pcsSkuDomain.findByCond(cond);
    }

    @Override
    public List<PcsSkuVO> findByCondForExport(PcsSkuCond cond) {
        return pcsSkuDomain.findByCondForExport(cond);
    }

    @Override
    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return pcsSkuDomain.findSkuTagByCond(cond);
    }

    @Override
    public Boolean canUpdateSkuSalesPrice(String code) {
        PcsSkuVO vo = pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty(vo)) {
            return pcsSkuDomain.canUpdateSalesPrice(code);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
        }
    }

    @Override
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
        return pcsSkuDomain.auditSkuSalesPriceChange(code, isPass, type);
    }

    @Override
    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return pcsSkuDomain.findSkuSalesPriceChangeByCodeAndProcessing(code);
    }

    @Override
    public List<PcsSkuVO> findSkuByCodes(List<String> codes) {
        return pcsSkuDomain.findByCodes(codes);
    }

    @Override
    public List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories) {
        return pcsSkuDomain.findByCodes(codes, withCategories);
    }

    @Override
    public List<PcsSkuVO> findSkuByCodesWithCategories(List<String> codes, boolean withCategories) {
        return pcsSkuDomain.findByCodes(codes, withCategories);
    }

    @Override
    public Boolean convertSku(PcsSkuVO sku, long skuCustomMadeId) {
        PcsSku pcsSku = pcsSkuDomain.buildFromVO(sku);
        return pcsSkuDomain.convertSku(pcsSku, skuCustomMadeId);
    }


    @Override
    public List<PcsSkuInfoVO> allSkuInfo() {
        return pcsSkuDomain.allSkuInfo();
    }

    @Override
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return pcsSkuDomain.findStockByCode(skuCode);
    }

    @Override
    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return pcsSkuDomain.findChannelSkuForNoDistribute(cond);
    }

    @Override
    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId) {
        pcsSkuDomain.setSkuChannel(skuCodeList,channelCodeList,operatorId);
    }

    @Override
    public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
        return pcsSkuDomain.findSkuByIds(ids);
    }

    @Override
    public Boolean canUpdateCostPrice(String code) {
        PcsSkuVO vo = pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty(vo)) {
            return pcsSkuDomain.canUpdateCostPrice(code);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
        }

    }

    @Override
    public Boolean canUpdateSupplier(String code) {
        PcsSkuVO vo = pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty(vo)) {
            return pcsSkuDomain.canUpdateSupplier(code);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_NOTHING, "无效的code");
        }
    }

    @Override
    public long countSkuByCond(PcsSkuCond cond) {
        return pcsSkuDomain.countSkuByCond(cond);
    }

    @Override
    public String getCrossBorderFlagByCodes(List<String> codes) {
        return pcsSkuDomain.getCrossBorderFlagByCodes(codes);
    }

    @Override
    public Integer updateSkuCategoryNameByCode(String skuCategoryName, String skuCode) {
        return pcsSkuDomain.updateSkuCategoryNameByCode(skuCategoryName, skuCode);
    }

    @Override
    public List<Integer> getSalesPriceByCodes(List<String> codes) {
        return pcsSkuDomain.getSalesPriceByCodes(codes);
    }

    @Override
    public List<Map> getSalesPriceByProdId(Long prodId) {
        return pcsSkuDomain.getSalesPriceByProdId(prodId);
    }

    @Override
    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
        return pcsSkuDomain.findSkuAuditByIds(ids);
    }

    @Override
    public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
        return pcsSkuDomain.selectByBarCode(barCode);
    }

	@Override
	public List<PcsSkuVO> findSkuBySupplierId(Long supplierId) {
		return pcsSkuDomain.findSkuBySupplierId(supplierId);
	}

	@Override
	public boolean updatePrdcRecipeSkuCost(PcsSkuVO vo) {
		int skuStatus = vo.getSkuStatus();
		String skuCode = vo.getCode();
		PcsSku pcsSku = new PcsSku();
		pcsSku.setId(vo.getId());
		switch(skuStatus) {
			case 0://草稿
				pcsSku.setCostPrice(vo.getCostPrice());
				pcsSku.setOldCostPrice(vo.getOldCostPrice());
				
			case 1://待财务审核
				pcsSku.setSkuStatus(1);
				List<PcsSkuCostPriceChange> costPriceChangeList = pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 1);
				if(EmptyUtil.isNotEmpty(costPriceChangeList)) {
					PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
					pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
					pcsSkuCostPriceChange.setChangeTime(new Date());
					pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
					pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
				}
				break;
				
			case 2://已驳回
				pcsSku.setSkuStatus(1);
				PcsSkuCostPriceChange pcsSkuCostPriceChange = new PcsSkuCostPriceChange();
				pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
				pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
				pcsSkuCostPriceChange.setSkuCode(skuCode);
				pcsSkuCostPriceChange.setChangeTime(new Date());
				pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange);
				break;
				
			case 3://待品类经理审核
				pcsSku.setSkuStatus(1);
				costPriceChangeList = pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 4);
				if(EmptyUtil.isNotEmpty(costPriceChangeList)) {
					pcsSkuCostPriceChange = costPriceChangeList.get(0);
					pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
					pcsSkuCostPriceChange.setChangeTime(new Date());
					pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
					pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
				}
				break;
				
			case 9://可用
				pcsSku.setSkuStatus(1);
				PcsSkuCostPriceChange pcsSkuCostPriceChange1 = new PcsSkuCostPriceChange();
				pcsSkuCostPriceChange1.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
				pcsSkuCostPriceChange1.setNewPrice(vo.getCostPrice());
				pcsSkuCostPriceChange1.setSkuCode(skuCode);
				pcsSkuCostPriceChange1.setChangeTime(new Date());
				pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange1);
				break;
				
				default:
					break;
				
		}
		pcsSkuDomain.updateSku(pcsSku);
		return false;
	}

	@Override
	public int updateSku(PcsSkuVO vo) {
		PcsSku pcsSku = new PcsSku();
		BeanUtils.copyProperties(vo, pcsSku);
		return pcsSkuDomain.updateSku(pcsSku);
	}

	@Override
	public boolean costPriceNeedApproval(PcsSkuVO vo) {
		PcsSku pcsSku = new PcsSku();
		BeanUtils.copyProperties(vo, pcsSku);
		return pcsSkuDomain.costPriceNeedApproval(pcsSku);
	}
}
