package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuImgDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuImg;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuImgService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuImgVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.List;

/**
 * Created by roy on 16-2-19.
 */
@Path("/sku/img")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsSkuImgService")
public class McPcsSkuImgServiceImpl implements McPcsSkuImgService {

    @Autowired
    private PcsSkuImgDomain pcsSkuImgDomain;

    @POST
    @Override
    public boolean create(PcsSkuImgVO vo) {
        PcsSkuImg pcsSkuImg = BeanUtil.buildFrom(vo, PcsSkuImg.class);
        return pcsSkuImgDomain.create(pcsSkuImg);
    }

    @PUT
    @Override
    public boolean update(PcsSkuImgVO vo) {
        PcsSkuImg pcsSkuImg = BeanUtil.buildFrom(vo, PcsSkuImg.class);
        return pcsSkuImgDomain.update(pcsSkuImg);
    }

    @POST
    @Path("list")
    @Override
    public boolean createList(List<PcsSkuImgVO> vos) {
        List<PcsSkuImg> pcsSkuImgs = BeanUtil.buildListFrom(vos, PcsSkuImg.class);
        return pcsSkuImgDomain.create(pcsSkuImgs);
    }

    @GET
    @Path("code/{code}/enable/{enable}")
    @Override
    public List<PcsSkuImgVO> findByCode(
            @PathParam("code") String code, @PathParam("enable") Boolean isEnable) {
        List<PcsSkuImg> pcsSkuImgs = pcsSkuImgDomain.findByCode(code, isEnable);
        return BeanUtil.buildListFrom(pcsSkuImgs, PcsSkuImgVO.class);
    }
}
