/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;


import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsBrandDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: McPcsBrandServiceImpl.java, v 0.1 2015-07-10 下午4:53
 */
@Path("/brand")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsBrandService")
public class McPcsBrandServiceImpl implements McPcsBrandService {

    @Autowired
    private PcsBrandDomain pcsBrandDomain;


    @Override
    public Long create(PcsBrandVO record, boolean saveDraft) {
        return pcsBrandDomain.create(pcsBrandDomain.buildFromVO(record), saveDraft);
    }

    @POST
    @Path("")
    @Override
    public Long createBrand(PcsBrandVO vo) {
        return pcsBrandDomain.create(pcsBrandDomain.buildFromVO(vo), vo.isSaveDraft());
    }


    @Override
    public boolean update(PcsBrandVO record, boolean saveDraft) {
        return pcsBrandDomain.update(pcsBrandDomain.buildFromVO(record), saveDraft);
    }

    @PUT
    @Path("")
    @Override
    public boolean updateBrand(PcsBrandVO vo) {
        return pcsBrandDomain.update(pcsBrandDomain.buildFromVO(vo), vo.isSaveDraft());
    }

    @GET
    @Path("{id:\\d=}")
    @Override
    public PcsBrandVO findById(@PathParam("id") long id) {
        return pcsBrandDomain.buildFromModel(pcsBrandDomain.findById(id));
    }

    @Override
    public List<PcsBrandVO> findByCond(PcsBrandCond cond) {
        return pcsBrandDomain.findByCond(cond);
    }

    @GET
    @Path("name/{name}")
    @Override
    public List<PcsBrandVO> findByName(@PathParam("name") String name) {
        return BeanUtil.buildListFrom(pcsBrandDomain.findByName(name), PcsBrandVO.class);
    }

    @Override
    public List<PcsBrandVO> findByIds(List<Long> ids) {
        return BeanUtil.buildListFrom(pcsBrandDomain.findByIds(ids), PcsBrandVO.class);
    }

    @Override
    public Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type) {
        return pcsBrandDomain.auditBrand(userId, id, isPass, type);
    }

    @Override
    public long countByCond(PcsBrandCond cond) {
        return pcsBrandDomain.countByCond(cond);
    }

}