package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.OpSpvPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.model.OpSpvPriceChange;
import com.thebeastshop.pegasus.merchandise.service.McOpSpvPriceChangeService;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvPriceChangeVO;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * SPV价格变动服务
 * @author gongjun
 * @since 2016-10-29
 */
public class McOpSpvPriceChangeServiceImpl implements McOpSpvPriceChangeService {

    @Autowired
    private OpSpvPriceChangeDomain opSpvPriceChangeDomain;

    @Override
    public Long create(OpSpvPriceChangeVO opSpvPriceChangeVO) {
        opSpvPriceChangeDomain.create(opSpvPriceChangeDomain.buildFromVO(opSpvPriceChangeVO));
        return opSpvPriceChangeVO.getId();
    }

    @Override
    public Boolean update(OpSpvPriceChangeVO opSpvPriceChangeVO) {
        int ret = opSpvPriceChangeDomain.update(opSpvPriceChangeDomain.buildFromVO(opSpvPriceChangeVO));
        return ret > 0;
    }

    @Override
    public OpSpvPriceChangeVO getCurrentAduitPrice(Long spvId) {
        OpSpvPriceChange opSpvPriceChange = opSpvPriceChangeDomain.getCurrentAduitPrice(spvId);
        return opSpvPriceChangeDomain.buildFromModel(opSpvPriceChange);
    }
}
