/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.OpChannelDomain;
import com.thebeastshop.pegasus.merchandise.model.OpChannel;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.ChannelSelectorVO;
import com.thebeastshop.pegasus.merchandise.cond.OpChannelCond;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.util.comm.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Royan
 * @version $Id: OpChannelServiceImpl.java, v 0.1 2015-07-27 下午2:02
 */
@Service("mcOpChannelService")
public class McOpChannelServiceImpl implements McOpChannelService {

    private final static Logger LOGGER = LoggerFactory.getLogger(McOpChannelServiceImpl.class);

    @Autowired
    private OpChannelDomain opChannelDomain;


    @Override
    public Long create(OpChannelVO channel) {
        opChannelDomain.create(opChannelDomain.buildFromVO(channel));
        return channel.getId();
    }

    @Override
    public boolean update(OpChannelVO channel) {
        return opChannelDomain.update(opChannelDomain.buildFromVO(channel));
    }

    @Override
    public boolean deleteById(Long id) {
        return opChannelDomain.deleteById(id);
    }

    @Override
    public OpChannelVO findById(Long id) {
        OpChannel opChannel = opChannelDomain.findById(id);
        return opChannelDomain.buildFromModel(opChannel);
    }

    @Override
    public List<OpChannelVO> findChannelByCond(String cond) {
        List<OpChannel> list = opChannelDomain.findChannelByCond(cond);
        return  BeanUtil.buildListFrom(list,OpChannelVO.class);
    }

    @Override
    public List<OpChannelVO> findByCriteria(OpChannelCond cond) {
        List<OpChannel> list = opChannelDomain.findByCriteria(cond);
        return  BeanUtil.buildListFrom(list, OpChannelVO.class);
    }

    @Override
    public OpChannelVO findByCode(String code) {
        return opChannelDomain.buildFromModel(opChannelDomain.findByCode(code));
    }

    @Override
    public List<OpChannelVO> findAll() {
        return BeanUtil.buildListFrom(opChannelDomain.findAll(), OpChannelVO.class);
    }


    @Override
    public List<OpChannelVO> selectAllFlowerShops() {
        return BeanUtil.buildListFrom(opChannelDomain.selectAllFlowerShops(),
                OpChannelVO.class);
    }

    @Override
    public List<OpChannelVO> findChannelByType(int type) {
        return BeanUtil.buildListFrom(opChannelDomain.selectAllFlowerShops(), OpChannelVO.class);
    }

    @Override
    public List<ChannelSelectorVO> findByChannelType(Integer type) {
        return BeanUtil.buildListFrom(opChannelDomain.findByChannelType(type),
                ChannelSelectorVO.class);
    }
}