package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpAttributeCond;
import com.thebeastshop.pegasus.merchandise.dao.OpAttributeMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeDomain;
import com.thebeastshop.pegasus.merchandise.model.OpAttribute;
import com.thebeastshop.pegasus.merchandise.service.McOpAttributeService;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeVO;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 *
 * @author gongjun
 * @since 2016-10-17
 */
public class McOpAttributeServiceImpl implements McOpAttributeService {

    @Autowired
    private OpAttributeDomain opAttributeDomain;

    @Override
    public Long create(OpAttributeVO attributeVO) {
        OpAttribute record = opAttributeDomain.buildFromVO(attributeVO);
        opAttributeDomain.create(record);
        return record.getId();
    }

    @Override
    public Boolean update(OpAttributeVO attributeVO) {
        OpAttribute record = opAttributeDomain.buildFromVO(attributeVO);
        return opAttributeDomain.update(record);
    }

    @Override
    public OpAttributeVO getById(Long id) {
        OpAttribute record = opAttributeDomain.getById(id);
        return opAttributeDomain.buildFromModel(record);
    }

    @Override
    public List<OpAttributeVO> findByCondition(OpAttributeCond cond) {
        return opAttributeDomain.findByCondition(cond);
    }

}
