package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSupplierBusinessCategoryMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSupplierMapper;
import com.thebeastshop.pegasus.merchandise.domain.BaseDomain;
import com.thebeastshop.pegasus.merchandise.dao.PcsSupplierPurchaseCategoryMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSupplierDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplier;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierBusinessCategory;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierExample;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplierPurchaseCategory;
import com.thebeastshop.pegasus.merchandise.service.McPcsBuyerInfoService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.merchandise.vo.SupplierBrandRelation;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsSupplierDomain")
public class PcsSupplierDomainImpl extends AbstractBaseDomain<PcsSupplierVO, PcsSupplier> implements PcsSupplierDomain, CheckAble {


    @Autowired
    private PcsSupplierMapper pcsSupplierMapper;

    @Autowired
    private McPcsBuyerInfoService mcPcsBuyerInfoService;

    @Autowired
    private PcsSupplierBusinessCategoryMapper pcsSupplierBusinessCategoryMapper;

    @Autowired
    private PcsSupplierPurchaseCategoryMapper pcsSupplierPurchaseCategoryMapper;

    @Override
    @Transactional
    public Long create(PcsSupplier record, boolean saveDraft) {
        if (check(record)) {
            if (check(record, true)) {
                record.setCreateTime(new Date());
                pcsSupplierMapper.insertSelective(record);
                //审核
                if(!saveDraft) {
                    //品类经理审批
            		/*if(record.getSupplierOrderStatus() != null && record.getSupplierOrderStatus() == 1) {
            			myScheduler.execute(new Runnable() {
							@Override
							public void run() {
								sendNotice(code, mcPcsBuyerInfoService.findCategoryManagerByBuyer(buyerId));
							}
						});
            		} */
                }
                return record.getId();
            }
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean update(PcsSupplier record, boolean saveDraft) {
        if (check(record)) {
            if (check(record, false)) {
            	/*//审核
            	if(!saveDraft) {
            		final String code = record.getName();
            		if(record.getCreator() != null) {
	            		final Integer buyerId = record.getCreator().intValue();
	            		//品类经理审批
	            		if(record.getSupplierOrderStatus() != null && record.getSupplierOrderStatus() == 1) {
	            			myScheduler.execute(new Runnable() {
								@Override
								public void run() {
									sendNotice(code, mcPcsBuyerInfoService.findCategoryManagerByBuyer(buyerId));
								}
							});
	            		}

	            		//财务审批审批
	            		if(record.getSupplierOrderStatus() != null && record.getSupplierOrderStatus() == 2) {
	            			myScheduler.execute(new Runnable() {
								@Override
								public void run() {
									sendNotice(code, null);
								}
							});
	            		}
	            	}
            	}*/
                return pcsSupplierMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }


    /**
     * 审批通知
     */
    private void  sendNotice(String code, UserInfo userInfo) {
        final SmsUtil smsUtil = SmsUtil.getInstance();
        final SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("finance.Approval.Mobile");
        // 收件人
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if(userInfo != null ) {
            String[]  categoryManager = {userInfo.getMobile()};
            smsVO.setMobileList(Arrays.asList(categoryManager));
        } else {
            smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        }

        smsVO.setContent("您好，您有新的供应商需要审批，供应商："+ code +"，请尽快审批，谢谢！");
        smsUtil.send(smsVO);

        // 邮件VO
        commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("finance.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        if(userInfo != null ) {
            String[]  categoryManager = {userInfo.getEmail()};
            emailVO.setToAddressList(Arrays.asList(categoryManager));
        } else {
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        }
        emailVO.setSubject("供应商审批");
        emailVO.setContent("您好，您有新的供应商需要审批，供应商："+ code +"，请尽快审批，谢谢！");
        // 发邮件
        if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
            // 正式环境发邮件
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public PcsSupplier findById(Long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return pcsSupplierMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSupplierVO> findByCond(PcsSupplierCond cond) {
        List<PcsSupplierVO> recordList = pcsSupplierMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByCriteria(PcsSupplierCond cond) {
        PcsSupplierExample example = new PcsSupplierExample();
        //conditions

        List<PcsSupplier> recordList = pcsSupplierMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByName(String name) {
        PcsSupplierExample example = new PcsSupplierExample();
        example.createCriteria().andNameCnLike(SQLUtils.allLike(name));
        example.or().andNameLike(SQLUtils.allLike(name));
        example.setOrderByClause("ID LIMIT 20 ");
        List<PcsSupplier> recordList = pcsSupplierMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSupplier> findByIds(List<Long> ids) {
        List<PcsSupplier> recordList = new ArrayList<PcsSupplier>();
        for (long id : ids) {
            PcsSupplier record = findById(id);
            if (EmptyUtil.isNotEmpty(record) && EmptyUtil.isNotEmpty(record.getId())) {
                recordList.add(record);
            }
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public Boolean check(Object obj) {
        PcsSupplier record = (PcsSupplier) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        Boolean currencyFlag = false;
        List<CommCurrency> allCurrency = PegasusUtilFacade.getInstance().findAllCurrency();
        for (CommCurrency c : allCurrency) {
            if (c.getCode().equals(record.getPurchaseCurrencyCode())) {
                record.setPurchaseCurrencyDesc(c.getDescInfo());
                currencyFlag = true;
                break;
            }
        }
        if (!currencyFlag) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsSupplier record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSupplierExample example1 = new PcsSupplierExample();
        PcsSupplierExample example2 = new PcsSupplierExample();
        example1.createCriteria().andNameEqualTo(record.getName());
        example2.createCriteria().andNameCnEqualTo(record.getNameCn());
        List<PcsSupplier> oldList = null;
        oldList = pcsSupplierMapper.selectByExample(example1);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "供应商名已有相同的值不能重名");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "供应商名已有相同的值不能重名");
        }
        oldList = pcsSupplierMapper.selectByExample(example2);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "供应商中文名已有相同的值不能重名");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "供应商中文名已有相同的值不能重名");
        }
        if (!isCreate) {
            PcsSupplier oldRecord = pcsSupplierMapper.selectByPrimaryKey(record.getId());
            if (NullUtil.isNotNull(oldRecord) && EmptyUtil.isNotEmpty(oldRecord.getFileId()) && EmptyUtil.isNotEmpty(record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
                PegasusUtilFacade.getInstance().deleteFileById(oldRecord.getFileId());
            }
        }
        return true;
    }

    @Override
    public Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type) {
        PcsSupplier record = pcsSupplierMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        if(isPass) {
            if(type == 1) { //财务
                record.setSupplierOrderStatus(3);
            } else {
                record.setSupplierOrderStatus(2);
                final String code = record.getName();
				/*myScheduler.execute(new Runnable() {
					@Override
					public void run() {
						sendNotice(code, null);
					}
				});*/
            }

        } else { //驳回
            record.setSupplierOrderStatus(-1);
        }
        return this.pcsSupplierMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public long countByCond(PcsSupplierCond cond) {
        return pcsSupplierMapper.countByCond(cond);
    }

	@Override
	public List<SupplierBrandRelation> findSupplierBrandRelation() {
		return null;
	}

	@Override
	public Integer addSupplierBusinessCategory(PcsSupplierBusinessCategory supplierBusinessCategory) {
		return pcsSupplierBusinessCategoryMapper.insertSelective(supplierBusinessCategory);
	}

	@Override
	public Integer addSupplierPurchaseCategory(PcsSupplierPurchaseCategory supplierPurchaseCategory) {
		return pcsSupplierPurchaseCategoryMapper.insertSelective(supplierPurchaseCategory);
	}

	@Override
	public int deleteBusinessCategoryBySupplierId(Integer supplierId) {
		return pcsSupplierBusinessCategoryMapper.deleteBySupplierId(supplierId);
	}

	@Override
	public int deletePurchaseCategoryBySupplierId(Integer supplierId) {
		return pcsSupplierPurchaseCategoryMapper.deleteBySupplierId(supplierId);
	}

	@Override
	public List<String> findBusinessCategoryBySupplierId(Integer supplierId) {
		return pcsSupplierBusinessCategoryMapper.selectBySupplierId(supplierId);
	}

	@Override
	public List<String> findPurchaseCategoryBySupplierId(Integer supplierId) {
		return pcsSupplierPurchaseCategoryMapper.selectBySupplierId(supplierId);
	}
}
