package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsSkuQcImgMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuQcImgDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQcImg;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQcImgExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQcImgVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsSkuQcImgDomain")
public class PcsSkuQcImgDomainImpl extends AbstractBaseDomain<PcsSkuQcImgVO, PcsSkuQcImg> implements PcsSkuQcImgDomain {

    @Autowired
    private PcsSkuQcImgMapper pcsSkuQcImgMapper;
    @Override
    public int deleteQcImgBySkuCode(String skuCode) {
        PcsSkuQcImg pcsSkuQcImg = new PcsSkuQcImg();
        pcsSkuQcImg.setCancelFlag(1);
        PcsSkuQcImgExample pcsSkuQcImgExample = new PcsSkuQcImgExample();
        pcsSkuQcImgExample.createCriteria().andSkuCodeEqualTo(skuCode);
        return pcsSkuQcImgMapper.updateByExampleSelective(pcsSkuQcImg,pcsSkuQcImgExample);
    }

    @Override
    public int createQcImg(PcsSkuQcImg pcsSkuQcImg) {
        return pcsSkuQcImgMapper.insert(pcsSkuQcImg);
    }

    @Override
    public List<PcsSkuQcImg> findPcsSkuQcImgBySkuCode(String skuCode) {
        PcsSkuQcImgExample example = new PcsSkuQcImgExample();
        PcsSkuQcImgExample.Criteria criteria = example.createCriteria();
        criteria.andSkuCodeEqualTo(skuCode);
        criteria.andCancelFlagEqualTo(0);
        example.setOrderByClause("SEQ");
        return pcsSkuQcImgMapper.selectByExample(example);
    }

}
