package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsClPsMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsClPs;
import com.thebeastshop.pegasus.merchandise.model.PcsClPsExample;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author Roy.Chen
 * @update gongjun 2016-08-30
 * @version $Id: PcsClPsSkuServiceImpl.java, v 0.1 2015-08-07 15:25
 */
@Component("pcsClPsDomain")
public class PcsClPsDomainImpl implements PcsClPsDomain {

    private static final Logger log = LoggerFactory.getLogger(PcsClPsDomainImpl.class);
    @Autowired
    private PcsClPsMapper pcsClPsMapper;

    @Override
    public Long findMaxId() {
        return (Long) NumberUtil.avoidNull(pcsClPsMapper.findMaxId(),0L);
    }

    @Override
    public int add(PcsClPs pcsClPs) {
        return pcsClPsMapper.insert(pcsClPs);
    }

    @Override
    public int saveSkuCodeList(List<String> codeList, Integer changeSource) {
        int ret = 0;
        for (int i = 0; i < codeList.size(); i++) {
            String code = codeList.get(i);
            PcsClPs pcsClPs = new PcsClPs();
            pcsClPs.setCode(code);
            pcsClPs.setChangeSource(changeSource);
            ret += this.add(pcsClPs);
        }
        return ret;
    }

    @Override
    public List<PcsClPs> findByMaxId(Long maxId) {
        return pcsClPsMapper.findByMaxId(maxId);
    }

    @Override
    public boolean deleteByMaxId(Long maxId) {
        PcsClPsExample example = new PcsClPsExample();
        PcsClPsExample.Criteria criteria = example.createCriteria();
        criteria.andIdLessThanOrEqualTo(maxId);
        return pcsClPsMapper.deleteByExample(example) != 0;
    }

}
