package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsBrandMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsBrandDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsBuyerDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsBrand;
import com.thebeastshop.pegasus.merchandise.model.PcsBrandExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsBrandDomain")
public class PcsBrandDomainImpl extends AbstractBaseDomain<PcsBrandVO, PcsBrand> implements PcsBrandDomain, CheckAble {

    @Autowired
    private PcsBrandMapper pcsBrandMapper;

    @Autowired
    private PcsBuyerDomain pcsBuyerDomain;


    @Override
    @Transactional
    public Long create(PcsBrand record, boolean saveDraft) {
        if (check(record)) {
            if (check(record, true)) {
                record.setCreateTime(new Date());
                pcsBrandMapper.insertSelective(record);
                //审核
                if(!saveDraft) {
            		/*final String code = record.getName();
            		final Integer buyerId = record.getCreator().intValue();*/
                    //品类经理审批
            		/*if(record.getBrandStatus() != null && record.getBrandStatus() == 1) {
            			myScheduler.execute(new Runnable() {
							@Override
							public void run() {
								sendNotice(code, pcsBuyerDomain.findCategoryManagerByBuyer(buyerId));
							}
						});
            		} */
                }
                return record.getId();
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsBrand record, boolean saveDraft) {
        if (check(record)) {
            if (check(record, false)) {
                //审核
            	/*if(!saveDraft) {
            		final String code = record.getName();
            		if(record.getCreator() != null) {
	            		final Integer buyerId = record.getCreator().intValue();
	            		//品类经理审批
	            		if(record.getBrandStatus() != null && record.getBrandStatus() == 1) {
	            			myScheduler.execute(new Runnable() {
								@Override
								public void run() {
									//sendNotice(code, pcsBuyerDomain.findCategoryManagerByBuyer(buyerId));
								}
							});
	            		}
            		}

            		//法务审批
            		if(record.getBrandStatus() != null && record.getBrandStatus() == 2) {
            			myScheduler.execute(new Runnable() {
							@Override
							public void run() {
								//sendNotice(code,  null);
							}
						});
            		}
            	}*/
                return pcsBrandMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    /**
     * 审批通知
     */
    private void  sendNotice(String code, UserInfo userInfo) {
        final SmsUtil smsUtil = SmsUtil.getInstance();
        final SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("legal.Approval.Mobile");
        // 收件人
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if(userInfo != null ) {
            String[]  categoryManager = {userInfo.getMobile()};
            smsVO.setMobileList(Arrays.asList(categoryManager));
        } else {
            smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        }

        smsVO.setContent("您好，您有新的品牌需要审批，品牌："+ code +"，请尽快审批，谢谢！");
        smsUtil.send(smsVO);

        // 邮件VO
        commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("legal.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        if(userInfo != null ) {
            String[]  categoryManager = {userInfo.getEmail()};
            emailVO.setToAddressList(Arrays.asList(categoryManager));
        } else {
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        }
        emailVO.setSubject("品牌审批");
        emailVO.setContent("您好，您有新的品牌需要审批，品牌："+ code +"，请尽快审批，谢谢！");
        // 发邮件
        if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
            // 正式环境发邮件
            EmailUtil.getInstance().send(emailVO);
        }
    }
    @Override
    public PcsBrand findById(long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return pcsBrandMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsBrandVO> findByCond(PcsBrandCond cond) {
        List<PcsBrandVO> recordList = pcsBrandMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsBrand> findByName(String name) {
        PcsBrandExample example = new PcsBrandExample();
        example.createCriteria().andNameCnLike(SQLUtils.allLike(name));
        example.or().andNameLike(SQLUtils.allLike(name));

        example.setOrderByClause("ID LIMIT 20 ");
        List<PcsBrand> recordList = pcsBrandMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsBrand> findByIds(List<Long> ids) {
        List<PcsBrand> recordList = new ArrayList<PcsBrand>();
        for (long id : ids) {
            PcsBrand record = findById(id);
            if (EmptyUtil.isNotEmpty(record) && EmptyUtil.isNotEmpty(record.getId())) {
                recordList.add(record);
            }
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public Boolean check(Object obj) {
        PcsBrand record = (PcsBrand) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsBrand record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsBrandExample example1 = new PcsBrandExample();
        PcsBrandExample example2 = new PcsBrandExample();
        example1.createCriteria().andNameEqualTo(record.getName());
        example2.createCriteria().andNameCnEqualTo(record.getNameCn());
        List<PcsBrand> oldList = null;
        oldList = pcsBrandMapper.selectByExample(example1);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "name字段数据库已有相同的值不能重名");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "name字段数据库已有相同的值不能重名");
        }
        oldList = pcsBrandMapper.selectByExample(example2);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "nameCn字段数据库已有相同的值不能重名");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "nameCn字段数据库已有相同的值不能重名");
        }
        if (!isCreate) {
            PcsBrand oldRecord = pcsBrandMapper.selectByPrimaryKey(record.getId());
            if (NullUtil.isNotNull(oldRecord) && EmptyUtil.isNotEmpty(oldRecord.getFileId()) && EmptyUtil.isNotEmpty(record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
                PegasusUtilFacade.getInstance().deleteFileById(oldRecord.getFileId());
            }
        }
        return true;
    }

    @Override
    public Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type) {
        PcsBrand record = pcsBrandMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        if(isPass) { //通过
            if(type == 1) { //财务审核通过
                record.setBrandStatus(3);
            } else {
                record.setBrandStatus(2);
				/*final String code = record.getName();
				myScheduler.execute(new Runnable() {
					@Override
					public void run() {
						sendNotice(code, null);
					}
				});*/
            }
        } else {
            record.setBrandStatus(-1);
        }
        return pcsBrandMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public long countByCond(PcsBrandCond cond) {
        return pcsBrandMapper.countByCond(cond);
    }

}
