package com.thebeastshop.pegasus.merchandise.domain;


import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */

public interface PsProductDomain {

    boolean create(PsProductVO vo);
    boolean create(List<PsProductVO> vos);
    boolean update(PsProductVO vo);
    boolean update(List<PsProductVO> vos);

    boolean createOrUpdate(PsProductVO vo);

    boolean createOrUpdate(List<PsProductVO> vos);

    /**
     *
     * @param id es's id, eg.SkuCode,ProdId
     * @return
     */
    boolean deleteById(String id);

    /**
     *
     * @param ids  es's id, eg.SkuCode,ProdId
     * @return
     */
    boolean deleteByIds(List<String> ids);
    List<PsProductVO> findAll();

    List<PsProductVO> findByProdName(String name);
    List<PsProductVO> findByProdCode(String code);

    List<PsProductVO> findByCond(PsProductCond cond);
    List<PsProductVO> findByCond(PsProductCond cond, boolean matchGlobalCampaigns);

    Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond);
    List<PsCampaignVO> getGlobalCampaignList(Integer memberLevel, Integer accessWay);

    List<PsProductVO> findByFields(Map<String, Object> params);

    boolean updateBySkuCodes(List<String> skuCodes);

    PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode);
    PsProductVO findProdBySkuCode(String skuCode);


    List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode);
    List<PsProductVO> findByProdSearchCondVO(String chnCode, final PsMatchCampaignCond campaignCond, final ProdSearchCond prodSearchCond);
    List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode, final PsMatchCampaignCond campaignCond, int currpage, int pagenum);

    List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode);
    //like query
    List<PsProductVO> findByNameOrNameCN(Map<String, Object> params);

    void calculateDiscountPrice(List<PsProductVO> productList, Integer memberLevel, Integer accessWay, BigDecimal discountAmount);

    void calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond);

    void calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond);

    List<PsProductVO> findByChnCodeCateCodeCreateTime(String chnCode, Map<String, Date> dateRange,
                                                      PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum);
    
	Map<String, PsProductVO> mapByProdCodes(List<String> codes);
    
}
