/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.alibaba.fastjson.JSONArray;
import com.sun.org.apache.xpath.internal.operations.Bool;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

/**
 * @author Roy.Chen
 * @version $Id: ProductClient.java, v 0.1 2015-08-19 10:34
 */
public class ProductClient extends AbstractESClient<PsProductVO> {

    @Autowired
    private SpvESClient spvClient;

    public ProductClient(String index, String type) {
        super(index, type);
    }

    public ProductClient(String index, String type, String host, int port) {
        super(index, type, host, port);
    }


    @SuppressWarnings("unchecked")
    @Override
    public PsProductVO build(SearchHit hit, String chnCode) {
        return build(hit, chnCode, null);
    }

    @SuppressWarnings("unchecked")
    @Override
    public PsProductVO build(SearchHit hit, String chnCode, Long total){
        PsProductVO vo = new PsProductVO();
        Map<String, Object> params = hit.getSource();
        vo.setId(MapUtils.getString(params,"id"));
        vo.setCode((String) params.get("code"));
        Integer prodCombined = MapUtils.getInteger(params, "combined");
        if (prodCombined == null) prodCombined = 0;
        vo.setCombined(prodCombined == 0 ? false : true);
        String listPriceStr = MapUtils.getString(params, "listPrice");
        if (listPriceStr != null) {
            vo.setListPrice(new BigDecimal(listPriceStr));
        }
        List<Map> listPriceList = (List<Map>) params.get("listPriceList");
        Map<String, BigDecimal> listPriceMap = new HashMap<>();
        if (listPriceList != null && chnCode != null) {
            for (Map map : listPriceList) {
                String listPriceChnCode = MapUtils.getString(map, "chnCode");
                String price = MapUtils.getString(map, "listMap");
                if  (StringUtils.isNotEmpty(listPriceChnCode) && StringUtils.isNotEmpty(price) && chnCode.equals(listPriceChnCode)) {
                    BigDecimal chnListPrice = new BigDecimal(price);
                    if (!chnListPrice.equals(BigDecimal.ZERO)) {
                        vo.setListPrice(chnListPrice);
                    }
                }
            }
        }

        vo.setAllowVipDiscount((Integer) params.get("allowVipDiscount"));
        vo.setAllowNoteCard((Integer) params.get("allowNoteCard"));
        vo.setPrepareDays((Integer) params.get("prepareDays"));
        vo.setSelectDeliveryDays((Integer) params.get("selectDeliveryDays"));
        vo.setPicList((String) params.get("picList"));
        vo.setPicDetail((String) params.get("picDetail"));
        vo.setPicDetailMul((String) params.get("picDetailMul"));
        vo.setPicThumb((String) params.get("picThumb"));
        vo.setName((String) params.get("name"));
        vo.setNameCn((String) params.get("nameCn"));
        Integer crossBorderFlag = MapUtils.getInteger(params, "crossBorderFlag");
        vo.setCrossBorderFlag(crossBorderFlag);
        vo.setSkuCategoryDesc((String) params.get("skuCategoryDesc"));
        vo.setUpdateTime((String) params.get("updateTime"));
        vo.setCategoryId((Integer) (params.get("categoryId") == null ? 0 : params.get("categoryId")) + 0L);
        vo.setCategoryCode((String) ObjectUtils.defaultIfNull(params.get("categoryCode"), ""));
        vo.setExpressType((Integer) (params.get("expressType") == null ? 3 : params.get("expressType")));
        vo.setSkuCodes((List<String>) params.get("skuCodes"));
        vo.setChnSaleChnCodes((List<String>) params.get("chnSaleChnCodes"));
        vo.setOnShelfChnCodes((List<String>) params.get("onShelfChnCodes"));
        vo.setOffShelfChnCodes((List<String>) params.get("offShelfChnCodes"));
        vo.setSmallIconList((List<String>) params.get("smallIconList"));
        vo.setLargeIconList((List<String>) params.get("largeIconList"));

        vo.setAttributeList(buildAttributeList(params));
        vo.setSpvList(buildSpvList(params, Long.valueOf(vo.getId())));

        vo.setTotal(total);
        vo.setSeq(params.get("seq") == null?9999:(Integer)params.get("seq"));
        vo.setDescription(MapUtils.getString(params, "description"));
        Integer sort1 = (Integer) params.get("sort1");
        Integer sort2 = (Integer) params.get("sort2");
        if (sort1 == null) {
            sort1 = 99999;
        }
        if (sort2 == null) {
            sort2 = 99999;
        }
        vo.setSort1(sort1);
        vo.setSort2(sort2);
        List<Map> contents = (List<Map>) params.get("dynmContents");
        if (CollectionUtils.isNotEmpty(contents)) {
            List<PsDynmContentVO> dynmContentVOs = new ArrayList<>(contents.size());
            for (Map content : contents) {
                PsDynmContentVO contentVO = new PsDynmContentVO();
                contentVO.setTitleCn((String) content.get("titleCn"));
                contentVO.setTitleEn((String) content.get("titleEn"));
                contentVO.setContent((String) content.get("content"));
                contentVO.setContentType((String) content.get("contentType"));
                contentVO.setSort((Integer) content.get("sort"));
                dynmContentVOs.add(contentVO);
            }
            vo.setDynmContents(dynmContentVOs);
        }

        List<Map> selfDeliveries = (List<Map>) params.get("selfDeliveries");
        if (CollectionUtils.isNotEmpty(selfDeliveries)) {
            List<PsDeliveryVO> deliveryVOs = new ArrayList<>(selfDeliveries.size());
            for (Map deliver : selfDeliveries) {
                PsDeliveryVO deliveryVO = new PsDeliveryVO();
                deliveryVO.setDistrictId((String) deliver.get("districtId"));
                deliveryVO.setDistrictName((String) deliver.get("districtName"));
                deliveryVOs.add(deliveryVO);
            }
            vo.setSelfDeliveries(deliveryVOs);
        }


        List<Map> chnCanSaleSKu = (List<Map>) params.get("chnCanSaleSKu");
        if (CollectionUtils.isNotEmpty(chnCanSaleSKu)) {
            List<PsChnProdSaleSkuVO> canSaleSku = new ArrayList<>(chnCanSaleSKu.size());
            for (Map deliver : chnCanSaleSKu) {
                PsChnProdSaleSkuVO deliveryVO = new PsChnProdSaleSkuVO();
                deliveryVO.setChnCode((String) deliver.get("chnCode"));
                deliveryVO.setCanSkus((List<String>) deliver.get("canSkus"));
                canSaleSku.add(deliveryVO);
            }
            vo.setChnCanSaleSKu(canSaleSku);
        }

        List<Map> chnCanSeeSKu = (List<Map>) params.get("chnCanSeeSKu");
        if (CollectionUtils.isNotEmpty(chnCanSeeSKu)) {
            List<PsChnProdSaleSkuVO> canSeeSku = new ArrayList<>(chnCanSaleSKu.size());
            for (Map deliver : chnCanSeeSKu) {
                PsChnProdSaleSkuVO deliveryVO = new PsChnProdSaleSkuVO();
                deliveryVO.setChnCode((String) deliver.get("chnCode"));
                deliveryVO.setCanSkus((List<String>) deliver.get("canSkus"));
                canSeeSku.add(deliveryVO);
            }
            vo.setChnCanSeeSKu(canSeeSku);
        }

        List<Map> frontCategoriesMap = (List<Map>) params.get("frontCategories");
        if (CollectionUtils.isNotEmpty(frontCategoriesMap)) {
            List<PsCategoryVO> frontCategories = new ArrayList<>(frontCategoriesMap.size());
            for (Map category : frontCategoriesMap) {
                PsCategoryVO psCategoryVO = new PsCategoryVO();
                psCategoryVO.setCategoryCode((String) category.get("categoryCode"));
                psCategoryVO.setCategoryFullName((String) category.get("categoryFullName"));
                if(category.get("sort1")!=null){
                    psCategoryVO.setSort1((Integer)category.get("sort1"));
                }
                if(category.get("sort2")!=null){
                    psCategoryVO.setSort2((Integer)category.get("sort2"));
                }

                if(category.get("categoryId")!=null){
                    psCategoryVO.setCategoryId(Long.valueOf(String.valueOf(category.get("categoryId"))));
                }

                psCategoryVO.setCategoryName((String) category.get("categoryName"));

                frontCategories.add(psCategoryVO);
            }
            vo.setFrontCategories(frontCategories);
        }

        List<Map> psTags = (List<Map>) params.get("psTags");
        if (CollectionUtils.isNotEmpty(psTags)) {
            List<PsTagVO> tagVOs = new ArrayList<>(psTags.size());
            for (Map content : psTags) {
                PsTagVO contentVO = new PsTagVO();
                contentVO.setIcon((String) content.get("icon"));
                contentVO.setText((String) content.get("text"));
                tagVOs.add(contentVO);
            }
            vo.setPsTags(tagVOs);
        }

        List<Map> brands = (List<Map>) params.get("brandList");
        if (CollectionUtils.isNotEmpty(brands)) {
            List<PsBrandVO> brandVOs = new ArrayList<>(brands.size());
            for (Map content : brands) {
                PsBrandVO brandVO = new PsBrandVO();
                brandVO.setBrandCountryName((String) content.get("brandCountryName"));
                brandVO.setBrandCountryId(Long.valueOf(String.valueOf(content.get("brandCountryId"))));
                brandVO.setBrandNameCN((String) content.get("brandNameCN"));
                brandVO.setBrandName((String) content.get("brandName"));
                brandVO.setBrandId(Long.valueOf(String.valueOf(content.get("brandId"))));
                brandVOs.add(brandVO);
            }
            vo.setBrands(brandVOs);
        }


        List<Map> channelProdInfo = (List<Map>) params.get("channelProdInfo");
        if (CollectionUtils.isNotEmpty(channelProdInfo)) {
            Map codeTime;
            List<Map> chanProds = new ArrayList<Map>(channelProdInfo.size());
            for (Map content : channelProdInfo) {
                codeTime = new HashMap();
                codeTime.put("channelCode",content.get("channelCode"));
                codeTime.put("createTime", content.get("createTime"));
                chanProds.add(codeTime);
            }
            vo.setChannelProdInfo(chanProds);
        }

        List<Map> stocks = (List<Map>) params.get("stocks");
        if (CollectionUtils.isNotEmpty(stocks)) {
            List<PsChnStockVO> stockList = new ArrayList<PsChnStockVO>(stocks.size());
            for (Map stockMap : stocks) {
                stockList.add(new PsChnStockVO((String)stockMap.get("chnCode"),MapUtils.getInteger(stockMap,"stock"),MapUtils.getInteger(stockMap,"soldOut")));
            }
            vo.setStocks(stockList);
        }

        List<Map> campaignList = (List<Map>) params.get("campaignList");
        if (EmptyUtil.isNotEmpty(campaignList)) {
            List<PsCampaignVO> campaigns = new ArrayList<>();
            vo.setCampaignList(campaigns);
            for (Map campaign : campaignList) {
                PsCampaignVO psCampaignVO = new PsCampaignVO();
                psCampaignVO.setId(Long.valueOf(String.valueOf(campaign.get("id"))));
                psCampaignVO.setState(MapUtils.getInteger(campaign, "state"));
                psCampaignVO.setName((String) campaign.get("name"));
                psCampaignVO.setTitle((String) campaign.get("title"));
                psCampaignVO.setDiscountTypeId((Integer) campaign.get("discountTypeId"));
                psCampaignVO.setDiscountTypeName((String) campaign.get("discountTypeName"));
                psCampaignVO.setProductScopeId((Integer) campaign.get("productScopeId"));
                psCampaignVO.setCrossBorderFlag(MapUtils.getInteger(campaign, "crossBorderFlag"));

                List<Integer> memberLevelIds = (List<Integer>) campaign.get("memberLevels");
                if (memberLevelIds == null) memberLevelIds = new ArrayList<>();
                psCampaignVO.setMemberLevels(memberLevelIds);

                List<Integer> accessWayIds = (List<Integer>) campaign.get("accessWayIds");
                if (accessWayIds == null) accessWayIds = new ArrayList<>();
                psCampaignVO.setAccessWayIds(accessWayIds);

                campaigns.add(psCampaignVO);

                Date startTime = null;
                try {
                    String startTimeStr = MapUtils.getString(campaign, "startTime");
                    startTimeStr = StringUtils.replace(startTimeStr, "T", " ");
                    startTime = DateUtil.parse(startTimeStr, "yyyy-MM-dd HH:ss:mm");
                } catch (Exception ex) {
                }
                if (startTime != null) {
                    psCampaignVO.setStartTime(startTime);
                }


                Date expireTime = null;
                try {
                    String expireTimeStr = MapUtils.getString(campaign, "expireTime");
                    expireTimeStr = StringUtils.replace(expireTimeStr, "T", " ");
                    expireTime = DateUtil.parse(expireTimeStr, "yyyy-MM-dd HH:ss:mm");
                } catch (Exception ex) {
                }
                if (expireTime != null) {
                    psCampaignVO.setExpireTime(expireTime);
                }

                List<Map> campaignSectionList = (List<Map>) campaign.get("campaignSections");
                if (EmptyUtil.isNotEmpty(campaignSectionList)) {
                    List<PsCampaignSectionVO> campaignSections = new ArrayList<>();
                    psCampaignVO.setCampaignSectionList(campaignSections);
                    for (Map campaignSection : campaignSectionList) {
                        PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                        psCampaignSectionVO.setId(Long.valueOf(String.valueOf(campaignSection.get("id"))));
                        psCampaignSectionVO.setCampaignId(Long.valueOf(String.valueOf(campaignSection.get("campaignId"))));
                        psCampaignSectionVO.setConditionType((Integer) campaignSection.get("conditionType"));
                        if (campaignSection.containsKey("line")) {
                            psCampaignSectionVO.setLine(new BigDecimal(MapUtils.getDouble(campaignSection, "line")));
                        }
                        if (campaignSection.containsKey("factor")) {
                            psCampaignSectionVO.setFactor(new BigDecimal(MapUtils.getDouble(campaignSection,"factor")));
                        }
                        if (campaignSection.containsKey("factorType")) {
                            psCampaignSectionVO.setFactorType(MapUtils.getInteger(campaignSection,"factorType"));
                        }
                        if (campaignSection.containsKey("ranking")) {
                            psCampaignSectionVO.setRanking(MapUtils.getDouble(campaignSection, "ranking"));
                        }
                        campaignSections.add(psCampaignSectionVO);

                        List<Map> campaignSectionProductList = (List<Map>) campaignSection.get("campaignSectionProducts");
                        if (EmptyUtil.isNotEmpty(campaignSectionProductList)) {
                            List<PsCampaignSectionProductVO> campaignSectionProducts = new ArrayList<>();
                            psCampaignSectionVO.setCampaignSectionProducts(campaignSectionProducts);
                            for (Map campaignSectionProduct : campaignSectionProductList) {
                                PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                                psCampaignSectionProductVO.setId(Long.valueOf(String.valueOf(campaignSectionProduct.get("id"))));
                                psCampaignSectionProductVO.setCampaignId(psCampaignVO.getId());
                                psCampaignSectionProductVO.setCampaignSectionId(psCampaignSectionVO.getId());
                                psCampaignSectionProductVO.setProductId(Long.valueOf(String.valueOf(campaignSectionProduct.get("productId"))));
                                psCampaignSectionProductVO.setPricePrice(new BigDecimal(String.valueOf(campaignSectionProduct.get("pricePrice"))));
                                psCampaignSectionProductVO.setPriceCount((Integer) campaignSectionProduct.get("priceCount"));
                                campaignSectionProducts.add(psCampaignSectionProductVO);
                            }
                        }
                    }
                }
            }
        }

        return vo;
    }

    /**
     * build属性列表
     * @param params
     * @return
     */
    public List<PsAttributeVO> buildAttributeList(Map params) {
        List<Map> attributeList = (List<Map>) params.get("attributeList");
        List<PsAttributeVO> attributeVOs = null;
        if (CollectionUtils.isNotEmpty(attributeList)) {
            attributeVOs = new ArrayList<>();
            for (Map attribute : attributeList) {
                PsAttributeVO attributeVO = new PsAttributeVO();
                attributeVO.setAttrId(MapUtils.getLong(attribute, "id"));
                attributeVO.setGroupName(MapUtils.getString(attribute, "groupName"));
                attributeVO.setName(MapUtils.getString(attribute, "attrName"));
                Integer combined = MapUtils.getInteger(attribute, "combined");
                if (combined == null) {
                    combined = 0;
                }
                attributeVO.setCombined(combined == 0 ? false : true);
                List<Map> attributeValueList = (List<Map>) attribute.get("valueList");
                if (CollectionUtils.isNotEmpty(attributeValueList)) {
                    List<PsAttributeValueVO> attributeValueVOs = new ArrayList<>();
                    Map<String, PsAttributeValueVO> attributeValueVOMap = new LinkedHashMap<>();
                    for (Map attributeValue : attributeValueList) {
                        PsAttributeValueVO attributeValueVO = new PsAttributeValueVO();
                        attributeValueVO.setId(MapUtils.getLong(attributeValue, "id"));
                        String value = MapUtils.getString(attributeValue, "value");
                        Integer quantity = MapUtils.getInteger(attributeValue, "quantity");
                        attributeValueVO.setValue(value);
                        attributeValueVO.setQuantity(quantity);
                        attributeValueVOs.add(attributeValueVO);
                        attributeValueVOMap.put(value, attributeValueVO);
                    }
                    attributeVO.setAttributeValueMap(attributeValueVOMap);
                    attributeVO.setAttributeValues(attributeValueVOs);
                }
                attributeVOs.add(attributeVO);
            }
//            vo.setAttributeList(attributeVOs);
        }
        return attributeVOs;
    }


    public List<PsSpvVO> buildSpvList(Map params, Long productId) {
        List<Map> spvs = (List<Map>) params.get("spvList");
        List<PsSpvVO> spvVOs = null;
        if (CollectionUtils.isNotEmpty(spvs)) {
            spvVOs = new ArrayList<>(spvs.size());
            for (Map spv : spvs) {
                PsSpvVO spvVO = new PsSpvVO();
                spvClient.buildSpv(spv, spvVO);
                spvVOs.add(spvVO);
            }
        }
        return spvVOs;
    }



    @Override
    public XContentBuilder getXContentBuilder(PsProductVO vo) {
        try {
            XContentBuilder builder = jsonBuilder();
            Date zeroDate = DateUtil.parse("0000-00-00", "yyyy-MM-dd");
            Integer sort1 = vo.getSort1();
            Integer sort2 = vo.getSort2();
            builder.startObject()
                    //必须设置 方便删除更新
                    .field("id", vo.getId()).field("type", "string")
                    .field("prodId", vo.getId()).field("type", "string")
                    .field("code", vo.getCode()).field("type", "string")
                    .field("listPrice", vo.getListPrice().doubleValue()).field("type", "double")
                    .field("allowVipDiscount", vo.getAllowVipDiscount()).field("type", "int")
                    .field("allowNoteCard", vo.getAllowNoteCard()).field("type", "int")
                    .field("prepareDays", vo.getPrepareDays()).field("type", "int")
                    .field("selectDeliveryDays", vo.getSelectDeliveryDays()).field("type", "int")
                    .field("picList", vo.getPicList()).field("type", " string")
                    .field("picDetail", vo.getPicDetail()).field("type", " string")
                    .field("picDetailMul", vo.getPicDetailMul()).field("type", " string")
                    .field("picThumb", vo.getPicThumb()).field("type", " string")
                    .field("name", vo.getName()).field("type", " string")
                    .field("nameCn", vo.getNameCn()).field("type", " string")
                    .field("skuCategoryDesc", vo.getSkuCategoryDesc()).field("type", " string")
                    .field("updateTime", vo.getUpdateTime()).field("type", " string")
                    .field("chnSaleChnCodes", vo.getChnSaleChnCodes()).field("type", "list")
                    .field("onShelfChnCodes", vo.getOnShelfChnCodes()).field("type", "list")
                    .field("offShelfChnCodes", vo.getOffShelfChnCodes()).field("type", "list")
                    .field("smallIconList", vo.getSmallIconList()).field("type", "list")
                    .field("largeIconList", vo.getLargeIconList()).field("type", "list")
                    .field("updateTime", getNow()).field("type", "string")
                    .field("updateLong", DateUtil.getNow().getTime())
                    .field("categoryId", NumberUtil.avoidNull(vo.getCategoryId(), 0))
                    .field("categoryCode", (vo.getCategoryCode()==null?"":vo.getCategoryCode()))
                    .field("expressType", (vo.getExpressType() == null ? 3 : vo.getExpressType()))
                    .field("seq", vo.getSeq() == null?9999:vo.getSeq()).field("type", "int")
                    .field("sort1", sort1).field("type", "int")
                    .field("sort2", sort2).field("type", "int")
                    .field("saleStartDate", vo.getSaleStartDate()).field("type", "date")
                    .field("skuCodes", vo.getSkuCodes())
                    .field("description", vo.getDescription());

            builder.startArray("selfDeliveries");
            for (PsDeliveryVO psDeliveryVO : vo.getSelfDeliveries()) {
                builder.startObject();
                builder.field("districtId", psDeliveryVO.getDistrictId());
                builder.field("districtName", psDeliveryVO.getDistrictName());
                builder.endObject();
            }
            builder.endArray();

            builder.startArray("dynmContents");
            for (PsDynmContentVO psDynmContentVO : vo.getDynmContents()) {
                builder.startObject();
                builder.field("titleCn", psDynmContentVO.getTitleCn());
                builder.field("titleEn", psDynmContentVO.getTitleEn());
                builder.field("contentType", psDynmContentVO.getContentType());
                builder.field("sort", psDynmContentVO.getSort());
                builder.endObject();
            }
            builder.endArray();

            builder.startArray("chnCanSaleSKu");
            for (PsChnProdSaleSkuVO psDynmContentVO : vo.getChnCanSaleSKu()) {
                builder.startObject();
                builder.field("chnCode", psDynmContentVO.getChnCode());
                builder.field("canSkus", psDynmContentVO.getCanSkus());
                builder.endObject();
            }
            builder.endArray();

            builder.startArray("chnCanSeeSKu");
            for (PsChnProdSaleSkuVO psDynmContentVO : vo.getChnCanSeeSKu()) {
                List<String> canSkus = psDynmContentVO.getCanSkus();
                if (canSkus != null && !canSkus.isEmpty()) {
                    builder.startObject();
                    builder.field("chnCode", psDynmContentVO.getChnCode());
                    builder.field("canSkus", canSkus);
                    builder.endObject();
                }
            }
            builder.endArray();

            builder.startArray("frontCategoryList");
            if (vo.getFrontCategories() == null) {
                vo.setFrontCategories(new ArrayList<PsCategoryVO>());
            }
            for (PsCategoryVO categoryVO : vo.getFrontCategories()) {
                builder.startObject();
                builder.field("categoryId", categoryVO.getCategoryId());
                builder.field("categoryCode", categoryVO.getCategoryCode());
                builder.field("categoryName", categoryVO.getCategoryName());
                builder.field("categoryFullName", categoryVO.getCategoryFullName());
                builder.field("sort1", categoryVO.getSort1());
                builder.field("sort2", categoryVO.getSort2());
                builder.endObject();
            }
            builder.endArray();

            builder.startArray("stocks");
            if (vo.getStocks() == null) {
                vo.setStocks(new ArrayList<PsChnStockVO>());
            }
            for (PsChnStockVO stockVO : vo.getStocks()) {
                builder.startObject();
                builder.field("chnCode", stockVO.getChnCode());
                builder.field("stock", stockVO.getStock());
                builder.field("soldOut", stockVO.getSoldOut());
                builder.endObject();
            }
            builder.endArray();

            builder.startArray("psTags");
            if (vo.getPsTags() == null) {
                vo.setPsTags(new ArrayList<PsTagVO>());
            }
            for (PsTagVO tagVO : vo.getPsTags()) {
                builder.startObject();
                builder.field("icon", tagVO.getIcon());
                builder.field("text", tagVO.getText());
                builder.endObject();
            }
            builder.endArray();

            builder.startArray("channelProdInfo");
            if (vo.getChannelProdInfo() == null) {
                vo.setChannelProdInfo(new ArrayList<Map>());
            }
            for (Map chanProd : vo.getChannelProdInfo()) {
                builder.startObject();
                builder.field("channelCode", chanProd.get("channelCode"));
                builder.field("createTime", chanProd.get("createTime"));
                builder.endObject();
            }
            builder.endArray();

            builder.endObject();
            return builder;
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    @Override
    public String getPrimaryKeyName() {
        return "id";
    }

    @Override
    public void queryCondPrepare(BoolQueryBuilder queryBuilder, Map<String, Object> params, SearchType type) {
        //ROYSs
        String _cateCode = "categoryCodePRE";
        String cateCode = (String) ObjectUtils.defaultIfNull(params.get(_cateCode), StringUtils.EMPTY);
        if (StringUtils.isNotBlank(cateCode)) {
            params.remove(_cateCode);
            addQueryBuilder(queryBuilder, QueryBuilders.prefixQuery("categoryCode", cateCode), type);
        }
        super.queryCondPrepare(queryBuilder, params, type);
    }

}
