package com.thebeastshop.pegasus.merchandise.client;

import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-25
 */
public class CampaignESClient extends AbstractESClient<PsCampaignVO> {

    public CampaignESClient(String index, String type) {
        super(index, type);
    }

    public CampaignESClient(String index, String type, String host, int port) {
        super(index, type, host, port);
    }

    @Override
    public PsCampaignVO build(SearchHit hit, String chnCode) {
        return null;
    }

    @Override
    public PsCampaignVO build(SearchHit hit, String chnCode, Long total) {
        return null;
    }

    public void buildCampaign(Map params, PsCampaignVO psCampaignVO) {
        psCampaignVO.setId(Long.valueOf(String.valueOf(params.get("id"))));
        psCampaignVO.setState(MapUtils.getInteger(params, "state"));
        psCampaignVO.setName((String) params.get("name"));
        psCampaignVO.setTitle((String) params.get("title"));
        psCampaignVO.setDiscountTypeId((Integer) params.get("discountTypeId"));
        psCampaignVO.setDiscountTypeName((String) params.get("discountTypeName"));
        psCampaignVO.setProductScopeId((Integer) params.get("productScopeId"));
        psCampaignVO.setCrossBorderFlag(MapUtils.getInteger(params, "crossBorderFlag"));

        List<Integer> memberLevelIds = (List<Integer>) params.get("memberLevels");
        if (memberLevelIds == null) memberLevelIds = new ArrayList<>();
        psCampaignVO.setMemberLevels(memberLevelIds);

        List<Integer> accessWayIds = (List<Integer>) params.get("accessWayIds");
        if (accessWayIds == null) accessWayIds = new ArrayList<>();
        psCampaignVO.setAccessWayIds(accessWayIds);


        Date startTime = null;
        try {
            String startTimeStr = MapUtils.getString(params, "startTime");
            startTimeStr = StringUtils.replace(startTimeStr, "T", " ");
            startTime = DateUtil.parse(startTimeStr, "yyyy-MM-dd HH:ss:mm");
        } catch (Exception ex) {
        }
        if (startTime != null) {
            psCampaignVO.setStartTime(startTime);
        }


        Date expireTime = null;
        try {
            String expireTimeStr = MapUtils.getString(params, "expireTime");
            expireTimeStr = StringUtils.replace(expireTimeStr, "T", " ");
            expireTime = DateUtil.parse(expireTimeStr, "yyyy-MM-dd HH:ss:mm");
        } catch (Exception ex) {
        }
        if (expireTime != null) {
            psCampaignVO.setExpireTime(expireTime);
        }

        List<Map> campaignSectionList = (List<Map>) params.get("campaignSections");
        if (EmptyUtil.isNotEmpty(campaignSectionList)) {
            List<PsCampaignSectionVO> campaignSections = new ArrayList<>();
            psCampaignVO.setCampaignSectionList(campaignSections);
            for (Map campaignSection : campaignSectionList) {
                PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                psCampaignSectionVO.setId(Long.valueOf(String.valueOf(campaignSection.get("id"))));
                psCampaignSectionVO.setCampaignId(Long.valueOf(String.valueOf(campaignSection.get("campaignId"))));
                psCampaignSectionVO.setConditionType((Integer) campaignSection.get("conditionType"));
                if (campaignSection.containsKey("line")) {
                    psCampaignSectionVO.setLine(new BigDecimal(MapUtils.getDouble(campaignSection, "line")));
                }
                if (campaignSection.containsKey("factor")) {
                    psCampaignSectionVO.setFactor(new BigDecimal(MapUtils.getDouble(campaignSection,"factor")));
                }
                if (campaignSection.containsKey("factorType")) {
                    psCampaignSectionVO.setFactorType(MapUtils.getInteger(campaignSection,"factorType"));
                }
                if (campaignSection.containsKey("ranking")) {
                    psCampaignSectionVO.setRanking(MapUtils.getDouble(campaignSection, "ranking"));
                }
                campaignSections.add(psCampaignSectionVO);

                List<Map> campaignSectionProductList = (List<Map>) campaignSection.get("campaignSectionProducts");
                if (EmptyUtil.isNotEmpty(campaignSectionProductList)) {
                    List<PsCampaignSectionProductVO> campaignSectionProducts = new ArrayList<>();
                    psCampaignSectionVO.setCampaignSectionProducts(campaignSectionProducts);
                    for (Map campaignSectionProduct : campaignSectionProductList) {
                        PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                        psCampaignSectionProductVO.setId(Long.valueOf(String.valueOf(campaignSectionProduct.get("id"))));
                        psCampaignSectionProductVO.setCampaignId(psCampaignVO.getId());
                        psCampaignSectionProductVO.setCampaignSectionId(psCampaignSectionVO.getId());
                        psCampaignSectionProductVO.setProductId(Long.valueOf(String.valueOf(campaignSectionProduct.get("productId"))));
                        psCampaignSectionProductVO.setPricePrice(new BigDecimal(String.valueOf(campaignSectionProduct.get("pricePrice"))));
                        psCampaignSectionProductVO.setPriceCount((Integer) campaignSectionProduct.get("priceCount"));
                        campaignSectionProducts.add(psCampaignSectionProductVO);
                    }
                }
            }
        }
    }

    @Override
    public XContentBuilder getXContentBuilder(PsCampaignVO vo) {
        return null;
    }

    @Override
    public String getPrimaryKeyName() {
        return null;
    }
}
