/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsCustomizeElementMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeElementDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeImageDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsCustomizeElement;
import com.thebeastshop.pegasus.merchandise.model.PcsCustomizeImage;
import com.thebeastshop.pegasus.merchandise.model.PcsSku;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCostPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeColorVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeElementVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeImageVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDTO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.SupportTypeVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcPcsSkuService")
public class McPcsSkuServiceImpl
implements McPcsSkuService {
    @Autowired
    private PcsSkuDomain pcsSkuDomain;
    @Autowired
    private PcsCustomizeElementDomain pcsCustomizeElementDomain;
    @Autowired
    private PcsCustomizeImageDomain pcsCustomizeImageDomain;
    @Autowired
    PcsCustomizeElementMapper pcsCustomizeElementMapper;
    @Autowired
    private PcsSkuSalesPriceChangeDomain pcsSkuSalesPriceChangeDomain;
    @Autowired
    private PcsSkuMapper pcsSkuMapper;

    public Long create(PcsSkuVO vo) {
        Long id = this.pcsSkuDomain.create((PcsSku)this.pcsSkuDomain.buildFromVO(vo));
        PcsSku pcsSku = this.pcsSkuDomain.findById(id);
        vo.setCode(pcsSku.getCode());
        if (vo.getCanCustomize() == 1) {
            this.createCustomize(vo);
        }
        return id;
    }

    public void createCustomize(PcsSkuVO vo) {
        List colorList;
        List colorElementList = vo.getCustomizeVO().getColorElementList();
        List wordElementList = vo.getCustomizeVO().getWordElementList();
        List customizeImageList = vo.getCustomizeVO().getCustomizeImageList();
        HashMap<Long, String> elementIdMap = new HashMap<Long, String>();
        for (PcsCustomizeElementVO obj : colorElementList) {
            colorList = obj.getColorList();
            ArrayList newAttrList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)colorList)) {
                for (PcsCustomizeColorVO colorVO : colorList) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(colorVO.getColorName());
                    list.add(colorVO.getColorValue());
                    list.add(colorVO.getBackgroundColorValue());
                    list.add(colorVO.getWordColorValue());
                    newAttrList.add(list);
                }
            }
            String colorJson = JSON.toJSON(newAttrList).toString();
            PcsCustomizeElement pcsCustomizeElement = (PcsCustomizeElement)this.pcsCustomizeElementDomain.buildFromVO(obj);
            pcsCustomizeElement.setColor(colorJson);
            pcsCustomizeElement.setSkuCode(vo.getCode());
            if (obj.getElementType() == 1) {
                pcsCustomizeElement.setIsmatch(true);
            } else {
                pcsCustomizeElement.setIsmatch(false);
            }
            Long id = this.pcsCustomizeElementDomain.create(pcsCustomizeElement);
            if (obj.getElementType() != 1) continue;
            elementIdMap.put(id, pcsCustomizeElement.getDisplayName());
        }
        for (PcsCustomizeElementVO obj : wordElementList) {
            colorList = obj.getColorElement().getColorList();
            SupportTypeVO supportTypeVO = obj.getSupportTypeVO();
            String temp = "";
            String temp1 = supportTypeVO.getUppercaseLetter() == null ? "" : "1";
            Iterator temp2 = supportTypeVO.getNumber() == null ? "" : "2";
            String temp3 = supportTypeVO.getExpression() == null ? "" : "3";
            String temp4 = supportTypeVO.getLowercaseLetter() == null ? "" : "0";
            temp = temp1 + "," + temp4 + "," + temp2 + "," + temp3;
            PcsCustomizeElement pcsCustomizeElement = (PcsCustomizeElement)this.pcsCustomizeElementDomain.buildFromVO(obj);
            pcsCustomizeElement.setSkuCode(vo.getCode());
            pcsCustomizeElement.setIsmatch(false);
            pcsCustomizeElement.setSupportType(temp);
            Long id = this.pcsCustomizeElementDomain.create(pcsCustomizeElement);
            PcsCustomizeElement child = new PcsCustomizeElement();
            ArrayList newAttrList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)colorList)) {
                for (PcsCustomizeColorVO colorVO : colorList) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(colorVO.getColorName());
                    list.add(colorVO.getColorValue());
                    newAttrList.add(list);
                }
            }
            String colorJson = JSON.toJSON(newAttrList).toString();
            child.setSkuCode(vo.getCode());
            child.setColor(colorJson);
            child.setParentId(id.intValue());
            child.setDisplayName(obj.getColorElement().getDisplayName());
            child.setCreateUserId(obj.getCreateUserId());
            child.setIsmatch(false);
            this.pcsCustomizeElementDomain.create(child);
        }
        for (PcsCustomizeElementVO obj : customizeImageList) {
            String color;
            String displayName;
            String value;
            PcsCustomizeImage pcsCustomizeImage = (PcsCustomizeImage)this.pcsCustomizeImageDomain.buildFromVO(obj);
            pcsCustomizeImage.setSkuCode(vo.getCode());
            List attrList = obj.getAttrs();
            ArrayList newAttrList = new ArrayList();
            Boolean flag = false;
            block5: for (List list2 : attrList) {
                for (Long elementId : elementIdMap.keySet()) {
                    value = (String)elementIdMap.get(elementId);
                    displayName = list2.get(0).toString();
                    color = list2.get(1).toString();
                    if (!value.equals(displayName)) continue;
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(elementId);
                    list.add(color);
                    newAttrList.add(list);
                    flag = true;
                    continue block5;
                }
            }
            if (!flag.booleanValue()) {
                block7: for (List list2 : attrList) {
                    for (Long elementId : elementIdMap.keySet()) {
                        value = (String)elementIdMap.get(elementId);
                        displayName = list2.get(0).toString();
                        color = list2.get(1).toString();
                        PcsCustomizeElement pcsCustomizeElement = this.pcsCustomizeElementMapper.selectByPrimaryKey(Long.valueOf(displayName));
                        if (!value.equals(displayName = pcsCustomizeElement.getDisplayName())) continue;
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(elementId);
                        list.add(color);
                        newAttrList.add(list);
                        continue block7;
                    }
                }
            }
            if (!CollectionUtils.isNotEmpty(newAttrList)) continue;
            String json = JSON.toJSON(newAttrList).toString();
            pcsCustomizeImage.setAttr(json);
            this.pcsCustomizeImageDomain.create(pcsCustomizeImage);
        }
    }

    public void updateCustomize(List<PcsCustomizeElementVO> pcsCustomizeElementVOList, List<PcsCustomizeImageVO> pcsCustomizeImageVOList) {
        for (PcsCustomizeElementVO ceVO : pcsCustomizeElementVOList) {
            PcsCustomizeElement pcsCustomizeElement = new PcsCustomizeElement();
            pcsCustomizeElement.setId(ceVO.getId());
            pcsCustomizeElement.setActive(false);
            this.pcsCustomizeElementDomain.update(pcsCustomizeElement);
        }
        for (PcsCustomizeImageVO ciVO : pcsCustomizeImageVOList) {
            PcsCustomizeImage pcsCustomizeImage = new PcsCustomizeImage();
            pcsCustomizeImage.setId(ciVO.getId());
            pcsCustomizeImage.setActive(false);
            this.pcsCustomizeImageDomain.update(pcsCustomizeImage);
        }
    }

    public List<Long> createSkus(List<PcsSkuVO> list) {
        ArrayList<PcsSku> skuList = new ArrayList<PcsSku>();
        for (PcsSkuVO pcsSkuVO : list) {
            pcsSkuVO.setSkuStatus(PcsSku.SKU_STATUS_DRAFT);
            skuList.add((PcsSku)this.pcsSkuDomain.buildFromVO(pcsSkuVO));
        }
        return this.pcsSkuDomain.createSkus(skuList);
    }

    public boolean update(PcsSkuVO vo) {
        this.pcsSkuDomain.update((PcsSku)this.pcsSkuDomain.buildFromVO(vo));
        if (vo.getOptType() != 1) {
            List<PcsCustomizeElementVO> pcsCustomizeElementVOList = this.pcsCustomizeElementDomain.findByCode(vo.getCode());
            List<PcsCustomizeImageVO> pcsCustomizeImageVOList = this.pcsCustomizeImageDomain.findByCode(vo.getCode());
            if (CollectionUtils.isEmpty(pcsCustomizeElementVOList)) {
                if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
                    this.createCustomize(vo);
                }
            } else {
                this.updateCustomize(pcsCustomizeElementVOList, pcsCustomizeImageVOList);
                if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
                    this.createCustomize(vo);
                }
            }
        }
        return true;
    }

    public PcsSkuVO findById(long id) {
        PcsSku record = this.pcsSkuDomain.findById(id);
        PcsSkuVO vo = (PcsSkuVO)this.pcsSkuDomain.buildFromModel(record);
        return vo;
    }

    public PcsSkuVO findByCode(String code) {
        return this.pcsSkuDomain.findByCode(code);
    }

    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories) {
        return this.pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories);
    }

    public PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories, boolean withBuyerName) {
        return this.pcsSkuDomain.findByCode(code, widthFrontCategories, withBackCategories, withBuyerName);
    }

    public List<Map<String, Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode) {
        return this.pcsSkuDomain.findSkuCanSaleAndCanSeeByChannelCode(channelCode);
    }

    public Map<String, Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode) {
        return this.pcsSkuDomain.findSkuCanSaleAndCanSeeInfo(channelCode, skuCode);
    }

    public List<PcsSkuVO> findByNameOrCode(String nameCode) {
        return this.pcsSkuDomain.findByNameOrCode(nameCode);
    }

    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.findByCond(cond);
    }

    public List<PcsSkuVO> findByCondForExport(PcsSkuCond cond) {
        return this.pcsSkuDomain.findByCondForExport(cond);
    }

    public List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.findSkuTagByCond(cond);
    }

    public Boolean canUpdateSkuSalesPrice(String code) {
        PcsSkuVO vo = this.pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuDomain.canUpdateSalesPrice(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
        return this.pcsSkuDomain.auditSkuSalesPriceChange(code, isPass, type);
    }

    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        return this.pcsSkuDomain.findSkuSalesPriceChangeByCodeAndProcessing(code);
    }

    public List<PcsSkuVO> findSkuByCodes(List<String> codes) {
        return this.pcsSkuDomain.findByCodes(codes);
    }

    public List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories) {
        return this.pcsSkuDomain.findByCodes(codes, withCategories);
    }

    public List<PcsSkuVO> findSkuByCodesWithCategories(List<String> codes, boolean withCategories) {
        return this.pcsSkuDomain.findByCodes(codes, withCategories);
    }

    public Boolean convertSku(PcsSkuVO sku, long skuCustomMadeId) {
        PcsSku pcsSku = (PcsSku)this.pcsSkuDomain.buildFromVO(sku);
        return this.pcsSkuDomain.convertSku(pcsSku, skuCustomMadeId);
    }

    public boolean transferSku(List<String> skuCodes, Long buyerId) {
        return this.pcsSkuDomain.transferSku(skuCodes, buyerId);
    }

    public List<PcsSkuInfoVO> allSkuInfo() {
        return this.pcsSkuDomain.allSkuInfo();
    }

    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return this.pcsSkuDomain.findStockByCode(skuCode);
    }

    public List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond) {
        return this.pcsSkuDomain.findChannelSkuForNoDistribute(cond);
    }

    public void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId) {
        this.pcsSkuDomain.setSkuChannel(skuCodeList, channelCodeList, operatorId);
    }

    public List<PcsSkuVO> findSkuByIds(List<Long> ids) {
        return this.pcsSkuDomain.findSkuByIds(ids);
    }

    public Boolean canUpdateCostPrice(String code) {
        PcsSkuVO vo = this.pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuDomain.canUpdateCostPrice(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public Boolean canUpdateSupplier(String code) {
        PcsSkuVO vo = this.pcsSkuDomain.findByCode(code);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            return this.pcsSkuDomain.canUpdateSupplier(code);
        }
        throw new PurchaseException("PC0008", "\u65e0\u6548\u7684code");
    }

    public long countSkuByCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.countSkuByCond(cond);
    }

    public String getCrossBorderFlagByCodes(List<String> codes) {
        return this.pcsSkuDomain.getCrossBorderFlagByCodes(codes);
    }

    public Integer updateSkuCategoryNameByCode(String skuCategoryName, String skuCode) {
        return this.pcsSkuDomain.updateSkuCategoryNameByCode(skuCategoryName, skuCode);
    }

    public List<Integer> getSalesPriceByCodes(List<String> codes) {
        return this.pcsSkuDomain.getSalesPriceByCodes(codes);
    }

    public List<Map> getSalesPriceByProdId(Long prodId) {
        return this.pcsSkuDomain.getSalesPriceByProdId(prodId);
    }

    public List<PcsSkuVO> findSkuAuditByIds(List<Long> ids) {
        return this.pcsSkuDomain.findSkuAuditByIds(ids);
    }

    public List<PcsSkuBarcodeVO> selectByBarCode(String barCode) {
        return this.pcsSkuDomain.selectByBarCode(barCode);
    }

    public List<PcsSkuVO> findSkuQualifyByCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.findSkuQualifyByCond(cond);
    }

    public List<PcsSkuVO> findSkuQualifyByInCond(PcsSkuCond cond) {
        return this.pcsSkuDomain.findSkuQualifyByInCond(cond);
    }

    public List<PcsSkuVO> findSharedImportDoc() {
        return this.pcsSkuDomain.findSharedImportDoc();
    }

    public List<PcsSkuVO> findSharedAptitude() {
        return this.pcsSkuDomain.findSharedAptitude();
    }

    public List<PcsSkuVO> findSkuBySupplierId(Long supplierId) {
        return this.pcsSkuDomain.findSkuBySupplierId(supplierId);
    }

    public boolean updatePrdcRecipeSkuCost(PcsSkuVO vo) {
        int skuStatus = vo.getSkuStatus();
        String skuCode = vo.getCode();
        PcsSku pcsSku = new PcsSku();
        pcsSku.setId(vo.getId());
        switch (skuStatus) {
            case 0: {
                pcsSku.setCostPrice(vo.getCostPrice());
                pcsSku.setOldCostPrice(vo.getCostPrice());
                break;
            }
            case 1: {
                pcsSku.setSkuStatus(1);
                List<PcsSkuCostPriceChange> costPriceChangeList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 1);
                if (!EmptyUtil.isNotEmpty(costPriceChangeList)) break;
                PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
                pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange.setChangeTime(new Date());
                pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
                this.pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
                break;
            }
            case 2: {
                pcsSku.setSkuStatus(1);
                PcsSkuCostPriceChange pcsSkuCostPriceChange = new PcsSkuCostPriceChange();
                pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
                pcsSkuCostPriceChange.setSkuCode(skuCode);
                pcsSkuCostPriceChange.setChangeTime(new Date());
                this.pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange);
                break;
            }
            case 3: {
                pcsSku.setSkuStatus(1);
                List<PcsSkuCostPriceChange> costPriceChangeList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(skuCode, 4);
                if (!EmptyUtil.isNotEmpty(costPriceChangeList)) break;
                PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
                pcsSkuCostPriceChange.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange.setChangeTime(new Date());
                pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
                this.pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
                break;
            }
            case 9: {
                pcsSku.setSkuStatus(1);
                PcsSkuCostPriceChange pcsSkuCostPriceChange1 = new PcsSkuCostPriceChange();
                pcsSkuCostPriceChange1.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuCostPriceChange1.setNewPrice(vo.getCostPrice());
                pcsSkuCostPriceChange1.setSkuCode(skuCode);
                pcsSkuCostPriceChange1.setChangeTime(new Date());
                this.pcsSkuSalesPriceChangeDomain.addCostPriceChange(pcsSkuCostPriceChange1);
                break;
            }
        }
        pcsSku.setOldCostPrice(vo.getCostPrice());
        this.pcsSkuDomain.updateSku(pcsSku);
        return false;
    }

    public int updateSku(PcsSkuVO vo) {
        PcsSku pcsSku = new PcsSku();
        BeanUtils.copyProperties((Object)vo, (Object)pcsSku);
        if (vo.getOptType() == 3) {
            int skuStatus = vo.getSkuStatus();
            List<PcsSkuCostPriceChange> costPriceChangeList = this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(vo.getCode(), skuStatus == 1 ? 1 : 4);
            if (EmptyUtil.isNotEmpty(costPriceChangeList)) {
                PcsSkuCostPriceChange pcsSkuCostPriceChange = costPriceChangeList.get(0);
                pcsSkuCostPriceChange.setChangeTime(new Date());
                pcsSkuCostPriceChange.setNewPrice(vo.getCostPrice());
                this.pcsSkuSalesPriceChangeDomain.updateCostPriceChange(pcsSkuCostPriceChange);
            }
            pcsSku.setOldCostPrice(vo.getCostPrice());
        }
        return this.pcsSkuDomain.updateSku(pcsSku);
    }

    public boolean costPriceNeedApproval(PcsSkuVO vo) {
        PcsSku pcsSku = new PcsSku();
        BeanUtils.copyProperties((Object)vo, (Object)pcsSku);
        return this.pcsSkuDomain.costPriceNeedApproval(pcsSku);
    }

    public Integer getMonthlyByCodes(List<String> skuCodes) {
        return this.pcsSkuDomain.getMonthlyByCodes(skuCodes);
    }

    public void autoUpdateServiceLevel() {
        this.pcsSkuMapper.autoUpdateServiceLevel1();
        this.pcsSkuMapper.autoUpdateServiceLevel2();
        this.pcsSkuMapper.autoUpdateServiceLevel3();
        this.pcsSkuMapper.autoUpdateServiceLevel4();
    }

    public Map<String, PcsSkuDTO> getSkuNameByCodes(Set<String> skuCodes) {
        List<PcsSku> skuList = this.pcsSkuMapper.findSkuSimpleInfoByCodes(skuCodes);
        HashMap<String, PcsSkuDTO> resultMap = new HashMap<String, PcsSkuDTO>();
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (PcsSku pcsSku : skuList) {
                PcsSkuDTO dto = new PcsSkuDTO();
                dto.setNameCn(pcsSku.getNameCn());
                dto.setSkuType(pcsSku.getSkuType());
                resultMap.put(pcsSku.getCode(), dto);
            }
        }
        return resultMap;
    }
}

