/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCostPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSupplierChangeVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.math.BigDecimal;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/sku/sales/price/change")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsSkuSalesPriceChangeService")
public class McPcsSkuSalesPriceChangeServiceImpl
implements McPcsSkuSalesPriceChangeService {
    @Autowired
    private PcsSkuSalesPriceChangeDomain pcsSkuSalesPriceChangeDomain;

    public Long create(String code, BigDecimal price) {
        return this.pcsSkuSalesPriceChangeDomain.create(code, price);
    }

    public boolean update(PcsSkuSalesPriceChangeVO record) {
        return this.pcsSkuSalesPriceChangeDomain.update(this.pcsSkuSalesPriceChangeDomain.bulidFromVO(record));
    }

    public PcsSkuSalesPriceChangeVO findById(long id) {
        return this.pcsSkuSalesPriceChangeDomain.buildFromModel(this.pcsSkuSalesPriceChangeDomain.findById(id));
    }

    public List<PcsSkuSalesPriceChangeVO> findByCode(String code) {
        return BeanUtil.buildListFrom(this.pcsSkuSalesPriceChangeDomain.findByCode(code), PcsSkuSalesPriceChangeVO.class);
    }

    @GET
    @Path(value="code/{code}/status/{status}")
    public List<PcsSkuSalesPriceChangeVO> findByCodeAndStatus(@PathParam(value="code") String code, @PathParam(value="status") Integer status) {
        List<PcsSkuSalesPriceChange> pcsSkuSalesPriceChanges = this.pcsSkuSalesPriceChangeDomain.findByCodeAndStatus(code, status);
        return BeanUtil.buildListFrom(pcsSkuSalesPriceChanges, PcsSkuSalesPriceChangeVO.class);
    }

    public List<PcsSkuCostPriceChangeVO> findCostPriceChangeByCode(String code) {
        return BeanUtil.buildListFrom(this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCode(code), PcsSkuCostPriceChangeVO.class);
    }

    public List<PcsSkuSupplierChangeVO> findSupplierChangeByCode(String code) {
        return BeanUtil.buildListFrom(this.pcsSkuSalesPriceChangeDomain.findSupplierChangeByCode(code), PcsSkuSupplierChangeVO.class);
    }

    public PcsSkuSalesPriceChangeVO auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
        return this.pcsSkuSalesPriceChangeDomain.buildFromModel(this.pcsSkuSalesPriceChangeDomain.auditSkuSalesPriceChange(code, isPass, type));
    }

    public PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code, Integer type) {
        return this.pcsSkuSalesPriceChangeDomain.buildFromModel(this.pcsSkuSalesPriceChangeDomain.findSkuSalesPriceChangeByCodeAndProcessing(code, type));
    }

    public Long createSupplierChange(String code, Integer price) {
        return this.pcsSkuSalesPriceChangeDomain.createSupplierChange(code, price);
    }

    public Long createCostPriceChange(String code, BigDecimal price) {
        return this.pcsSkuSalesPriceChangeDomain.createCostPriceChange(code, price);
    }

    public PcsSkuCostPriceChangeVO auditSkuCostPriceChange(String code, Boolean isPass) {
        return (PcsSkuCostPriceChangeVO)BeanUtil.buildFrom((Object)this.pcsSkuSalesPriceChangeDomain.auditSkuCostPriceChange(code, isPass, 1), PcsSkuCostPriceChangeVO.class);
    }

    public PcsSkuSupplierChangeVO auditSkuSupplierChange(String code, Boolean isPass) {
        return (PcsSkuSupplierChangeVO)BeanUtil.buildFrom((Object)this.pcsSkuSalesPriceChangeDomain.auditSkuSupplierChange(code, isPass, 1), PcsSkuSupplierChangeVO.class);
    }

    public List<PcsSkuCostPriceChangeVO> findCostPriceChangeByCodeAndStatus(String code, Integer status) {
        return BeanUtil.buildListFrom(this.pcsSkuSalesPriceChangeDomain.findCostPriceChangeByCodeAndStatus(code, status), PcsSkuCostPriceChangeVO.class);
    }

    public List<PcsSkuSupplierChangeVO> findSupplierChangeByCodeAndStatus(String code, Integer status) {
        return BeanUtil.buildListFrom(this.pcsSkuSalesPriceChangeDomain.findSupplierChangeByCodeAndStatus(code, status), PcsSkuSupplierChangeVO.class);
    }
}

