/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.ApprovalRecordCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuQualifyCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuQualifyDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQualify;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuQualifyService;
import com.thebeastshop.pegasus.merchandise.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQualifyVO;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/skuQualify")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsSkuQualifyService")
public class McPcsSkuQualifyServiceImpl
implements McPcsSkuQualifyService {
    @Autowired
    private PcsSkuQualifyDomain pcsSkuQualifyDomain;

    @POST
    public Long create(PcsSkuQualifyVO vo) {
        return this.pcsSkuQualifyDomain.create(this.pcsSkuQualifyDomain.buildFromVO(vo));
    }

    @PUT
    public Boolean update(PcsSkuQualifyVO vo) {
        return this.pcsSkuQualifyDomain.update(this.pcsSkuQualifyDomain.buildFromVO(vo));
    }

    @GET
    @Path(value="{id:\\d+}")
    public PcsSkuQualifyVO findById(@PathParam(value="id") Long id) {
        PcsSkuQualify record = this.pcsSkuQualifyDomain.findById(id);
        PcsSkuQualifyVO vo = this.pcsSkuQualifyDomain.buildFromModel(record);
        return vo;
    }

    public List<PcsSkuQualifyVO> findByCond(PcsSkuQualifyCond cond) {
        List<PcsSkuQualifyVO> recordList = this.pcsSkuQualifyDomain.findByCond(cond);
        return recordList;
    }

    public List<PcsSkuQualifyVO> findByCriteria(PcsSkuQualifyCond cond) {
        List<PcsSkuQualify> recordList = this.pcsSkuQualifyDomain.findByCriteria(cond);
        ArrayList<PcsSkuQualifyVO> vos = new ArrayList<PcsSkuQualifyVO>(recordList.size());
        for (PcsSkuQualify record : recordList) {
            PcsSkuQualifyVO vo = this.pcsSkuQualifyDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @GET
    @Path(value="name/{name}")
    public PcsSkuQualifyVO findBySkuCode(@PathParam(value="name") String skuCode) {
        PcsSkuQualify record = this.pcsSkuQualifyDomain.findBySkuCode(skuCode);
        PcsSkuQualifyVO vo = this.pcsSkuQualifyDomain.buildFromModel(record);
        return vo;
    }

    public List<PcsSkuQualifyVO> findByIds(List<Long> ids) {
        List<PcsSkuQualify> recordList = this.pcsSkuQualifyDomain.findByIds(ids);
        ArrayList<PcsSkuQualifyVO> vos = new ArrayList<PcsSkuQualifyVO>(recordList.size());
        for (PcsSkuQualify record : recordList) {
            PcsSkuQualifyVO vo = this.pcsSkuQualifyDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public Boolean auditSkuQualify(Long userId, long id, Boolean isPass, Integer type) {
        return this.pcsSkuQualifyDomain.auditSkuQualify(userId, id, isPass, type);
    }

    public Boolean auditSkuQualify(ApprovalRecordVO vo, Boolean isPass, Integer importedType) {
        return this.pcsSkuQualifyDomain.auditSkuQualify(vo, isPass, importedType);
    }

    public Boolean auditSkuQualify(Long id, Boolean isPass, Integer type) {
        return this.pcsSkuQualifyDomain.auditSkuQualify(id, isPass, type);
    }

    public long countByCond(PcsSkuQualifyCond cond) {
        return this.pcsSkuQualifyDomain.countByCond(cond);
    }

    public boolean createApprovalRecord(ApprovalRecordVO vo) {
        return this.pcsSkuQualifyDomain.createApprovalRecord(vo);
    }

    public List<ApprovalRecordVO> findApprovalRecordsByCond(ApprovalRecordCond cond) {
        return this.pcsSkuQualifyDomain.findApprovalRecordsByCond(cond);
    }

    public long getFileCountByCond(PcsSkuQualifyCond cond) {
        return this.pcsSkuQualifyDomain.getFileCountByCond(cond);
    }
}

