/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.PcsSkuQcImgDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQcImg;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuQcImgService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQcImgVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/sku/qc_img")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsSkuQcImgService")
public class McPcsSkuQcImgServiceImpl
implements McPcsSkuQcImgService {
    @Autowired
    private PcsSkuQcImgDomain pcsSkuQcImgDomain;

    @POST
    public Long createQcImg(PcsSkuQcImgVO vo) {
        PcsSkuQcImg pcsSkuQcImg = (PcsSkuQcImg)BeanUtil.buildFrom((Object)vo, PcsSkuQcImg.class);
        this.pcsSkuQcImgDomain.createQcImg(pcsSkuQcImg);
        return pcsSkuQcImg.getId();
    }

    @DELETE
    @Path(value="sku_code/{skuCode}")
    public int deleteQcImgBySkuCode(@PathParam(value="skuCode") String skuCode) {
        return this.pcsSkuQcImgDomain.deleteQcImgBySkuCode(skuCode);
    }

    @GET
    @Path(value="sku_code/{skuCode}")
    public List<PcsSkuQcImgVO> findPcsSkuQcImgBySkuCode(@PathParam(value="skuCode") String skuCode) {
        List<PcsSkuQcImg> skuQcImgs = this.pcsSkuQcImgDomain.findPcsSkuQcImgBySkuCode(skuCode);
        List vos = BeanUtil.buildListFrom(skuQcImgs, PcsSkuQcImgVO.class);
        return vos;
    }
}

