/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.price.AbstractSpecialPriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.PriceCalculator;
import com.thebeastshop.pegasus.merchandise.service.impl.McPsProductServiceImpl;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialSpvPriceCalculator
extends AbstractSpecialPriceCalculator
implements PriceCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(McPsProductServiceImpl.class);
    private PsSpvVO spvVO;
    private PsCampaignVO campaign;

    public SpecialSpvPriceCalculator(PriceCalculator sourcePriceCalculator, PsSpvVO spvVO, PsCampaignVO campaign) {
        super(sourcePriceCalculator);
        this.spvVO = spvVO;
        this.campaign = campaign;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = this.getPrevPrice(results);
        Long campaignId = this.campaign.getId();
        if (this.spvVO.getCombined() != null && this.spvVO.getCombined().booleanValue()) {
            String skuCode = this.spvVO.getSkuCode();
            if ("462".equals(String.valueOf(campaignId))) {
                LOGGER.info("===\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (specialSkuMap.containsKey(skuCode)) {
                    LOGGER.info("===\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", specialSkuMap.get(skuCode));
                    targetPrice = (BigDecimal)specialSkuMap.get(skuCode);
                }
            } else if ("481".equals(String.valueOf(campaignId))) {
                LOGGER.info("===481\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (special481SkuMap.containsKey(skuCode)) {
                    LOGGER.info("===481\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", special481SkuMap.get(skuCode));
                    targetPrice = (BigDecimal)special481SkuMap.get(skuCode);
                }
            } else if ("482".equals(String.valueOf(campaignId))) {
                LOGGER.info("===482\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (special482SkuMap.containsKey(skuCode)) {
                    LOGGER.info("===482\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", special482SkuMap.get(skuCode));
                    targetPrice = (BigDecimal)special482SkuMap.get(skuCode);
                }
            } else if ("463".equals(String.valueOf(campaignId))) {
                LOGGER.info("===463\u67e5\u8be2\u5546\u54c1\u8be6\u60c5SKUCODE \u53c2\u6570\u4e3a code= {}", (Object)skuCode);
                if (special463SkuMap.containsKey(skuCode)) {
                    LOGGER.info("===463\u67e5\u8be2\u5546\u54c1\u8be6\u60c5price \u53c2\u6570\u4e3a code= {}", special463SkuMap.get(skuCode));
                    targetPrice = (BigDecimal)special463SkuMap.get(skuCode);
                }
            } else if ("503".equals(String.valueOf(campaignId))) {
                if (special503SkuMap.containsKey(skuCode)) {
                    targetPrice = (BigDecimal)special503SkuMap.get(skuCode);
                }
            } else if ("574".equals(String.valueOf(campaignId))) {
                if (special574SkuMap.containsKey(skuCode)) {
                    targetPrice = (BigDecimal)special574SkuMap.get(skuCode);
                }
            } else if ("590".equals(String.valueOf(campaignId))) {
                if (special590SkuMap.containsKey(skuCode)) {
                    targetPrice = (BigDecimal)special590SkuMap.get(skuCode);
                }
            } else if ("591".equals(String.valueOf(campaignId))) {
                if (special591SkuMap.containsKey(skuCode)) {
                    targetPrice = (BigDecimal)special591SkuMap.get(skuCode);
                }
            } else if ("592".equals(String.valueOf(campaignId))) {
                if (special592SkuMap.containsKey(skuCode)) {
                    targetPrice = (BigDecimal)special592SkuMap.get(skuCode);
                }
            } else if ("594".equals(String.valueOf(campaignId)) && special594SkuMap.containsKey(skuCode)) {
                targetPrice = (BigDecimal)special594SkuMap.get(skuCode);
            }
        }
        return targetPrice;
    }
}

