/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.price.BDDiscountPriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.DiscountPriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.PriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.RushPriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.SourcePrice;
import com.thebeastshop.pegasus.merchandise.price.VIPDiscountPriceCalculator;
import com.thebeastshop.pegasus.merchandise.service.impl.McPsProductServiceImpl;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceCalculators {
    private static final Logger logger = LoggerFactory.getLogger(McPsProductServiceImpl.class);

    public static BigDecimal calculateProductDiscountPrice(String productCode, Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, BigDecimal discountAmount) {
        BigDecimal discountPrice = PriceCalculators.calculateDiscountPrice(campaignList, originalPrice, allowVipDiscount, discountAmount);
        logger.debug("\u8ba1\u7b97\u5546\u54c1\u4ef7\u683c,\u6298\u6263\u4ef7\uff1a{}", (Object)discountPrice);
        return discountPrice;
    }

    public static BigDecimal calculateSpvDiscountPrice(PsSpvVO spvVO, Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, BigDecimal discountAmount) {
        return PriceCalculators.calculateSpvDiscountPrice(spvVO, allowVipDiscount, originalPrice, campaignList, discountAmount, null);
    }

    public static BigDecimal calculateSpvDiscountPrice(PsSpvVO spvVO, Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, BigDecimal discountAmount, List<PriceCalResultVO> results) {
        if (discountAmount == null) {
            throw new PublicException("\u4f1a\u5458\u6298\u6263\u7387\u53c2\u6570\u6ca1\u6709\u4f20");
        }
        BigDecimal discountPrice = PriceCalculators.calculateDiscountPrice(campaignList, originalPrice, allowVipDiscount, discountAmount, results);
        logger.debug("\u8ba1\u7b97SPV\u4ef7\u683c,\u6298\u6263\u4ef7\uff1a{}", (Object)discountPrice);
        return discountPrice;
    }

    public static BigDecimal calculateSpvBdDiscountPrice(PsSpvVO spvVO, Boolean allowBdDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, BigDecimal bdDiscountAmount, List<PriceCalResultVO> results) {
        if (bdDiscountAmount == null) {
            throw new PublicException("\u751f\u65e5\u6298\u6263\u7387\u53c2\u6570\u6ca1\u6709\u4f20");
        }
        BigDecimal discountPrice = PriceCalculators.calculateBdDiscountPrice(campaignList, originalPrice, allowBdDiscount, bdDiscountAmount, results);
        logger.debug("\u8ba1\u7b97SPV\u751f\u65e5\u4ef7\u683c,\u6298\u6263\u4ef7\uff1a{}", (Object)discountPrice);
        return discountPrice;
    }

    public static BigDecimal calculateSkuDiscountPrice(PsSkuVO skuVO, Boolean allowVipDiscount, BigDecimal originalPrice, List<PsCampaignVO> campaignList, BigDecimal discountAmount) {
        BigDecimal discountPrice = PriceCalculators.calculateDiscountPrice(campaignList, originalPrice, allowVipDiscount, discountAmount);
        logger.debug("\u8ba1\u7b97SKU\u4ef7\u683c,\u6298\u6263\u4ef7\uff1a{}", (Object)discountPrice);
        return discountPrice;
    }

    private static BigDecimal calculateDiscountPrice(List<PsCampaignVO> campaignList, BigDecimal originalPrice, Boolean allowVipDiscount, BigDecimal discountAmount, List<PriceCalResultVO> results) {
        SourcePrice originalPriceCalculator;
        BigDecimal targetPrice = originalPrice;
        PriceCalculator priceCalculator = originalPriceCalculator = new SourcePrice(targetPrice);
        Boolean hasRush = false;
        if (CollectionUtils.isNotEmpty(campaignList)) {
            for (PsCampaignVO campaign : campaignList) {
                List sectionList;
                Integer discountType = campaign.getDiscountTypeId();
                if (discountType != 1 && discountType != 6 || CollectionUtils.isEmpty((Collection)(sectionList = campaign.getCampaignSectionList()))) continue;
                PsCampaignSectionVO section = (PsCampaignSectionVO)sectionList.get(0);
                BigDecimal factor = section.getFactor();
                Integer factorType = section.getFactorType();
                if (factor == null || null == factorType) continue;
                if (discountType == 6) {
                    hasRush = true;
                    priceCalculator = new RushPriceCalculator(originalPriceCalculator, factor, factorType, campaign.getId());
                    break;
                }
                if (hasRush.booleanValue()) continue;
                priceCalculator = new DiscountPriceCalculator(priceCalculator, factor, factorType, campaign.getId());
            }
        }
        if (!hasRush.booleanValue()) {
            priceCalculator = new VIPDiscountPriceCalculator(priceCalculator, discountAmount, hasRush, allowVipDiscount);
        }
        targetPrice = priceCalculator.calculate(results);
        return targetPrice;
    }

    private static BigDecimal calculateBdDiscountPrice(List<PsCampaignVO> campaignList, BigDecimal originalPrice, Boolean allowBdDiscount, BigDecimal bdDiscountAmount, List<PriceCalResultVO> results) {
        SourcePrice originalPriceCalculator;
        BigDecimal targetPrice = originalPrice;
        PriceCalculator priceCalculator = originalPriceCalculator = new SourcePrice(targetPrice);
        Boolean hasRush = false;
        if (CollectionUtils.isNotEmpty(campaignList)) {
            for (PsCampaignVO campaign : campaignList) {
                List sectionList;
                Integer discountType = campaign.getDiscountTypeId();
                if (discountType != 1 && discountType != 6 || CollectionUtils.isEmpty((Collection)(sectionList = campaign.getCampaignSectionList()))) continue;
                PsCampaignSectionVO section = (PsCampaignSectionVO)sectionList.get(0);
                BigDecimal factor = section.getFactor();
                Integer factorType = section.getFactorType();
                if (factor == null || null == factorType) continue;
                if (discountType == 6) {
                    hasRush = true;
                    priceCalculator = new RushPriceCalculator(originalPriceCalculator, factor, factorType, campaign.getId());
                    break;
                }
                if (hasRush.booleanValue()) continue;
                priceCalculator = new DiscountPriceCalculator(priceCalculator, factor, factorType, campaign.getId());
            }
        }
        if (!hasRush.booleanValue()) {
            priceCalculator = new BDDiscountPriceCalculator(priceCalculator, bdDiscountAmount, hasRush, allowBdDiscount);
        }
        targetPrice = priceCalculator.calculate(results);
        return targetPrice;
    }

    private static BigDecimal calculateDiscountPrice(List<PsCampaignVO> campaignList, BigDecimal originalPrice, Boolean allowVipDiscount, BigDecimal discountAmount) {
        return PriceCalculators.calculateDiscountPrice(campaignList, originalPrice, allowVipDiscount, discountAmount, null);
    }
}

