/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.alibaba.fastjson.JSONArray;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCombinationCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCombinationMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeValueDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCombinationDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCombination;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCombinationExample;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pcsSkuCombinationDomain")
public class PcsSkuCombinationDomainImpl
extends AbstractBaseDomain<PcsSkuCombinationVO, PcsSkuCombination>
implements PcsSkuCombinationDomain {
    @Autowired
    private PcsSkuCombinationMapper pcsSkuCombinationMapper;
    @Autowired
    private OpAttributeDomain opAttributeDomain;
    @Autowired
    private OpAttributeValueDomain opAttributeValueDomain;
    @Autowired
    private PcsSkuDomain pcsSkuDomain;

    @Override
    public boolean create(PcsSkuCombination skuCombination) {
        skuCombination.setActive(true);
        return this.pcsSkuCombinationMapper.insert(skuCombination) != 0;
    }

    @Override
    public boolean update(PcsSkuCombination skuCombination) {
        return this.pcsSkuCombinationMapper.updateByPrimaryKeySelective(skuCombination) != 0;
    }

    @Override
    public List<PcsSkuCombinationVO> findSkuCombinationBySpvId(PcsSkuCombinationCond cond) {
        PcsSkuCombinationExample example = new PcsSkuCombinationExample();
        PcsSkuCombinationExample.Criteria criteria = example.createCriteria();
        criteria.andSpvIdEqualTo(cond.getSpvId());
        criteria.andActiveEqualTo(cond.getActive());
        List<PcsSkuCombination> skuCombinationList = this.pcsSkuCombinationMapper.selectByExample(example);
        List skuCombinationVOList = BeanUtil.buildListFrom(skuCombinationList, PcsSkuCombinationVO.class);
        for (PcsSkuCombinationVO pcsSkuCombinationVO : skuCombinationVOList) {
            if (cond.getWithSku().booleanValue() && StringUtils.isNotEmpty((String)pcsSkuCombinationVO.getSubSkuCode())) {
                pcsSkuCombinationVO.setSubSkuVO(this.pcsSkuDomain.findByCode(pcsSkuCombinationVO.getSubSkuCode()));
            }
            LinkedHashMap<Long, Long> attrValueIdMap = this.getAttributeMap(pcsSkuCombinationVO.getAttrs());
            pcsSkuCombinationVO.setAttrValueIds(attrValueIdMap);
        }
        return skuCombinationVOList;
    }

    private LinkedHashMap<Long, Long> getAttributeMap(String jsonText) {
        LinkedHashMap<Long, Long> map = new LinkedHashMap<Long, Long>();
        JSONArray jsonArray = JSONArray.parseArray((String)jsonText);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONArray attrJson = jsonArray.getJSONArray(i);
            Long attrId = attrJson.getLong(0);
            Long attrValueId = attrJson.getLongValue(1);
            map.put(attrId, attrValueId);
        }
        return map;
    }

    @Override
    public List<PcsSkuCombination> findBySpvId(Long spvId) {
        PcsSkuCombinationExample example = new PcsSkuCombinationExample();
        example.createCriteria().andSpvIdEqualTo(spvId).andActiveEqualTo(true);
        return this.pcsSkuCombinationMapper.selectByExample(example);
    }

    @Override
    public List<PcsSkuCombination> findBySpvIdAndCode(Long spvId, String code) {
        PcsSkuCombinationExample example = new PcsSkuCombinationExample();
        example.createCriteria().andSpvIdEqualTo(spvId).andSubSkuCodeEqualTo(code).andActiveEqualTo(true);
        return this.pcsSkuCombinationMapper.selectByExample(example);
    }

    @Override
    public List<PcsSkuCombinationVO> findSkuCombinationBySpvId(Long spvId) {
        List<PcsSkuCombinationVO> result = this.pcsSkuCombinationMapper.selectBySpvId(spvId);
        for (PcsSkuCombinationVO combination : result) {
            JSONArray arr = JSONArray.parseArray((String)combination.getAttrs());
            StringBuffer attrValue = new StringBuffer();
            for (Object o : arr) {
                JSONArray a = (JSONArray)o;
                OpAttributeValueVO opAttributeValue = this.opAttributeValueDomain.findOpAttributeValueById(Long.parseLong(a.get(1).toString()));
                attrValue.append(opAttributeValue.getValueText()).append(" ");
            }
            combination.setAttrValue(attrValue.toString());
        }
        return result;
    }
}

