/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsQualityCheckItemMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsQualityCheckItemDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsQualityCheckItem;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualityCheckItemVO;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsQualityCheckItemDomain")
public class PcsQualityCheckItemDomainImpl
extends AbstractBaseDomain<PcsQualityCheckItemVO, PcsQualityCheckItem>
implements PcsQualityCheckItemDomain {
    @Autowired
    private PcsQualityCheckItemMapper pcsQualityCheckItemMapper;

    @Override
    public PcsQualityCheckItemVO findById(Long id) {
        return this.pcsQualityCheckItemMapper.findById(id);
    }

    @Override
    public List<PcsQualityCheckItemVO> findByIds(List<Long> ids) {
        return this.pcsQualityCheckItemMapper.findByIds(ids);
    }

    @Override
    public List<PcsQualityCheckItemVO> findAll() {
        return this.pcsQualityCheckItemMapper.findAll();
    }

    @Override
    @Transactional
    public boolean add(PcsQualityCheckItemVO vo) {
        PcsQualityCheckItem record = (PcsQualityCheckItem)this.buildFromVO(vo);
        this.pcsQualityCheckItemMapper.insert(record);
        vo.setId(record.getId());
        this.updateCode(this.generateCode(vo.getId()), vo.getId());
        return true;
    }

    @Override
    @Transactional
    public boolean update(PcsQualityCheckItemVO vo) {
        this.pcsQualityCheckItemMapper.updateByPrimaryKeySelective((PcsQualityCheckItem)this.buildFromVO(vo));
        return true;
    }

    @Override
    @Transactional
    public PcsQualityCheckItemVO save(PcsQualityCheckItemVO vo) {
        if (NullUtil.isNotNull((Object)vo.getId())) {
            this.update(vo);
        } else {
            this.add(vo);
        }
        return vo;
    }

    private void updateCode(String code, Long id) {
        PcsQualityCheckItem record = new PcsQualityCheckItem();
        record.setId(id);
        record.setCode(code);
        this.pcsQualityCheckItemMapper.updateByPrimaryKeySelective(record);
    }

    private String generateCode(Long id) {
        String code = id.toString();
        if (code.length() >= 3) {
            return code;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = code.length(); i < 3; ++i) {
            sb.append("0");
        }
        return sb.toString() + code;
    }
}

