/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsQualificationCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsQualificationMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsQualificationDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsQualification;
import com.thebeastshop.pegasus.merchandise.model.PcsQualificationExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualificationVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsQualificationDomain")
public class PcsQualificationDomainImpl
implements PcsQualificationDomain,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsQualificationDomainImpl.class);
    @Autowired
    private PcsQualificationMapper pcsQualificationMapper;

    @Override
    public PcsQualification buildFromVO(PcsQualificationVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsQualification record = new PcsQualification();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsQualificationVO buildFromModel(PcsQualification record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsQualificationVO vo = new PcsQualificationVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsQualification record) {
        this.pcsQualificationMapper.insertSelective(record);
        return record.getId();
    }

    @Override
    @Transactional
    public Boolean update(PcsQualification record) {
        return this.pcsQualificationMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public PcsQualification findById(Long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsQualificationMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsQualificationVO> findByCond(PcsQualificationCond cond) {
        List<PcsQualificationVO> recordList = this.pcsQualificationMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsQualification> findByCriteria(PcsQualificationCond cond) {
        List<PcsQualification> recordList;
        PcsQualificationExample example = new PcsQualificationExample();
        if (cond.getQualifyId() != null) {
            example.createCriteria().andQualifyIdEqualTo(cond.getQualifyId());
        }
        if (StringUtils.isNotEmpty((CharSequence)cond.getCode())) {
            example.createCriteria().andCodeLike(SQLUtils.allLike((String)cond.getCode()));
        }
        if (cond.getType() != null) {
            example.createCriteria().andTypeEqualTo(cond.getType());
        }
        if (cond.getStartExpireDate() != null) {
            example.createCriteria().andExpireDateGreaterThanOrEqualTo(cond.getStartExpireDate());
        }
        if (cond.getEndExpireDate() != null) {
            example.createCriteria().andExpireDateLessThanOrEqualTo(cond.getEndExpireDate());
        }
        if (cond.getIsPostMeeting() != null) {
            example.createCriteria().andIsPostMeetingEqualTo(cond.getIsPostMeeting());
        }
        if (CollectionUtils.isEmpty(recordList = this.pcsQualificationMapper.selectByExample(example))) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsQualification> findByIds(List<Long> ids) {
        ArrayList<PcsQualification> recordList = new ArrayList<PcsQualification>();
        for (long id : ids) {
            PcsQualification record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public long countByCond(PcsQualificationCond cond) {
        return this.pcsQualificationMapper.countByCond(cond);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.pcsQualificationMapper.deleteByPrimaryKey(id);
    }

    @Override
    public Long deleteByQualifyId(Long qualifyId) {
        return this.pcsQualificationMapper.deleteByQualifyId(qualifyId);
    }

    @Override
    public List<PcsQualification> findByQualifyId(Long qualifyId) {
        List<PcsQualificationVO> list = this.pcsQualificationMapper.findByQualifyId(qualifyId);
        ArrayList<PcsQualification> docs = new ArrayList<PcsQualification>();
        for (PcsQualificationVO vo : list) {
            docs.add(this.buildFromVO(vo));
        }
        return docs;
    }

    public Boolean check(Object obj) {
        return null;
    }
}

