/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsImportDocCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsImportDocMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsImportDocDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsImportDoc;
import com.thebeastshop.pegasus.merchandise.model.PcsImportDocExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsImportDocVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsImportDocDomain")
public class PcsImportDocDomainImpl
implements PcsImportDocDomain,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsImportDocDomainImpl.class);
    @Autowired
    private PcsImportDocMapper pcsImportDocMapper;

    @Override
    public PcsImportDoc buildFromVO(PcsImportDocVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsImportDoc record = new PcsImportDoc();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsImportDocVO buildFromModel(PcsImportDoc record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsImportDocVO vo = new PcsImportDocVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsImportDoc record) {
        this.pcsImportDocMapper.insertSelective(record);
        return record.getId();
    }

    @Override
    @Transactional
    public Boolean update(PcsImportDoc record) {
        return this.pcsImportDocMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public PcsImportDoc findById(Long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsImportDocMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsImportDocVO> findByCond(PcsImportDocCond cond) {
        List<PcsImportDocVO> recordList = this.pcsImportDocMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsImportDoc> findByCriteria(PcsImportDocCond cond) {
        List<PcsImportDoc> recordList;
        PcsImportDocExample example = new PcsImportDocExample();
        if (cond.getDocType() != null) {
            example.createCriteria().andDocTypeEqualTo(cond.getDocType());
        }
        if (cond.getIsPostMeeting() != null) {
            example.createCriteria().andIsPostMeetingEqualTo(cond.getIsPostMeeting());
        }
        if (CollectionUtils.isEmpty(recordList = this.pcsImportDocMapper.selectByExample(example))) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsImportDoc> findByIds(List<Long> ids) {
        ArrayList<PcsImportDoc> recordList = new ArrayList<PcsImportDoc>();
        for (long id : ids) {
            PcsImportDoc record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public long countByCond(PcsImportDocCond cond) {
        return this.pcsImportDocMapper.countByCond(cond);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.pcsImportDocMapper.deleteByPrimaryKey(id);
    }

    @Override
    public Long deleteByQualifyId(Long qualifyId) {
        return this.pcsImportDocMapper.deleteByQualifyId(qualifyId);
    }

    @Override
    public List<PcsImportDoc> findByQualifyId(Long qualifyId) {
        List<PcsImportDocVO> list = this.pcsImportDocMapper.findByQualifyId(qualifyId);
        ArrayList<PcsImportDoc> docs = new ArrayList<PcsImportDoc>();
        for (PcsImportDocVO vo : list) {
            docs.add(this.buildFromVO(vo));
        }
        return docs;
    }

    public Boolean check(Object obj) {
        return null;
    }
}

