/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsCopywriterCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProdCopywriterCustomerMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdCopywriterMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsCopywriterMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsCopywriterDomain;
import com.thebeastshop.pegasus.merchandise.enums.CopywriterValidStatusEnum;
import com.thebeastshop.pegasus.merchandise.model.OpProdCopywriter;
import com.thebeastshop.pegasus.merchandise.model.OpProdCopywriterExample;
import com.thebeastshop.pegasus.merchandise.model.PcsCopywriter;
import com.thebeastshop.pegasus.merchandise.model.PcsCopywriterExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.management.OperationsException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pcsCopywriterDomain")
public class PcsCopywriterDomainImpl
implements PcsCopywriterDomain {
    private final Logger log = LoggerFactory.getLogger(PcsCopywriterDomainImpl.class);
    @Autowired
    private PcsCopywriterMapper pcsCopywriterMapper;
    @Autowired
    private OpProdCopywriterMapper opProdCopywriterMapper;
    @Autowired
    private OpProdCopywriterCustomerMapper opProdCopywriterCustomerMapper;
    @Autowired
    private PcsClPsDomain pcsClPsDomain;

    @Override
    public int addCopywriter(PcsCopywriter pcsCopywriter) {
        pcsCopywriter.setActive(1);
        pcsCopywriter.setCreateTime(DateUtil.getNow());
        pcsCopywriter = this.copywriterValidStatus(pcsCopywriter);
        int ret = this.pcsCopywriterMapper.insertSelective(pcsCopywriter);
        if (ret > 0) {
            Random random = new Random();
            int n = random.nextInt(99);
            pcsCopywriter.setCode("C0" + n + pcsCopywriter.getId());
            this.pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
        }
        return ret;
    }

    private PcsCopywriter copywriterValidStatus(PcsCopywriter pcsCopywriter) {
        Date now = DateUtil.getNow();
        if (pcsCopywriter.getValidStartTime().after(now)) {
            pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.PENDING_EFFECT.getStatus());
        } else if (pcsCopywriter.getValidStartTime().before(now) && pcsCopywriter.getValidEndTime().after(now)) {
            pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus());
        } else if (pcsCopywriter.getValidEndTime().before(now)) {
            pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.Expired.getStatus());
        }
        return pcsCopywriter;
    }

    @Override
    public int updateCopywriter(PcsCopywriterVO copywriterVO) {
        PcsCopywriter pcsCopywriter = (PcsCopywriter)BeanUtil.buildFrom((Object)copywriterVO, PcsCopywriter.class);
        int ret = this.pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter = this.copywriterValidStatus(pcsCopywriter));
        if (ret > 0) {
            this.updateCopywriterValidStatus();
            int n = this.opProdCopywriterCustomerMapper.updateProductCopywriterUpdateTimeByCopyId(pcsCopywriter.getId());
        }
        return ret;
    }

    @Override
    public int updateProdCopywriterByCodeList(ProdSkuVO prod, List<String> copywriterCodeList, boolean isEmptyBeforeUpdate) {
        OpProdCopywriter opProdCopywriter;
        HashMap params = new HashMap();
        if (isEmptyBeforeUpdate) {
            OpProdCopywriterExample example = new OpProdCopywriterExample();
            OpProdCopywriterExample.Criteria criteria = example.createCriteria();
            criteria.andProductIdEqualTo(prod.getProdId());
            criteria.andIsDeleteEqualTo(0);
            List<OpProdCopywriter> toDeleteProdCopywriterList = this.opProdCopywriterMapper.selectByExample(example);
            if (!toDeleteProdCopywriterList.isEmpty()) {
                ArrayList<Long> toDelIdList = new ArrayList<Long>();
                for (int i = 0; i < toDeleteProdCopywriterList.size(); ++i) {
                    OpProdCopywriter toDelProdCopywriter = toDeleteProdCopywriterList.get(i);
                    toDelIdList.add(toDelProdCopywriter.getId());
                }
                HashMap<String, Object> delParams = new HashMap<String, Object>();
                delParams.put("ids", toDelIdList);
                delParams.put("active", 0);
                delParams.put("isDelete", 1);
                int count = this.opProdCopywriterCustomerMapper.updateProdCopywriterDeleteByIds(delParams);
                this.log.info("\u5220\u9664\uff1a" + count);
            }
        }
        ArrayList<OpProdCopywriter> opProdCopywriterList = new ArrayList<OpProdCopywriter>();
        for (int i = 0; i < copywriterCodeList.size(); ++i) {
            String code = copywriterCodeList.get(i);
            opProdCopywriter = new OpProdCopywriter();
            opProdCopywriter.setProductCode(prod.getProdCode());
            opProdCopywriter.setProductId(prod.getProdId());
            opProdCopywriter.setCopywriterCode(code);
            PcsCopywriterExample example = new PcsCopywriterExample();
            PcsCopywriterExample.Criteria criteria = example.createCriteria();
            criteria.andCodeEqualTo(code);
            List<PcsCopywriter> pcsCopywriter = this.pcsCopywriterMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(pcsCopywriter)) {
                int validStatus = pcsCopywriter.get(0).getValidStatus();
                if (validStatus == CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus()) {
                    opProdCopywriter.setActive(1);
                } else {
                    opProdCopywriter.setActive(0);
                }
            }
            opProdCopywriterList.add(opProdCopywriter);
        }
        int ret = 0;
        for (int i = 0; i < opProdCopywriterList.size(); ++i) {
            opProdCopywriter = (OpProdCopywriter)opProdCopywriterList.get(i);
            opProdCopywriter.setSort(i);
            try {
                ret = this.saveOrUpdateProdCopywriter(opProdCopywriter);
                continue;
            }
            catch (OperationsException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public int saveOrUpdateProdCopywriter(OpProdCopywriter opProdCopywriter) throws OperationsException {
        int count = this.opProdCopywriterCustomerMapper.countOfProdCopywriter(opProdCopywriter);
        opProdCopywriter.setIsDelete(0);
        if (count == 0) {
            opProdCopywriter.setCreateTime(DateUtil.getNow());
            opProdCopywriter.setUpdateTime(DateUtil.getNow());
            count = this.opProdCopywriterMapper.insertSelective(opProdCopywriter);
            this.log.info("add record ProdCopywriterId:" + opProdCopywriter.getId());
            if (count == 0) {
                throw new OperationsException("\u65b0\u589e\u5931\u8d25!");
            }
            return 1;
        }
        opProdCopywriter.setUpdateTime(DateUtil.getNow());
        count = this.opProdCopywriterCustomerMapper.updateProdCopywriter(opProdCopywriter);
        if (count == 0) {
            throw new OperationsException("\u66f4\u65b0\u5931\u8d25!");
        }
        this.log.info("update record opProdCopywriterId:" + opProdCopywriter.getId());
        return 2;
    }

    @Override
    public PcsCopywriterVO findCopywriterById(Long id) {
        PcsCopywriterExample example = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        criteria.andActiveEqualTo(1);
        List<PcsCopywriter> pcsCopywriters = this.pcsCopywriterMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(pcsCopywriters)) {
            return (PcsCopywriterVO)BeanUtil.buildFrom((Object)pcsCopywriters.get(0), PcsCopywriterVO.class);
        }
        return null;
    }

    @Override
    public List<ProdSkuVO> queryProdCopywriterList(PcsCopywriterCond cond) {
        return this.opProdCopywriterCustomerMapper.queryProdCopywriterList(cond);
    }

    @Override
    public int deleteProdCopywriterByIds(List<String> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", idList);
        params.put("isDelete", 1);
        params.put("active", 0);
        int ret = this.opProdCopywriterCustomerMapper.updateProdCopywriterDeleteByIds(params);
        return ret;
    }

    @Override
    public List<PcsCopywriterVO> queryPcsCopywriterVOListByCond(PcsCopywriterCond cond) {
        this.log.info("queryPcsCopywriterVOListByCond\u67e5\u8be2\u53c2\u6570:{}" + cond.toString());
        List<PcsCopywriterVO> pcsCopywriterVOList = this.opProdCopywriterCustomerMapper.queryPcsCopywriterVOListByCond(cond);
        return pcsCopywriterVOList;
    }

    @Override
    public ProdSkuVO queryProductByProdCode(String prodCode) {
        return this.opProdCopywriterCustomerMapper.queryProductByProdCode(prodCode);
    }

    @Override
    public void updateCopywriterValidStatus() {
        this.updatePENDING_EFFECT();
        this.updateALREADY_IN_FORCE();
        this.updateExpired();
    }

    @Override
    public Map<String, ProductCopywriterVO> selectProductCopywriterByProdCodes(List<String> codes) {
        this.log.info("-----\u901a\u8fc7ProdCodes\u67e5\u8be2 \u53ef\u4ee5\u4f7f\u7528\u7684\u6587\u6848----productCodes{}" + codes);
        this.updateCopywriterValidStatus();
        List<ProductCopywriterVO> productCopywriterVOList = this.opProdCopywriterCustomerMapper.selectProductCopywriterByProdCodes(codes);
        HashMap<String, ProductCopywriterVO> returnMap = new HashMap<String, ProductCopywriterVO>();
        if (CollectionUtils.isNotEmpty(productCopywriterVOList)) {
            for (ProductCopywriterVO productCopywriterVO : productCopywriterVOList) {
                returnMap.put(productCopywriterVO.getProductCode(), productCopywriterVO);
            }
        }
        return returnMap;
    }

    @Override
    public int updateActiveTrueCopywriter() {
        return this.opProdCopywriterCustomerMapper.updateActiveTrueCopywriter();
    }

    @Override
    public int updateActiveFalseCopywriter() {
        return this.opProdCopywriterCustomerMapper.updateActiveFalseCopywriter();
    }

    @Override
    public int updateValidStatusPendingEffect() {
        return this.opProdCopywriterCustomerMapper.updateValidStatusPendingEffect();
    }

    @Override
    public int updateValidStatusAlreadyInForce() {
        return this.opProdCopywriterCustomerMapper.updateValidStatusAlreadyInForce();
    }

    @Override
    public int updateValidStatusExpired() {
        return this.opProdCopywriterCustomerMapper.updateValidStatusExpired();
    }

    private void updatePENDING_EFFECT() {
        PcsCopywriterExample example = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria = example.createCriteria();
        criteria.andValidStartTimeGreaterThan(DateUtil.getNow());
        criteria.andActiveNotEqualTo(0);
        criteria.andValidStatusNotEqualTo(CopywriterValidStatusEnum.PENDING_EFFECT.getStatus());
        PcsCopywriterExample.Criteria criteriaOr = example.createCriteria();
        criteriaOr.andValidStartTimeGreaterThan(DateUtil.getNow());
        criteriaOr.andActiveNotEqualTo(0);
        criteriaOr.andValidStatusIsNull();
        example.or(criteriaOr);
        List<PcsCopywriter> pcsCopywriters = this.pcsCopywriterMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(pcsCopywriters)) {
            for (PcsCopywriter pcsCopywriter : pcsCopywriters) {
                pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.PENDING_EFFECT.getStatus());
                pcsCopywriter.setUpdateTime(DateUtil.getNow());
                int ret = this.pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
                if (ret >= 1) continue;
                this.log.error("\u6587\u6848{}\u66f4\u65b0\u4e3a\u5f85\u751f\u6548\u5931\u8d25" + pcsCopywriter.getId());
            }
        }
    }

    private void updateALREADY_IN_FORCE() {
        PcsCopywriterExample example1 = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria1 = example1.createCriteria();
        criteria1.andValidStartTimeLessThan(DateUtil.getNow());
        criteria1.andValidEndTimeGreaterThan(DateUtil.getNow());
        criteria1.andActiveNotEqualTo(0);
        criteria1.andValidStatusNotEqualTo(CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus());
        PcsCopywriterExample.Criteria criteria11 = example1.createCriteria();
        criteria11.andValidStartTimeLessThan(DateUtil.getNow());
        criteria11.andValidEndTimeGreaterThan(DateUtil.getNow());
        criteria11.andActiveNotEqualTo(0);
        criteria11.andValidStatusIsNull();
        example1.or(criteria11);
        List<PcsCopywriter> pcsCopywriters1 = this.pcsCopywriterMapper.selectByExample(example1);
        if (CollectionUtils.isNotEmpty(pcsCopywriters1)) {
            for (PcsCopywriter pcsCopywriter : pcsCopywriters1) {
                pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus());
                pcsCopywriter.setUpdateTime(DateUtil.getNow());
                int ret = this.pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
                if (ret >= 1) continue;
                this.log.error("\u6587\u6848{}\u66f4\u65b0\u4e3a\u5df2\u751f\u6548\u5931\u8d25" + pcsCopywriter.getId());
            }
        }
    }

    private void updateExpired() {
        PcsCopywriterExample example2 = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria2 = example2.createCriteria();
        criteria2.andValidEndTimeLessThan(DateUtil.getNow());
        criteria2.andActiveNotEqualTo(0);
        criteria2.andValidStatusNotEqualTo(CopywriterValidStatusEnum.Expired.getStatus());
        PcsCopywriterExample.Criteria criteria22 = example2.createCriteria();
        criteria22.andValidEndTimeLessThan(DateUtil.getNow());
        criteria22.andActiveNotEqualTo(0);
        criteria22.andValidStatusIsNull();
        example2.or(criteria22);
        List<PcsCopywriter> pcsCopywriters2 = this.pcsCopywriterMapper.selectByExample(example2);
        if (CollectionUtils.isNotEmpty(pcsCopywriters2)) {
            for (PcsCopywriter pcsCopywriter : pcsCopywriters2) {
                pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.Expired.getStatus());
                pcsCopywriter.setUpdateTime(DateUtil.getNow());
                int ret = this.pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
                if (ret >= 1) continue;
                this.log.error("\u6587\u6848{}\u66f4\u65b0\u4e3a\u5df2\u5931\u6548\u5931\u8d25" + pcsCopywriter.getId());
            }
        }
    }
}

