/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.merchandise.cond.OpSpvCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCombinationCond;
import com.thebeastshop.pegasus.merchandise.constants.ProductConstants;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpSpvAttributeValueDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpSpvPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCombinationDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.model.OpProdSku;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuExample;
import com.thebeastshop.pegasus.merchandise.model.OpSpvAttributeValue;
import com.thebeastshop.pegasus.merchandise.model.OpSpvPriceChange;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCombination;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeVO;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opProdSkuDomain")
public class OpProdSkuDomainImpl
extends AbstractBaseDomain<OpSpvVO, OpProdSku>
implements OpProdSkuDomain {
    @Autowired
    private OpProdSkuMapper opProdSkuMapper;
    @Autowired
    private PcsSkuDomain pcsSkuDomain;
    @Autowired
    private PcsSkuCombinationDomain pcsSkuCombinationDomain;
    @Autowired
    private OpSpvAttributeValueDomain opSpvAttributeValueDomain;
    @Autowired
    private OpSpvPriceChangeDomain opSpvPriceChangeDomain;

    @Override
    public boolean create(OpProdSku prodSku) {
        if (prodSku.getMinAmount() == null) {
            prodSku.setMinAmount(1);
        }
        this.validateProdSku(prodSku.getProductId(), prodSku.getSkuCode());
        return this.opProdSkuMapper.insert(prodSku) != 0;
    }

    @Override
    public boolean createCombinedSpv(Map<String, OpAttributeVO> attrIdMap, OpSpvVO spvVO, Integer prodStatus) {
        spvVO.setCombined(Boolean.valueOf(true));
        OpProdSku spv = (OpProdSku)this.buildFromVO(spvVO);
        spv.setActive(true);
        int id = this.opProdSkuMapper.insert(spv);
        if (id == 0) {
            return false;
        }
        if (prodStatus == ProductConstants.PROD_WAIT_STATUS) {
            OpSpvPriceChange spvPriceChange = new OpSpvPriceChange();
            spvPriceChange.setIsCurrent(1);
            spvPriceChange.setSpvId(spv.getId());
            spvPriceChange.setSalesPrice(spvVO.getSalesPrice());
            spvPriceChange.setChangeStatus(ProductConstants.SPV_PRICE_CHANGE_STATUS);
            spvPriceChange.setCreateTime(new Date());
            spvPriceChange.setUpdateTime(new Date());
            this.opSpvPriceChangeDomain.create(spvPriceChange);
        }
        List skuCombinationList = spvVO.getSkuCombinationList();
        String attrJsonText = spvVO.getAttrJSONText();
        ArrayList spvAttrsJson = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)attrJsonText) && MapUtils.isNotEmpty(attrIdMap)) {
            OpAttributeValueVO attrValueVO;
            OpAttributeVO attrVO;
            JSONArray attrMapList = JSON.parseArray((String)attrJsonText);
            for (int i = 0; i < attrMapList.size(); ++i) {
                JSONObject attrMap = attrMapList.getJSONObject(i);
                String attrName = attrMap.getString("attrName");
                String attrValueText = attrMap.getString("attrValue");
                attrVO = attrIdMap.get(attrName);
                if (attrVO == null || (attrValueVO = (OpAttributeValueVO)attrVO.getAttributeValueMap().get(attrValueText)) == null) continue;
                ArrayList<Long> attrJson = new ArrayList<Long>();
                attrJson.add(attrVO.getId());
                attrJson.add(attrValueVO.getId());
                spvAttrsJson.add(attrJson);
            }
            OpSpvAttributeValue spvAttributeValue = new OpSpvAttributeValue();
            String attrsJsonText = JSON.toJSONString(spvAttrsJson);
            spvAttributeValue.setAttrs(attrsJsonText);
            this.opSpvAttributeValueDomain.createOrUpdateBySpvId(spv.getId(), spvAttributeValue);
            if (CollectionUtils.isNotEmpty((Collection)skuCombinationList)) {
                for (PcsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                    skuCombinationVO.setSpvId(spv.getId());
                    attrVO = attrIdMap.get(skuCombinationVO.getAttrName());
                    attrValueVO = (OpAttributeValueVO)attrVO.getAttributeValueMap().get(skuCombinationVO.getAttrValue());
                    PcsSkuCombination skuCombination = (PcsSkuCombination)this.pcsSkuCombinationDomain.buildFromVO(skuCombinationVO);
                    skuCombination.setGroupName(attrVO.getGroupName());
                    String attrs = JSONArray.toJSONString(Arrays.asList(Arrays.asList(attrVO.getId(), attrValueVO.getId())));
                    skuCombination.setAttrs(attrs);
                    this.pcsSkuCombinationDomain.create(skuCombination);
                }
            }
        }
        return true;
    }

    @Override
    public boolean updateCombinedSpv(OpSpvVO spvVO, int temProdStatus, int prodStatus) {
        List skuCombinationList;
        Long spvId = spvVO.getId();
        if (!(temProdStatus == ProductConstants.PROD_DRAFT_STATUS && prodStatus == ProductConstants.PROD_DRAFT_STATUS || temProdStatus == ProductConstants.PROD_NOPASS_STATUS && prodStatus == ProductConstants.PROD_DRAFT_STATUS)) {
            OpSpvPriceChange spvPriceChange;
            HashMap<String, Object> map;
            BigDecimal salesPrice;
            OpSpvPriceChange obj;
            if (temProdStatus == ProductConstants.PROD_PASS_STATUS) {
                obj = this.opSpvPriceChangeDomain.getCurrentAduitPrice(spvId);
                salesPrice = obj.getSalesPrice();
                map = new HashMap<String, Object>();
                map.put("spvId", spvId);
                this.opSpvPriceChangeDomain.updateBySpvId(map);
                spvPriceChange = new OpSpvPriceChange();
                spvPriceChange.setIsCurrent(1);
                spvPriceChange.setSpvId(spvId);
                spvPriceChange.setSalesPrice(spvVO.getSalesPrice());
                spvPriceChange.setLastSalesPrice(salesPrice);
                spvPriceChange.setChangeStatus(ProductConstants.SPV_PRICE_CHANGE_STATUS);
                spvPriceChange.setCreateTime(new Date());
                spvPriceChange.setUpdateTime(new Date());
                this.opSpvPriceChangeDomain.create(spvPriceChange);
            } else if (temProdStatus == ProductConstants.PROD_NOPASS_STATUS && prodStatus == ProductConstants.PROD_WAIT_STATUS) {
                obj = this.opSpvPriceChangeDomain.getCurrentAduitPrice(spvId);
                salesPrice = obj.getSalesPrice();
                map = new HashMap();
                map.put("spvId", spvId);
                this.opSpvPriceChangeDomain.updateBySpvId(map);
                spvPriceChange = new OpSpvPriceChange();
                spvPriceChange.setIsCurrent(1);
                spvPriceChange.setSpvId(spvId);
                spvPriceChange.setSalesPrice(spvVO.getSalesPrice());
                spvPriceChange.setLastSalesPrice(salesPrice);
                spvPriceChange.setChangeStatus(ProductConstants.SPV_PRICE_NOPASS_STATUS);
                spvPriceChange.setCreateTime(new Date());
                spvPriceChange.setUpdateTime(new Date());
                this.opSpvPriceChangeDomain.create(spvPriceChange);
            } else {
                OpSpvPriceChange spvPriceChange2 = new OpSpvPriceChange();
                spvPriceChange2.setIsCurrent(1);
                spvPriceChange2.setSpvId(spvId);
                spvPriceChange2.setSalesPrice(spvVO.getSalesPrice());
                spvPriceChange2.setChangeStatus(ProductConstants.SPV_PRICE_CHANGE_STATUS);
                spvPriceChange2.setCreateTime(new Date());
                spvPriceChange2.setUpdateTime(new Date());
                this.opSpvPriceChangeDomain.create(spvPriceChange2);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(skuCombinationList = spvVO.getSkuCombinationList()))) {
            for (PcsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                List<PcsSkuCombination> list = this.pcsSkuCombinationDomain.findBySpvIdAndCode(spvVO.getId(), skuCombinationVO.getSubSkuCode());
                PcsSkuCombination skuCombination = list.get(0);
                skuCombination.setQuantity(skuCombinationVO.getQuantity());
                boolean flag2 = this.pcsSkuCombinationDomain.update(skuCombination);
                if (flag2) continue;
                return flag2;
            }
        }
        return true;
    }

    @Override
    public boolean update(OpProdSku prodSku) {
        return this.opProdSkuMapper.updateByPrimaryKeySelective(prodSku) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return this.opProdSkuMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public List<OpProdSku> findByProdId(Long prodId) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        example.setOrderByClause("SKU_CODE");
        return this.opProdSkuMapper.selectByExample(example);
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        return this.opProdSkuMapper.deleteByExample(example) != 0;
    }

    @Override
    public List<OpProdSku> findByProdIds(List<Long> prodIds) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdIn((List)prodIds);
        return this.opProdSkuMapper.selectByExample(example);
    }

    @Override
    public List<OpProdSku> findBySkuCode(String skuCode) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        return this.opProdSkuMapper.selectByExample(example);
    }

    @Override
    public Integer getProductIdByskuCode(String skuCode) {
        return this.opProdSkuMapper.getProductIdByskuCode(skuCode);
    }

    @Override
    public List<OpProdSku> findAll() {
        OpProdSkuExample example = new OpProdSkuExample();
        example.setOrderByClause("SKU_CODE");
        return this.opProdSkuMapper.selectByExample(example);
    }

    @Override
    public List<String> getALLSkuCode() {
        return this.opProdSkuMapper.getALLSkuCode();
    }

    @Override
    public List<OpSpvVO> findByPcsProdSkuCond(OpSpvCond opSpvCond) {
        List<OpSpvVO> list = this.opProdSkuMapper.findByPcsProdSkuCond(opSpvCond);
        if (opSpvCond.isWithSku().booleanValue()) {
            for (OpSpvVO spvVO : list) {
                if (!spvVO.getCombined().booleanValue() && StringUtils.isNotEmpty((CharSequence)spvVO.getSkuCode())) {
                    PcsSkuVO skuVO = this.pcsSkuDomain.findByCode(spvVO.getSkuCode());
                    spvVO.setSkuVO(skuVO);
                    continue;
                }
                if (!spvVO.getCombined().booleanValue()) continue;
                List<PcsSkuCombination> combinationList = this.pcsSkuCombinationDomain.findBySpvId(spvVO.getId());
                spvVO.setSkuCombinationList(this.pcsSkuCombinationDomain.buildFromModelList(combinationList));
            }
        }
        if (opSpvCond.getWithSkuCombination().booleanValue()) {
            for (OpSpvVO prodSkuVO : list) {
                if (!prodSkuVO.getCombined().booleanValue()) continue;
                PcsSkuCombinationCond pcsSkucombinationCond = new PcsSkuCombinationCond();
                pcsSkucombinationCond.setSpvId(prodSkuVO.getId());
                pcsSkucombinationCond.setWithAttribute(Boolean.valueOf(true));
                pcsSkucombinationCond.setWithAttributeValue(Boolean.valueOf(true));
                pcsSkucombinationCond.setWithSku(Boolean.valueOf(true));
                prodSkuVO.setSkuCombinationList(this.pcsSkuCombinationDomain.findSkuCombinationBySpvId(pcsSkucombinationCond));
            }
        }
        return list;
    }

    private void validateProdSku(Long prodId, String skuCode) {
        OpProdSkuExample example = new OpProdSkuExample();
        OpProdSkuExample.Criteria criteria = example.createCriteria();
        criteria.andSkuCodeEqualTo(skuCode);
        criteria.andProductIdEqualTo(prodId);
        List<OpProdSku> skus = this.opProdSkuMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(skus)) {
            throw new OperationException("OP1003", "sku:" + skuCode + ",\u5df2\u7ecf\u5728\u5176\u5b83PROD\u4e2d\u5b58\u5728\uff01");
        }
    }

    @Override
    public List<OpSpvVO> findSpvCombinedByProdId(Long prodId) {
        OpProdSkuExample example = new OpProdSkuExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        List<OpProdSku> list = this.opProdSkuMapper.selectByExample(example);
        List spvList = BeanUtil.buildListFrom(list, OpSpvVO.class);
        for (OpSpvVO prodSkuVO : spvList) {
            if (!prodSkuVO.getCombined().booleanValue()) continue;
            prodSkuVO.setSkuCombinationList(this.pcsSkuCombinationDomain.findSkuCombinationBySpvId(prodSkuVO.getId()));
        }
        return spvList;
    }

    @Override
    public Boolean getSpvById(Long id) {
        return this.opProdSkuMapper.selectByPrimaryKey(id) != null;
    }

    @Override
    public List<OpProdSku> findByProdCode(String prodCode) {
        return this.opProdSkuMapper.findByProdCode(prodCode);
    }
}

