/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpProdDynmContMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdDynmContDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.model.OpProdDynmCont;
import com.thebeastshop.pegasus.merchandise.model.OpProdDynmContExample;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmContVO;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opProdDynmContDomain")
public class OpProdDynmContDomainImpl
extends AbstractBaseDomain<OpProdDynmContVO, OpProdDynmCont>
implements OpProdDynmContDomain {
    @Autowired
    private OpProdDynmContMapper opProdDynmContMapper;

    @Override
    public boolean create(OpProdDynmContVO vo) {
        OpProdDynmCont cont = (OpProdDynmCont)this.buildFromVO(vo);
        this.opProdDynmContMapper.insert(cont);
        vo.setId(cont.getId());
        return cont.getId() > 0L;
    }

    @Override
    public boolean update(OpProdDynmContVO vo) {
        return this.opProdDynmContMapper.updateByPrimaryKeySelective((OpProdDynmCont)this.buildFromVO(vo)) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return this.opProdDynmContMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public List<OpProdDynmContVO> findByProdId(Long prodId) {
        OpProdDynmContExample example = new OpProdDynmContExample();
        OpProdDynmContExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        example.setOrderByClause("SORT");
        List<OpProdDynmCont> contents = this.opProdDynmContMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isEmpty(contents)) {
            return Collections.emptyList();
        }
        ArrayList<OpProdDynmContVO> vos = new ArrayList<OpProdDynmContVO>(contents.size());
        for (OpProdDynmCont content : contents) {
            vos.add((OpProdDynmContVO)this.buildFromModel(content));
        }
        return vos;
    }

    @Override
    public boolean createOrUpdate(List<OpProdDynmContVO> vos) {
        try {
            for (OpProdDynmContVO vo : vos) {
                if (NumberUtil.isNullOrZero((Number)vo.getId())) {
                    this.create(vo);
                    continue;
                }
                this.update(vo);
            }
            return true;
        }
        catch (RuntimeException e) {
            throw new OperationException("OP2001", "\u4fdd\u5b58\u52a8\u6001\u5185\u5bb9\u5931\u8d25\uff01");
        }
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        OpProdDynmContExample example = new OpProdDynmContExample();
        OpProdDynmContExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        return this.opProdDynmContMapper.deleteByExample(example) != 0;
    }

    @Override
    public int updateContentByProdIdAndType(String content, String prodId, String type) {
        return this.opProdDynmContMapper.updateContentByProdIdAndType(content, prodId, type);
    }
}

