/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.domain.BaseDomain;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractBaseDomain<VO, MO>
implements BaseDomain<VO, MO> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<VO> voClass = this.getGenericClazz(0);
    private final Class<MO> moClass = this.getGenericClazz(1);

    private <T> Class<T> getGenericClazz(int index) {
        Type superClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)superClass).getActualTypeArguments()[index];
        if (type instanceof TypeVariable) {
            return (Class)((TypeVariable)type).getBounds()[0];
        }
        return (Class)type;
    }

    protected VO buildFromModel(MO record, Class<VO> voClass) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        VO vo = null;
        try {
            vo = voClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (vo == null) {
            return null;
        }
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    protected MO buildFromVO(VO vo, Class<MO> moClass) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        MO record = null;
        try {
            record = moClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (record == null) {
            return null;
        }
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public VO buildFromModel(MO record) {
        return this.buildFromModel(record, this.voClass);
    }

    @Override
    public MO buildFromVO(VO vo) {
        return this.buildFromVO(vo, this.moClass);
    }

    @Override
    public List<MO> buildFromVOList(List<VO> voList) {
        ArrayList<MO> results = new ArrayList<MO>();
        for (VO vo : voList) {
            results.add(this.buildFromVO(vo));
        }
        return results;
    }

    @Override
    public List<VO> buildFromModelList(List<MO> moList) {
        ArrayList<VO> results = new ArrayList<VO>();
        for (MO mo : moList) {
            results.add(this.buildFromModel(mo));
        }
        return results;
    }
}

