/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.merchandise.client.SpvESClient;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsSpvCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.domain.CampaignDomain;
import com.thebeastshop.pegasus.merchandise.domain.PsSkuDomain;
import com.thebeastshop.pegasus.merchandise.service.McOpSpvService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcPsSpvService")
public class McPsSpvServiceImpl
implements McPsSpvService {
    @Autowired
    private SpvESClient client;
    @Autowired
    private PsSkuDomain psSkuDomain;
    @Autowired
    private CampaignDomain campaignDomain;
    @Autowired
    private McPsProductService mcPsProductService;
    @Autowired
    private McOpSpvService mcOpSpvService;

    private List<PsSpvVO> fillingData(List<PsSpvVO> spvs) {
        if (CollectionUtils.isNotEmpty(spvs)) {
            ArrayList skuCodes = Lists.newArrayList();
            ArrayList productCodes = Lists.newArrayList();
            for (PsSpvVO spvVO : spvs) {
                if (spvVO.getCombined() != null && spvVO.getCombined().booleanValue()) continue;
                skuCodes.add(spvVO.getSkuCode());
                productCodes.add(spvVO.getProductCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)productCodes) && CollectionUtils.isNotEmpty((Collection)skuCodes)) {
                Map<String, PsSkuVO> mapBySkuCodes = this.psSkuDomain.mapBySkuCodes(skuCodes);
                Map mapByProdCodes = this.mcPsProductService.mapByProdCodes((List)productCodes);
                Iterator<PsSpvVO> iterator = spvs.iterator();
                while (iterator.hasNext()) {
                    PsSpvVO spvVO = iterator.next();
                    if (spvVO == null || spvVO.getCombined() != null && spvVO.getCombined().booleanValue()) continue;
                    PsSkuVO sku = mapBySkuCodes.get(spvVO.getSkuCode());
                    PsProductVO product = (PsProductVO)mapByProdCodes.get(spvVO.getProductCode());
                    if (sku != null && product != null) {
                        spvVO.setSalesPrice(BigDecimal.valueOf(sku.getSalesPrice()));
                        if (!StringUtils.isNotBlank((CharSequence)product.getSkuCategoryDesc()) || !StringUtils.isNotBlank((CharSequence)sku.getSkuCateName())) continue;
                        PsAttributeValuePairVO e = new PsAttributeValuePairVO();
                        e.setAttrName(product.getSkuCategoryDesc());
                        e.setValue(sku.getSkuCateName());
                        spvVO.setAttributeValuePairList((List)Lists.newArrayList((Object[])new PsAttributeValuePairVO[]{e}));
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
        return spvs;
    }

    public List<PsSpvVO> findByProdId(Long prodId) {
        return this.fillingData(this.client.findByField("productId", prodId));
    }

    public PsSpvVO findSpvBySkuCode(String prodCode, String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("prodCode", QueryBuilders.queryStringQuery((String)prodCode).field("prodCode"));
        params.put("skuCode", QueryBuilders.queryStringQuery((String)skuCode).field("skuCode"));
        List<PsSpvVO> spvList = this.fillingData(this.client.findByFields(params, SearchType.AND));
        if (CollectionUtils.isEmpty(spvList)) {
            return null;
        }
        for (PsSpvVO spv : spvList) {
            Boolean flag = this.mcOpSpvService.getSpvById(spv.getSpvId());
            if (!flag.booleanValue()) continue;
            return spv;
        }
        return spvList.get(0);
    }

    public List<PsSpvVO> findWithSkuByProdId(Long prodId) {
        List<PsSpvVO> spvList = this.findByProdId(prodId);
        if (CollectionUtils.isNotEmpty(spvList)) {
            ArrayList<String> skuCodes = new ArrayList<String>();
            HashMap<String, PsSkuCombinationVO> skuCombinationVOMap = new HashMap<String, PsSkuCombinationVO>();
            HashMap<String, PsSpvVO> spvVOMap = new HashMap<String, PsSpvVO>();
            for (PsSpvVO spvVO : spvList) {
                if (spvVO.getCombined() != null && spvVO.getCombined().booleanValue()) {
                    List skuCombinationList = spvVO.getSkuCombinationList();
                    if (!CollectionUtils.isNotEmpty((Collection)skuCombinationList)) continue;
                    for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                        skuCodes.add(skuCombinationVO.getSubSkuCode());
                        skuCombinationVOMap.put(skuCombinationVO.getSubSkuCode(), skuCombinationVO);
                    }
                    continue;
                }
                skuCodes.add(spvVO.getSkuCode());
                spvVOMap.put(spvVO.getSkuCode(), spvVO);
            }
            List<PsSkuVO> skuVOs = this.psSkuDomain.findBySkuCodes(skuCodes);
            if (CollectionUtils.isNotEmpty(skuVOs)) {
                for (PsSkuVO skuVO : skuVOs) {
                    PsSkuCombinationVO skuCombinationVO;
                    PsSpvVO spvVO = (PsSpvVO)spvVOMap.get(skuVO.getSkuCode());
                    if (spvVO != null) {
                        spvVO.setSkuVO(skuVO);
                        continue;
                    }
                    skuCombinationVO = (PsSkuCombinationVO)skuCombinationVOMap.get(skuVO.getSkuCode());
                    if (skuCombinationVO == null) continue;
                    skuCombinationVO.setSubSkuVO(skuVO);
                }
            }
        }
        return this.fillingData(spvList);
    }

    public PsSpvVO findBySpvId(Long spvId) {
        List<PsSpvVO> list = this.fillingData(this.client.findByField(this.client.getPrimaryKeyName(), spvId));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public PsSpvVO findWithSkuBySpvId(Long spvId) {
        PsSpvVO spvVO = this.findBySpvId(spvId);
        if (spvId == null) {
            return null;
        }
        if (spvVO.getCombined() != null && spvVO.getCombined().booleanValue()) {
            List<PsSkuVO> skuVOs;
            ArrayList<String> skuCodes = new ArrayList<String>();
            List skuCombinationList = spvVO.getSkuCombinationList();
            HashMap<String, PsSkuCombinationVO> skuCombinationVOMap = new HashMap<String, PsSkuCombinationVO>();
            if (CollectionUtils.isNotEmpty((Collection)skuCombinationList)) {
                for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                    skuCodes.add(skuCombinationVO.getSubSkuCode());
                    skuCombinationVOMap.put(skuCombinationVO.getSubSkuCode(), skuCombinationVO);
                }
            }
            if ((skuVOs = this.psSkuDomain.findBySkuCodes(skuCodes)) != null) {
                for (PsSkuVO skuVO : skuVOs) {
                    PsSkuCombinationVO skuCombinationVO = (PsSkuCombinationVO)skuCombinationVOMap.get(skuVO.getSkuCode());
                    if (skuCombinationVO == null) continue;
                    skuCombinationVO.setSubSkuVO(skuVO);
                }
            }
        } else {
            PsSkuVO skuVO = this.psSkuDomain.findBySkuCode(spvVO.getSkuCode());
            spvVO.setSkuVO(skuVO);
        }
        return spvVO;
    }

    public List<PsSpvVO> findBySpvIds(List<Long> spvIds) {
        if (CollectionUtils.isNotEmpty(spvIds)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(this.client.getPrimaryKeyName(), spvIds);
            params.put("pagenum", 9999);
            return this.fillingData(this.client.findByFields(params, SearchType.OR));
        }
        return null;
    }

    public Map<Long, PsSpvVO> mapBySpvIds(List<Long> spvIds) {
        if (CollectionUtils.isNotEmpty(spvIds)) {
            HashMap rt = Maps.newHashMapWithExpectedSize((int)spvIds.size());
            List<PsSpvVO> spvs = this.findBySpvIds(spvIds);
            for (PsSpvVO spv : spvs) {
                rt.put(spv.getSpvId(), spv);
            }
            return rt;
        }
        return null;
    }

    public List<PsSpvVO> findByCond(PsSpvCond cond) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        return this.fillingData(this.client.findByFields(params, SearchType.ANDLIKE));
    }

    public List<PsSpvVO> findBySpvIds(List<Long> spvIds, PsMatchCampaignCond cond) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(spvIds)) {
            return result;
        }
        List<PsSpvVO> spvList = this.findBySpvIds(spvIds);
        if (CollectionUtils.isEmpty(spvList)) {
            return result;
        }
        for (PsSpvVO spvVO : spvList) {
            PsProductVO productVO = this.mcPsProductService.findProdBySpvId(spvVO.getSpvId());
            if (productVO == null) continue;
            this.campaignDomain.matchCampaigns(productVO, cond);
            this.campaignDomain.matchCampaigns(spvVO, cond, productVO.getCrossBorderFlag());
            ArrayList results = Lists.newArrayList();
            this.mcPsProductService.calculateDiscountPrice(productVO, spvVO, cond, (List)results);
            result.add(spvVO);
        }
        return result;
    }
}

