/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.redis.RedisClient;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.ProductClient;
import com.thebeastshop.pegasus.merchandise.cond.DateRange;
import com.thebeastshop.pegasus.merchandise.cond.OpLabelCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryCond;
import com.thebeastshop.pegasus.merchandise.cond.ProdSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsCampaignSearchCond;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCategoryMapper;
import com.thebeastshop.pegasus.merchandise.domain.CampaignDomain;
import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.price.PriceCalculators;
import com.thebeastshop.pegasus.merchandise.service.McOpLabelService;
import com.thebeastshop.pegasus.merchandise.service.McOpProductService;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.service.impl.BasePsServiceImpl;
import com.thebeastshop.pegasus.merchandise.util.McReflectionUtil;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryBrandLabelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAdvanceCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
import com.thebeastshop.pegasus.merchandise.vo.PsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsChnProdSaleSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.scm.es.DiscountTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/pub/product")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPsProductService")
public class McPsProductServiceImpl
extends BasePsServiceImpl<PsProductVO>
implements McPsProductService {
    private static final Logger LOGGER = LoggerFactory.getLogger(McPsProductServiceImpl.class);
    @Autowired
    private CampaignDomain campaignDomain;
    @Autowired
    private ProductClient client;
    @Autowired
    private McPcsSkuCategoryService mcPcsSkuCategoryService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private McPsSkuService mcPsSkuService;
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McOpProductService mcOpProductService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private PcsSkuCategoryMapper pcsSkuCategoryMapper;
    @Autowired
    private McOpLabelService mcOpLabelService;
    @Autowired
    private McPcsBrandService mcPcsBrandService;
    private static Map<String, Boolean> specialExcludeCampaignMap = new HashMap<String, Boolean>();
    private static List<String> flowerMonthDeliveryProductCodeList = Lists.newArrayList();
    private static String CHN2018 = "CHN2018";
    private static String CHN2049 = "CHN2049";
    private static BigDecimal SPECIAL_DISCOUNT = new BigDecimal("0.88");
    private static double NORMAL_DISCOUNT = 0.9;
    private static final String APP_CHANNEL_CODE = "CHN2049";
    private static Map<Integer, PsCampaignVO> appFirstGiftMap = new HashMap<Integer, PsCampaignVO>();

    @Override
    public AbstractESClient<PsProductVO> getESClient() {
        return this.client;
    }

    @GET
    @Path(value="name/{name}")
    public List<PsProductVO> findByProdName(@PathParam(value="name") String name) {
        return this.client.findByField("name", name);
    }

    @GET
    @Path(value="code/{code}")
    public List<PsProductVO> findByProdCode(@PathParam(value="code") String code) {
        return this.client.findByField("code", code);
    }

    public PsProductVO findByProdId(Long prodId) {
        PsProductCond cond = new PsProductCond();
        cond.setId(prodId.toString());
        List<PsProductVO> prods = this.findByCond(cond);
        if (CollectionUtils.isNotEmpty(prods)) {
            return prods.get(0);
        }
        return null;
    }

    public List<PsProductVO> findByCond(PsProductCond cond) {
        String primaryUpdateTime;
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");
        params.remove("bdDiscount");
        params.remove("memberCode");
        if (CollectionUtils.isNotEmpty((Collection)cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");
        params.remove("firstBuy");
        params.remove("channelCodes");
        List ids = (List)params.get("ids");
        Long id = MapUtils.getLong((Map)params, (Object)"id");
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            params.put("ids", QueryBuilders.termsQuery((String)"id", (Object[])ids.toArray()));
        } else if (id != null) {
            params.put("id", QueryBuilders.termQuery((String)"id", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)cond.getChannelCodes())) {
            params.put("chnCode", cond.getChannelCodes());
        }
        if ((primaryUpdateTime = MapUtils.getString((Map)params, (Object)"primaryUpdateTime")) != null) {
            params.remove("primaryUpdateTime");
        }
        if (cond.getMatchCampaign().booleanValue() && CollectionUtils.isEmpty((Collection)cond.getCodes()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cond.getCode()) && CollectionUtils.isEmpty((Collection)cond.getIds()) && cond.getId() == null) {
            return new ArrayList<PsProductVO>();
        }
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign().booleanValue()) {
            this.campaignDomain.matchListPageCampaigns(productVOList, (PsMatchCampaignCond)cond);
        }
        return productVOList;
    }

    public List<PsProductVO> findByCond(PsProductCond cond, boolean matchGlobalCampaigns) {
        Map params = McReflectionUtil.getFieldNameValue((Object)cond);
        params.remove("memberLevel");
        params.remove("accessWay");
        params.remove("discount");
        params.remove("bdDiscount");
        if (CollectionUtils.isNotEmpty((Collection)cond.getCodes())) {
            params.put("code", cond.getCodes());
        }
        params.remove("codes");
        params.remove("matchCampaign");
        params.remove("matchGlobalCampaigns");
        params.remove("firstBuy");
        params.remove("channelCodes");
        List ids = (List)params.get("ids");
        Long id = MapUtils.getLong((Map)params, (Object)"id");
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            params.put("ids", QueryBuilders.termsQuery((String)"id", (Object[])ids.toArray()));
        } else if (id != null) {
            params.put("id", QueryBuilders.termQuery((String)"id", (Object)id));
        }
        List channelCodes = cond.getChannelCodes();
        if (CollectionUtils.isNotEmpty((Collection)channelCodes)) {
            params.put("chnCode", channelCodes);
        }
        if (cond.getMatchCampaign().booleanValue() && CollectionUtils.isEmpty((Collection)cond.getCodes()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cond.getCode()) && CollectionUtils.isEmpty((Collection)cond.getIds()) && cond.getId() == null) {
            return new ArrayList<PsProductVO>();
        }
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (cond.getMatchCampaign().booleanValue()) {
            this.campaignDomain.matchListPageCampaigns(productVOList, (PsMatchCampaignCond)cond);
        }
        Boolean isFirstBuy = cond.getFirstBuy();
        Boolean isApp = false;
        Integer accessWay = cond.getAccessWay();
        if (accessWay != null && accessWay.equals(2)) {
            isApp = true;
        }
        if (CollectionUtils.isNotEmpty(productVOList) && isFirstBuy.booleanValue() && isApp.booleanValue()) {
            Integer memberLevel = cond.getMemberLevel();
            if (memberLevel != null && memberLevel >= -1 && memberLevel <= 3) {
                Integer key = this.getAppFirstGiftKey(memberLevel);
                PsCampaignVO appFirstGiftCampaign = appFirstGiftMap.get(key);
                if (appFirstGiftCampaign != null) {
                    PsProductVO psProductVO = productVOList.get(0);
                    List campaignList = psProductVO.getCampaignList();
                    if (campaignList == null) {
                        campaignList = Lists.newArrayList();
                    }
                    campaignList.add(appFirstGiftCampaign);
                }
            } else {
                LOGGER.info("\u4f1a\u5458\u7b49\u7ea7{}\u4e0d\u5408\u6cd5,\u4e0d\u6dfb\u52a0APP\u9996\u5355\u8d60\u6d3b\u52a8", (Object)memberLevel);
            }
        }
        return productVOList;
    }

    private static Map<String, Boolean> getSpecialCampaignMap(List<PsCampaignVO> specialCampaigns) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (PsCampaignVO specialCampaign : specialCampaigns) {
            String key = McPsProductServiceImpl.getSpecialCampaignKey(specialCampaign);
            map.put(key, true);
        }
        return map;
    }

    private static String getSpecialCampaignKey(PsCampaignVO specialCampaign) {
        String key = "sid=" + specialCampaign.getProductScopeId();
        key = key + ",tid=" + specialCampaign.getDiscountTypeId();
        return key;
    }

    private void excludeSpecialCampaigns(PsProductVO psProductVO) {
        ArrayList<PsCampaignVO> newCampaignList = new ArrayList<PsCampaignVO>();
        List campaigns = psProductVO.getCampaignList();
        if (CollectionUtils.isNotEmpty((Collection)campaigns)) {
            for (PsCampaignVO campaignVO : campaigns) {
                String key = McPsProductServiceImpl.getSpecialCampaignKey(campaignVO);
                if (specialExcludeCampaignMap.containsKey(key)) continue;
                newCampaignList.add(campaignVO);
            }
        }
        psProductVO.setCampaignList(newCampaignList);
    }

    public Map<String, List<PsCampaignVO>> findCampaignByCond(PsProductCond cond) {
        List<PsProductVO> productList = this.findByCond(cond);
        if (EmptyUtil.isEmpty(productList)) {
            return new HashMap<String, List<PsCampaignVO>>();
        }
        HashMap<String, List<PsCampaignVO>> map = new HashMap<String, List<PsCampaignVO>>();
        for (PsProductVO productVO : productList) {
            List prodList = productVO.getCampaignList();
            map.put(productVO.getCode(), prodList);
        }
        return map;
    }

    public List<PsCampaignVO> getGlobalCampaignList(PsMatchCampaignCond cond) {
        return this.campaignDomain.getGlobalCampaignList(cond);
    }

    public List<PsProductVO> findByFields(Map<String, Object> params) {
        return this.client.findByFields(params, SearchType.ANDLIKE);
    }

    public List<PsProductVO> findByNameOrNameCN(Map<String, Object> params) {
        return this.client.findByFields(params, SearchType.ORLIKE);
    }

    public List<PsProductVO> calculateDiscountPrice(List<PsProductVO> productList, BigDecimal discountAmount, PsMatchCampaignCond cond) {
        if (CollectionUtils.isNotEmpty(productList)) {
            for (PsProductVO productVO : productList) {
                this.calculateDiscountPrice(productVO, discountAmount, cond);
            }
        }
        return productList;
    }

    public PsProductVO calculateDiscountPrice(PsProductVO psProductVO, BigDecimal discountAmount, PsMatchCampaignCond cond) {
        if (psProductVO == null) {
            return psProductVO;
        }
        discountAmount = this.specialDiscount(psProductVO, cond, discountAmount);
        ArrayList allCampaignList = Lists.newArrayList();
        ArrayList productAdvanceCampaignList = Lists.newArrayList();
        ArrayList allAdvanceCampaignList = Lists.newArrayList();
        BigDecimal originalPrice = psProductVO.getListPrice();
        Boolean allowVipDiscount = psProductVO.getAllowVipDiscount() != null && psProductVO.getAllowVipDiscount() == 1;
        Boolean allowBdDiscount = psProductVO.getAllowBdDiscount() == null || psProductVO.getAllowBdDiscount() == 1;
        Boolean matchCampaign = cond.getMatchCampaign();
        if (matchCampaign != null && matchCampaign.booleanValue()) {
            BigDecimal advancePrice;
            PsAdvanceCampaignVO psAdvanceCampaignVO;
            List campaignList = psProductVO.getCampaignList();
            if (CollectionUtils.isNotEmpty((Collection)campaignList)) {
                allCampaignList.addAll(campaignList);
            }
            if ((psAdvanceCampaignVO = psProductVO.getPsAdvanceCampaignVO()) != null && CollectionUtils.isNotEmpty((Collection)psAdvanceCampaignVO.getAdvanceCampaignList())) {
                List advanceCampaignList = psAdvanceCampaignVO.getAdvanceCampaignList();
                allAdvanceCampaignList.addAll(advanceCampaignList);
                productAdvanceCampaignList.addAll(advanceCampaignList);
            } else {
                psAdvanceCampaignVO = new PsAdvanceCampaignVO();
            }
            Long listPriceSpvId = psProductVO.getListPriceSpvId();
            List spvList = psProductVO.getSpvList();
            if (CollectionUtils.isNotEmpty((Collection)spvList)) {
                for (PsSpvVO spvVO : spvList) {
                    List spvAdvanceCampaignList;
                    List spvCampaignList;
                    if (listPriceSpvId != null && listPriceSpvId.equals(spvVO.getSpvId()) && CollectionUtils.isNotEmpty((Collection)(spvCampaignList = spvVO.getCampaignList()))) {
                        for (PsCampaignVO psCampaignVO : spvCampaignList) {
                            if (allCampaignList.contains(psCampaignVO)) continue;
                            allCampaignList.add(psCampaignVO);
                        }
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(spvAdvanceCampaignList = spvVO.getAdvanceCampaignList()))) continue;
                    allAdvanceCampaignList.addAll(spvAdvanceCampaignList);
                }
            }
            List spvs = psProductVO.getSpvList();
            ArrayList advancePriceList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)spvs)) {
                for (PsSpvVO spv : spvs) {
                    ArrayList resultSpvCampaignList = Lists.newArrayList();
                    Boolean combined = spv.getCombined();
                    if (combined != null && !combined.booleanValue()) {
                        List spvAdvanceCampaignList = spv.getAdvanceCampaignList();
                        if (CollectionUtils.isNotEmpty((Collection)productAdvanceCampaignList)) {
                            resultSpvCampaignList.addAll(productAdvanceCampaignList);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)spvAdvanceCampaignList)) {
                            resultSpvCampaignList.addAll(spvAdvanceCampaignList);
                        }
                    }
                    BigDecimal spvOriginalPrice = spv.getSalesPrice();
                    advancePrice = PriceCalculators.calculateProductDiscountPrice(null, allowVipDiscount, spvOriginalPrice, resultSpvCampaignList, discountAmount);
                    advancePriceList.add(advancePrice);
                    spv.setAdvancePrice(advancePrice);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)allAdvanceCampaignList) && CollectionUtils.isNotEmpty((Collection)advancePriceList)) {
                Collections.sort(advancePriceList);
                psAdvanceCampaignVO.setMinPrice((BigDecimal)advancePriceList.get(0));
                psAdvanceCampaignVO.setMaxPrice((BigDecimal)advancePriceList.get(advancePriceList.size() - 1));
            } else if (CollectionUtils.isNotEmpty((Collection)productAdvanceCampaignList)) {
                advancePrice = PriceCalculators.calculateProductDiscountPrice(null, allowVipDiscount, originalPrice, productAdvanceCampaignList, discountAmount);
                psAdvanceCampaignVO.setMinPrice(advancePrice);
                psAdvanceCampaignVO.setMaxPrice(advancePrice);
            }
            if (CollectionUtils.isNotEmpty((Collection)allAdvanceCampaignList)) {
                Collections.sort(allAdvanceCampaignList, new Comparator<PsCampaignVO>(){

                    @Override
                    public int compare(PsCampaignVO campaign1, PsCampaignVO campaign2) {
                        if (campaign1.getAdvanceStartTime().getTime() < campaign2.getAdvanceStartTime().getTime()) {
                            return -1;
                        }
                        return 1;
                    }
                });
                psAdvanceCampaignVO.setAdvanceCampaignList((List)allAdvanceCampaignList);
                psProductVO.setPsAdvanceCampaignVO(psAdvanceCampaignVO);
            }
        }
        BigDecimal discountPrice = PriceCalculators.calculateProductDiscountPrice(psProductVO.getCode(), allowVipDiscount, originalPrice, allCampaignList, discountAmount);
        psProductVO.setDiscountPrice(discountPrice);
        if (cond.getBdDiscount() != null) {
            BigDecimal bdDiscountPrice = PriceCalculators.calculateProductDiscountPrice(psProductVO.getCode(), allowBdDiscount, originalPrice, allCampaignList, cond.getBdDiscount());
            psProductVO.setBdDiscountPrice(bdDiscountPrice);
        }
        return psProductVO;
    }

    public PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond) {
        return this.calculateDiscountPrice(productVO, spvVO, cond, null);
    }

    public PsSpvVO calculateDiscountPrice(PsProductVO productVO, PsSpvVO spvVO, PsMatchCampaignCond cond, List<PriceCalResultVO> results) {
        if (productVO == null) {
            return spvVO;
        }
        BigDecimal discountAmount = cond.getDiscount();
        if (this.discountTime().booleanValue() && productVO.getIsDiscount() != null && productVO.getIsDiscount() == 1 && discountAmount.doubleValue() == NORMAL_DISCOUNT) {
            cond.setDiscount(SPECIAL_DISCOUNT);
            discountAmount = SPECIAL_DISCOUNT;
        }
        BigDecimal originalPrice = new BigDecimal(String.valueOf(spvVO.getSalesPrice()));
        Boolean allowVipDiscount = productVO.getAllowVipDiscount() != null && productVO.getAllowVipDiscount() == 1;
        Boolean allowBdDiscount = productVO.getAllowBdDiscount() == null || productVO.getAllowBdDiscount() == 1;
        ArrayList resultCampaignList = Lists.newArrayList();
        Boolean combined = spvVO.getCombined();
        Boolean matchCampaign = cond.getMatchCampaign();
        if (matchCampaign != null && matchCampaign.booleanValue()) {
            List advanceCampaignList;
            if (combined != null && !combined.booleanValue()) {
                List skuCampaignList;
                List campaignList = productVO.getCampaignList();
                if (CollectionUtils.isNotEmpty((Collection)campaignList)) {
                    resultCampaignList.addAll(campaignList);
                }
                if (CollectionUtils.isNotEmpty((Collection)(skuCampaignList = spvVO.getCampaignList()))) {
                    for (PsCampaignVO campaignVO : skuCampaignList) {
                        if (resultCampaignList.contains(campaignVO)) continue;
                        resultCampaignList.add(campaignVO);
                    }
                }
            }
            BigDecimal targetPrice = PriceCalculators.calculateSpvDiscountPrice(spvVO, allowVipDiscount, originalPrice, resultCampaignList, cond.getDiscount(), results);
            spvVO.setDiscountPrice(targetPrice);
            spvVO.setPriceCalResults(results);
            if (cond.getBdDiscount() != null) {
                ArrayList bdResults = org.elasticsearch.common.collect.Lists.newArrayList();
                BigDecimal targetBdPrice = PriceCalculators.calculateSpvBdDiscountPrice(spvVO, allowBdDiscount, originalPrice, resultCampaignList, cond.getBdDiscount(), bdResults);
                spvVO.setBdDiscountPrice(targetBdPrice);
                spvVO.setBdPriceCalResults((List)bdResults);
            }
            if (CollectionUtils.isNotEmpty((Collection)(advanceCampaignList = spvVO.getAdvanceCampaignList()))) {
                BigDecimal advancePrice = PriceCalculators.calculateSpvDiscountPrice(spvVO, allowVipDiscount, originalPrice, advanceCampaignList, cond.getDiscount());
                spvVO.setAdvancePrice(advancePrice);
            }
        }
        return spvVO;
    }

    @Deprecated
    public PsSkuVO calculateDiscountPrice(PsProductVO productVO, PsSkuVO skuVO, PsMatchCampaignCond cond) {
        if (skuVO != null && productVO != null) {
            PsSpvVO spvVO = this.mcPsSpvService.findSpvBySkuCode(productVO.getCode(), skuVO.getSkuCode());
            if (spvVO == null) {
                return skuVO;
            }
            this.calculateDiscountPrice(productVO, spvVO, cond);
            skuVO.setDiscountPrice(spvVO.getDiscountPrice());
        }
        return skuVO;
    }

    public PsSkuVO calculateDiscountPrice(PsSkuVO skuVO, PsMatchCampaignCond cond) {
        PsProductVO productVO;
        if (skuVO != null && (productVO = this.findProdBySkuCode(skuVO.getSkuCode())) != null) {
            PsSpvVO spvVO = this.mcPsSpvService.findSpvBySkuCode(productVO.getCode(), skuVO.getSkuCode());
            if (spvVO == null) {
                return skuVO;
            }
            if (cond.getMatchCampaign() != null && cond.getMatchCampaign().booleanValue()) {
                this.campaignDomain.matchCampaigns(productVO, cond);
                this.campaignDomain.matchCampaigns(spvVO, cond, productVO.getCrossBorderFlag());
            }
            this.calculateDiscountPrice(productVO, spvVO, cond);
            skuVO.setDiscountPrice(spvVO.getDiscountPrice());
            if (CollectionUtils.isNotEmpty((Collection)productVO.getSpvList())) {
                skuVO.setCampaignList(((PsSpvVO)productVO.getSpvList().get(0)).getCampaignList());
            }
        }
        return skuVO;
    }

    public boolean updateBySkuCodes(List<String> skuCodes) {
        if (CollectionUtils.isEmpty(skuCodes)) {
            return true;
        }
        if (skuCodes.size() > 100) {
            int all = skuCodes.size() / 100;
            for (int i = 0; i < all; ++i) {
                List<String> subSkuCodes = skuCodes.subList(i * 100, (i + 1) * 100);
                if (this.updateBySkuCodes100(subSkuCodes)) continue;
                throw new PublicException("\u66f4\u65b0prod updateTime \u51fa\u9519");
            }
            if (skuCodes.size() > all * 100) {
                List<String> subSkuCodes = skuCodes.subList(all * 100, skuCodes.size());
                this.updateBySkuCodes100(subSkuCodes);
            }
            return true;
        }
        return this.updateBySkuCodes100(skuCodes);
    }

    private boolean updateBySkuCodes100(List<String> skuCodes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodes", skuCodes);
        params.put("pagenum", Integer.MAX_VALUE);
        List updateProds = this.client.findByFields(params, SearchType.OR);
        for (PsProductVO updateProd : updateProds) {
            List prodSkus;
            if (CollectionUtils.isEmpty((Collection)updateProd.getSkuCodes()) || CollectionUtils.isEmpty((Collection)(prodSkus = this.mcPsSkuService.findBySkuCodes(updateProd.getSkuCodes())))) continue;
            PsSkuVO psSkuVO = (PsSkuVO)prodSkus.get(0);
            if (updateProd.getSkuCodes().size() == 1) {
                updateProd.setListPrice(new BigDecimal(psSkuVO.getSalesPrice()));
            } else {
                for (PsSkuVO prodSku : prodSkus) {
                    if (!(updateProd.getListPrice().doubleValue() > prodSku.getSalesPrice())) continue;
                    updateProd.setListPrice(new BigDecimal(prodSku.getSalesPrice()).setScale(2, 5));
                }
            }
            updateProd.setCategoryId(psSkuVO.getCategoryId());
            updateProd.setCategoryCode(this.mcPcsSkuCategoryService.findById(psSkuVO.getCategoryId().longValue()).getCode());
        }
        if (CollectionUtils.isEmpty(updateProds)) {
            return true;
        }
        return this.update(updateProds);
    }

    public PsProductVO updateCategory(PsProductVO updateProd) {
        PsSkuVO psSkuVO = this.mcPsSkuService.findBySkuCode((String)updateProd.getSkuCodes().get(0));
        if (NumberUtil.isNullOrZero((Number)psSkuVO.getCategoryId())) {
            return updateProd;
        }
        updateProd.setCategoryId(psSkuVO.getCategoryId());
        return updateProd;
    }

    public PsProductVO findProdByChnCodeSkuCode(String chnCode, String skuCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.canSkus", skuCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("skuCodes", skuCode);
        params.put("onShelfChnCodes", chnCode);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        for (PsProductVO vo : fs) {
            if (vo.getCombined() != null && vo.getCombined().booleanValue()) continue;
            return vo;
        }
        return (PsProductVO)fs.get(0);
    }

    public PsProductVO findProdBySkuCode(String skuCode) {
        return this.findProdBySkuCode(skuCode, false);
    }

    public List<PsProductVO> findProdBySkuCodes(List<String> skuCodes) {
        return this.findProdBySkuCodes(skuCodes, false);
    }

    public PsProductVO findProdBySkuCode(String skuCode, PsMatchCampaignCond matchCampaignCond) {
        PsProductVO productVO = this.findProdBySkuCode(skuCode);
        if (productVO == null) {
            return null;
        }
        if (matchCampaignCond != null) {
            this.campaignDomain.matchListPageCampaigns(Lists.newArrayList((Object[])new PsProductVO[]{productVO}), matchCampaignCond);
        }
        return productVO;
    }

    public List<PsProductVO> findProdBySkuCodes(List<String> skuCodes, PsMatchCampaignCond matchCampaignCond) {
        List<PsProductVO> productVOList = this.findProdBySkuCodes(skuCodes);
        if (CollectionUtils.isEmpty(productVOList)) {
            return productVOList;
        }
        if (matchCampaignCond != null) {
            this.campaignDomain.matchListPageCampaigns(productVOList, matchCampaignCond);
        }
        return productVOList;
    }

    public PsProductVO findProdBySkuCode(String skuCode, Boolean combined) {
        List fs;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("skuCodes", skuCode);
        if (combined != null) {
            params.put("combined", combined != false ? 1 : 0);
        }
        if (CollectionUtils.isEmpty(fs = this.client.findByFields(params, SearchType.ANDLIKE))) {
            return null;
        }
        return (PsProductVO)fs.get(0);
    }

    public List<PsProductVO> findProdBySkuCodes(List<String> skuCodes, Boolean combined) {
        List<PsProductVO> fs;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pagenum", skuCodes.size());
        params.put("skuCodes", skuCodes);
        if (combined != null) {
            params.put("combined", combined != false ? 1 : 0);
        }
        if (CollectionUtils.isEmpty(fs = this.client.findByFields(params, SearchType.ANDLIKE))) {
            return null;
        }
        return fs;
    }

    public PsProductVO findProdBySpvId(Long spvId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("spvList.spvId", spvId);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        return (PsProductVO)fs.get(0);
    }

    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode) {
        List categories = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        ArrayList<Long> cateIds = new ArrayList<Long>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryId", cateIds);
        int currpage = 1;
        params.put("pagenum", 20);
        params.put("currpage", currpage);
        ArrayList seqList = new ArrayList();
        ArrayList<String> seq1 = new ArrayList<String>();
        seq1.add("categoryId");
        seq1.add("asc");
        seqList.add(seq1);
        ArrayList<String> seq = new ArrayList<String>();
        seq.add("seq");
        seq.add("asc");
        seqList.add(seq);
        params.put("sort", seqList);
        ArrayList<PsProductVO> productVOs = new ArrayList<PsProductVO>(100);
        List prodVos = this.client.findByFields(params, SearchType.ANDLIKE);
        productVOs.addAll(prodVos);
        while (prodVos.size() == 20) {
            params.put("currpage", ++currpage);
            params.put("pagenum", 20);
            params.put("sort", seqList);
            prodVos = this.client.findByFields(params, SearchType.ANDLIKE);
            productVOs.addAll(prodVos);
        }
        return productVOs;
    }

    public List<PsProductVO> findRecommondProdByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("stocks.soldOut", QueryBuilders.termQuery((String)"stocks.soldOut", (int)0));
        params.put("code", codes);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        LinkedHashMap<String, String> seqMap = new LinkedHashMap<String, String>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("listPrice", "asc");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        this.handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    public List<PsProductVO> findListPageByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("code", codes);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("listPrice", "asc");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        this.handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    public List<PsProductVO> findTopicByCodes(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("code", codes);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("listPrice", "asc");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        this.handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    public List<PsProductVO> findDiscountListByProdSearchCondVO(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findDiscountListByProdSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        ArrayList<Long> cateIds = new ArrayList<Long>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if (CollectionUtils.isNotEmpty(categoriesList)) {
            cateIds = new ArrayList(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }
        LinkedHashMap<String, Object> sortMap = new LinkedHashMap<String, Object>();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap paramsMap = new HashMap();
        HashMap<String, String> slMap = new HashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            params.put("frontCategories.categoryId", cateIds);
        }
        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");
        if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
            sortMap.put("campaignList.expireTime", "desc");
        } else if ("create_time".equals(sortField)) {
            sortMap.put("channelProdInfo.createTime", slMap);
            slMap.put("order", sortOrder);
            slMap.put("mode", "min");
        } else if ("price".equals(sortField)) {
            sortMap.put("listPrice", sortOrder);
        }
        params.put("sort", sortMap);
        selectMap.put("discountTypeId", 1);
        selectMap.put("accessway", matchCampaignCond.getAccessWay());
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
        LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
        this.handleProductList(productVOList, matchCampaignCond);
        sw.stop();
        LOGGER.info("\u3010\u6298\u6263\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u6298\u6263\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return productVOList;
    }

    public List<PsProductVO> findRecommondByCodesForApplet(String chnCode, List<String> codes, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("code", codes);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        LinkedHashMap seqMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        this.handleProductList(productVOList, matchCampaignCond);
        ArrayList<PsProductVO> list = new ArrayList<PsProductVO>();
        if (CollectionUtils.isNotEmpty(codes)) {
            block0: for (String code : codes) {
                if (!CollectionUtils.isNotEmpty(productVOList)) continue;
                for (PsProductVO vo : productVOList) {
                    if (!code.equals(vo.getCode())) continue;
                    list.add(vo);
                    continue block0;
                }
            }
        }
        return list;
    }

    public List<PsProductVO> findCrossBorderListByProdSearchCondVO(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findCrossBorderListByProdSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        ArrayList<Long> cateIds = new ArrayList<Long>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if (CollectionUtils.isNotEmpty(categoriesList)) {
            cateIds = new ArrayList(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }
        LinkedHashMap<String, Object> sortMap = new LinkedHashMap<String, Object>();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>();
        HashMap<String, String> slMap = new HashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            params.put("frontCategories.categoryId", cateIds);
        }
        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            paramsMap.put("categoryIds", cateIds);
        }
        map.put("order", "asc");
        map.put("mode", "min");
        if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
            sortMap.put("saleStartDate", "desc");
        } else if ("create_time".equals(sortField)) {
            sortMap.put("channelProdInfo.createTime", slMap);
            slMap.put("order", sortOrder);
            slMap.put("mode", "min");
        } else if ("price".equals(sortField)) {
            sortMap.put("listPrice", sortOrder);
        }
        params.put("sort", sortMap);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("isCrossBorder", isCrossBorder);
        List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
        LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
        this.handleProductList(productVOList, matchCampaignCond);
        sw.stop();
        LOGGER.info("\u3010\u6298\u6263\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u6298\u6263\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return productVOList;
    }

    public List<PsProductVO> findCustomzeListByProdSearchCondVO(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findCustomzeListByProdSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        PsSkuCond cond = new PsSkuCond();
        cond.setCanCustomize(Integer.valueOf(1));
        cond.setCurrpage(Integer.valueOf(0));
        cond.setPagenum(Integer.valueOf(100));
        List skus = this.mcPsSkuService.findByCond(cond);
        ArrayList<String> skucodes = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)skus)) {
            for (PsSkuVO skuVO : skus) {
                skucodes.add(skuVO.getSkuCode());
            }
        }
        LinkedHashMap sortMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap paramsMap = new HashMap();
        HashMap<String, String> slMap = new HashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("skuCodes", skucodes);
        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");
        sortMap.put("channelProdInfo.createTime", slMap);
        slMap.put("order", "DESC");
        slMap.put("mode", "min");
        params.put("sort", sortMap);
        List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
        LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
        this.handleProductList(productVOList, matchCampaignCond);
        sw.stop();
        LOGGER.info("\u3010\u6298\u6263\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u6298\u6263\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return productVOList;
    }

    public List<PsProductVO> findByProdSearchCondVO(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},prodSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        String key = prodSearchCondVO.getKeywords();
        String labels = prodSearchCondVO.getLabels();
        String brandId = prodSearchCondVO.getBrandId();
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();
        LinkedHashMap<String, Object> sortMap = new LinkedHashMap<String, Object>();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sMap2 = new HashMap<String, String>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> slMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)labelIds) || CollectionUtils.isNotEmpty((Collection)brandIds) || isCrossBorder.booleanValue() && CollectionUtils.isNotEmpty((Collection)cateCodes)) {
            ArrayList categoriesList = new ArrayList();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    Object category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    categoriesList.addAll(category);
                }
            }
            ArrayList<Long> cateIds = new ArrayList<Long>(categoriesList.size());
            for (Object category : categoriesList) {
                cateIds.add(category.getId());
            }
            if (!isNew.booleanValue() && CollectionUtils.isEmpty(cateIds)) {
                return Collections.emptyList();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            if (isNew.booleanValue()) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    Date end = new Date();
                    dateRange.setEnd(end);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    ((Calendar)calendar).add(5, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }
            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();
            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");
            if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
                sortMap.put("saleStartDate", "desc");
            } else if ("create_time".equals(sortField)) {
                sortMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                sortMap.put("listPrice", sortOrder);
            }
            String fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            sortMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);
            params.put("sort", sortMap);
            if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
                params.put("brandList.brandId", brandIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
                params.put("labels.labelId", labelIds);
            }
            selectMap.put("isCrossBorder", isCrossBorder);
            List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
            this.handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        if (isCrossBorder.booleanValue()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            sortMap.put("stocks.soldOut", sMap);
            sortMap.put("_score", sMap2);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            sMap2.put("order", "desc");
            sMap2.put("mode", "min");
            LOGGER.info("\u662f\u5426\u6d77\u6dd8\u5546\u54c1\u67e5\u8be2\u7684\u53c2\u6570    params={} from={},size={},isCrossBorder={}", new Object[]{params, from, size, isCrossBorder});
            selectMap.put("isCrossBorder", isCrossBorder);
            List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
            this.handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        if (!Strings.isNullOrEmpty((String)labels)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            LOGGER.info("\u6807\u7b7e\u67e5\u8be2\u7684\u53c2\u6570    params={} from={},size={},psTags={}", new Object[]{params, from, size, labels});
            selectMap.put("labels", labels);
            List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
            this.handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        if (!Strings.isNullOrEmpty((String)brandId)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();
            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            map.put("order", "asc");
            map.put("mode", "min");
            if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
                sortMap.put("saleStartDate", "desc");
            } else if ("create_time".equals(sortField)) {
                sortMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                sortMap.put("listPrice", sortOrder);
            }
            params.put("sort", sortMap);
            selectMap.put("brandId", brandId);
            List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
            this.handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        if (Strings.isNullOrEmpty((String)key)) {
            String fieldName;
            ArrayList categoriesList = new ArrayList();
            if (cateCodes != null && cateCodes.size() > 0) {
                for (String cateCode : cateCodes) {
                    Object category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                    categoriesList.addAll(category);
                }
            }
            ArrayList<Long> cateIds = new ArrayList<Long>(categoriesList.size());
            for (Object category : categoriesList) {
                cateIds.add(category.getId());
            }
            if (!isNew.booleanValue() && CollectionUtils.isEmpty(cateIds)) {
                return Collections.emptyList();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chnCode", chnCode);
            params.put("chnCanSaleSKu.chnCode", chnCode);
            params.put("chnCanSeeSKu.chnCode", chnCode);
            params.put("onShelfChnCodes", chnCode);
            params.put("frontCategories.categoryId", cateIds);
            if (isNew.booleanValue()) {
                DateRange dateRange = prodSearchCondVO.getDateRange();
                if (dateRange == null) {
                    dateRange = new DateRange();
                    Date end = new Date();
                    dateRange.setEnd(end);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(end);
                    ((Calendar)calendar).add(5, -14);
                    Date start = calendar.getTime();
                    dateRange.setStart(start);
                }
                params.put("channelProdInfo.createTime", dateRange);
            }
            String sortField = prodSearchCondVO.getSortField();
            String sortOrder = prodSearchCondVO.getSortOrder();
            sortMap.put("stocks.soldOut", sMap);
            sMap.put("order", "asc");
            sMap.put("mode", "min");
            sMap.put("nested_filter", sNestedMap);
            sNestedMap.put("stocks.chnCode", chnCode);
            paramsMap.put("categoryIds", cateIds);
            map.put("order", "asc");
            map.put("mode", "min");
            if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
                fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
                sortMap.put("_script", map);
                map.put("script", "frontCategorySort");
                map.put("params", paramsMap);
                paramsMap.put("fieldName", fieldName);
                sortMap.put("saleStartDate", "desc");
            } else {
                if ("create_time".equals(sortField)) {
                    sortMap.put("channelProdInfo.createTime", slMap);
                    slMap.put("order", sortOrder);
                    slMap.put("mode", "min");
                } else if ("price".equals(sortField)) {
                    sortMap.put("listPrice", sortOrder);
                }
                fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
                sortMap.put("_script", map);
                map.put("script", "frontCategorySort");
                map.put("params", paramsMap);
                paramsMap.put("fieldName", fieldName);
            }
            params.put("sort", sortMap);
            List<PsProductVO> productVOList = this.client.findByFieldWithProdSearchCondVO(params, SearchType.ANDLIKE, from, size);
            this.handleProductList(productVOList, matchCampaignCond);
            sw.stop();
            LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
            return productVOList;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("sort", sortMap);
        sortMap.put("stocks.soldOut", sMap);
        sortMap.put("_score", sMap2);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        sMap2.put("order", "desc");
        sMap2.put("mode", "min");
        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sortField)) {
            slMap = new HashMap();
            if ("create_time".equals(sortField)) {
                sortMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                sortMap.put("listPrice", sortOrder);
            }
        }
        LOGGER.info("\u5173\u952e\u5b57\u67e5\u8be2\u7684\u53c2\u6570    params={} from={},size={},key={}", new Object[]{params, from, size, key});
        List<PsProductVO> productVOList = this.client.findByFieldWithKeyWords(params, SearchType.ANDLIKE, key, from, size);
        LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
        this.handleProductList(productVOList, matchCampaignCond);
        sw.stop();
        LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return productVOList;
    }

    public List<PsProductVO> findByCampaignSearchCond(PsCampaignSearchCond campaignSearchCond) {
        String fieldName;
        List discountTypeIds;
        List cateCodes = campaignSearchCond.getCategoryCodes();
        Integer from = campaignSearchCond.getFrom() != null && campaignSearchCond.getFrom() > 0 ? campaignSearchCond.getFrom() : 0;
        Integer size = campaignSearchCond.getSize() != null && campaignSearchCond.getSize() > 0 ? campaignSearchCond.getSize() : 20;
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        HashMap<String, String> slMap = new HashMap<String, String>();
        String chnCode = campaignSearchCond.getChannelCode();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)chnCode)) {
            throw new PublicException("\u6e20\u9053\u53f7\u4e3a\u7a7a");
        }
        List campaignIds = campaignSearchCond.getCampaignIds();
        if (CollectionUtils.isEmpty((Collection)campaignIds)) {
            new PublicException("[\u6839\u636e\u6d3b\u52a8\u4fe1\u606f\u67e5\u8be2\u5546\u54c1]\u6ca1\u6709\u4f20\u6d3b\u52a8ID");
        }
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                Object category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        ArrayList<Long> cateIds = new ArrayList<Long>(categoriesList.size());
        for (Object category : categoriesList) {
            cateIds.add(category.getId());
        }
        PsMatchCampaignCond matchCampaignCond = PsMatchCampaignCond.buildCond((Integer)campaignSearchCond.getAccessWay(), (Integer)campaignSearchCond.getMemberLevel());
        matchCampaignCond.setCampaignIds(campaignIds);
        matchCampaignCond.setProductScopeIds(campaignSearchCond.getScopeIds());
        matchCampaignCond.setStates((List)Lists.newArrayList((Object[])new Integer[]{1}));
        List<PsCampaignVO> matchedCampaigns = this.campaignDomain.getMatchedCampaignList(matchCampaignCond);
        if (CollectionUtils.isEmpty(matchedCampaigns) || matchedCampaigns.size() != campaignSearchCond.getCampaignIds().size()) {
            return Lists.newArrayList();
        }
        BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
        orQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"campaignList.id", (Collection)campaignIds));
        orQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)"spvList.campaignList.id", (Collection)campaignIds));
        params.put("or", orQuery);
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);
        if (CollectionUtils.isNotEmpty(matchedCampaigns) && matchedCampaigns.size() == 1) {
            PsCampaignVO psCampaignVO = matchedCampaigns.get(0);
            Integer crossflag = psCampaignVO.getCrossBorderFlag();
            params.put("crossBorderFlag", crossflag);
        }
        if (CollectionUtils.isNotEmpty((Collection)(discountTypeIds = campaignSearchCond.getDiscountTypeIds()))) {
            params.put("campaignList.discountTypeId", QueryBuilders.termsQuery((String)"campaignList.discountTypeId", (Collection)discountTypeIds));
        }
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        paramsMap.put("categoryIds", cateIds);
        map.put("order", "asc");
        map.put("mode", "min");
        params.put("sort", seqMap);
        params.put("from", from);
        params.put("size", size);
        String sortField = campaignSearchCond.getSortField();
        String sortOrder = campaignSearchCond.getSortOrder();
        if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
            fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);
            seqMap.put("saleStartDate", "desc");
        } else {
            if ("create_time".equals(sortField)) {
                seqMap.put("channelProdInfo.createTime", slMap);
                slMap.put("order", sortOrder);
                slMap.put("mode", "min");
            } else if ("price".equals(sortField)) {
                seqMap.put("listPrice", sortOrder);
            }
            fieldName = categoriesList.size() > 1 ? "sort1" : "sort2";
            seqMap.put("_script", map);
            map.put("script", "frontCategorySort");
            map.put("params", paramsMap);
            paramsMap.put("fieldName", fieldName);
        }
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        matchCampaignCond.setDiscount(campaignSearchCond.getDiscount());
        matchCampaignCond.setBdDiscount(campaignSearchCond.getBdDiscount());
        this.handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    public List<PsProductVO> findByChnCodeCateCode(String chnCode, String cateCode, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }
        List categories = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
        ArrayList<Long> cateIds = new ArrayList<Long>(categories.size());
        for (PcsSkuCategoryVO category : categories) {
            cateIds.add(category.getId());
        }
        if (CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        ArrayList seqList = new ArrayList();
        LinkedHashMap<String, Object> seqMap = new LinkedHashMap<String, Object>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        seqMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        String fieldName = categories.size() > 1 ? "sort1" : "sort2";
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        seqMap.put("_script", map);
        map.put("script", "frontCategorySort");
        map.put("params", paramsMap);
        paramsMap.put("categoryIds", cateIds);
        paramsMap.put("fieldName", fieldName);
        map.put("order", "asc");
        map.put("mode", "min");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        this.handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    public List<PsProductVO> findByChnCodeCateCodeCreateTime(String chnCode, Map<String, Date> dateRange, PsMatchCampaignCond matchCampaignCond, int currpage, int pagenum) {
        if (pagenum < 1) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("pagenum", pagenum);
        params.put("currpage", currpage);
        LinkedHashMap sortRootMap = new LinkedHashMap();
        HashMap<String, Object> sortSoldOut = new HashMap<String, Object>();
        sortRootMap.put("stocks.soldOut", sortSoldOut);
        sortSoldOut.put("order", "asc");
        sortSoldOut.put("mode", "min");
        HashMap<String, String> soldOutNestedFilter = new HashMap<String, String>();
        sortSoldOut.put("nested_filter", soldOutNestedFilter);
        soldOutNestedFilter.put("stocks.chnCode", chnCode);
        HashMap<String, Object> sortCreateTime = new HashMap<String, Object>();
        sortRootMap.put("channelProdInfo.createTime", sortCreateTime);
        sortCreateTime.put("order", "desc");
        sortCreateTime.put("mode", "min");
        HashMap createTimeNestedFilter = new HashMap();
        sortCreateTime.put("nested_filter", createTimeNestedFilter);
        HashMap rangeMap = new HashMap();
        createTimeNestedFilter.put("range", rangeMap);
        HashMap<String, Date> createTimeRangeMap = new HashMap<String, Date>();
        rangeMap.put("channelProdInfo.createTime", createTimeRangeMap);
        createTimeRangeMap.put("from", dateRange.get("createTimeStart"));
        createTimeRangeMap.put("to", dateRange.get("createTimeEnd"));
        params.put("sort", sortRootMap);
        HashMap<String, Object> chanelProdTime = new HashMap<String, Object>();
        chanelProdTime.put("createTimeStart", dateRange.get("createTimeStart"));
        chanelProdTime.put("createTimeEnd", dateRange.get("createTimeEnd"));
        chanelProdTime.put("channelCode", chnCode);
        params.put("chanelProdTime", chanelProdTime);
        params.put("chnCode", chnCode);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        this.handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    public List<PsProductVO> findByChnCodeCateCodeRightLike(String chnCode, String cateCode) {
        ArrayList<PsProductVO> allProds = new ArrayList<PsProductVO>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("categoryCode", cateCode);
        List productVOs = this.client.findByFields(params, SearchType.AND);
        if (CollectionUtils.isNotEmpty(productVOs)) {
            allProds.addAll(productVOs);
        }
        params.remove("categoryCode");
        params.put("categoryCodePRE", cateCode + "_");
        List productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isNotEmpty(productVOList)) {
            allProds.addAll(productVOList);
        }
        return allProds;
    }

    public PsProductVO findProdByCode(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        List fs = this.client.findByFields(params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(fs)) {
            return null;
        }
        for (PsProductVO vo : fs) {
            vo.setCampaignList((List)Lists.newArrayList());
        }
        return (PsProductVO)fs.get(0);
    }

    public Map<String, PsProductVO> mapByProdIds(List<String> prodIds) {
        if (CollectionUtils.isNotEmpty(prodIds)) {
            HashMap rt = Maps.newHashMapWithExpectedSize((int)prodIds.size());
            PsProductCond cond = new PsProductCond();
            cond.setIds(prodIds);
            List<PsProductVO> prods = this.findByCond(cond);
            for (PsProductVO prod : prods) {
                rt.put(prod.getId(), prod);
            }
            return rt;
        }
        return null;
    }

    public Map<String, PsProductVO> mapByProdCodes(List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            HashMap rt = Maps.newHashMapWithExpectedSize((int)codes.size());
            PsProductCond cond = new PsProductCond();
            cond.setCodes(codes);
            cond.setPagenum(Integer.valueOf(200));
            List<PsProductVO> prods = this.findByCond(cond);
            for (PsProductVO prod : prods) {
                rt.put(prod.getCode(), prod);
            }
            return rt;
        }
        return null;
    }

    public PsProductVO getProductDetailByCode(String chnCode, String productCode, PsMatchCampaignCond matchCampaignCond) {
        List skuList;
        List campaignList;
        if (matchCampaignCond == null) {
            throw new PublicException("\u672a\u4f20\u6d3b\u52a8\u5339\u914d\u6761\u4ef6");
        }
        LOGGER.info("\u3010\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u3011 chnCode: {} prodCode: {}", (Object)chnCode, (Object)productCode);
        HashedMap params = new HashedMap();
        params.put("code", productCode);
        List list = this.client.findByFields((Map<String, Object>)params, SearchType.ANDLIKE);
        if (CollectionUtils.isEmpty(list)) {
            params = new HashedMap();
            params.put("skuCodes", productCode);
            params.put("combined", 0);
            list = this.client.findByFields((Map<String, Object>)params, SearchType.ANDLIKE);
            if (CollectionUtils.isEmpty(list)) {
                params = new HashedMap();
                params.put("skuCodes", productCode);
                params.put("combined", 1);
                list = this.client.findByFields((Map<String, Object>)params, SearchType.ANDLIKE);
                if (CollectionUtils.isEmpty(list)) {
                    LOGGER.info("\u3010\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u3011 \u627e\u4e0d\u5230PROD\u8be6\u60c5: {}", (Object)productCode);
                    return null;
                }
            }
        }
        PsProductVO psProductVO = (PsProductVO)list.get(0);
        if (matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.campaignDomain.matchCampaigns(psProductVO, matchCampaignCond);
            this.excludeSpecialCampaigns(psProductVO);
        }
        if (flowerMonthDeliveryProductCodeList.contains(productCode) && CollectionUtils.isNotEmpty((Collection)(campaignList = psProductVO.getCampaignList()))) {
            ArrayList specialCampaignList = Lists.newArrayList();
            for (PsCampaignVO item : campaignList) {
                if (!item.getDiscountTypeId().equals(DiscountTypeEnum.CHEAPEN_OTHER.getId()) || !item.getProductScopeId().equals(1)) continue;
                specialCampaignList.add(item);
            }
            psProductVO.setCampaignList((List)specialCampaignList);
        }
        this.calculateDiscountPrice(psProductVO, matchCampaignCond.getDiscount(), matchCampaignCond);
        List spvList = psProductVO.getSpvList();
        if (CollectionUtils.isEmpty((Collection)spvList)) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5546\u54c1\u4e2dSPV\u5217\u8868\u4e3a\u7a7a");
            return psProductVO;
        }
        String productIdStr = psProductVO.getId();
        Long productId = Long.valueOf(productIdStr);
        HashedMap skuMap = new HashedMap();
        List skuCodes = psProductVO.getSkuCodes();
        if (CollectionUtils.isEmpty((Collection)skuCodes)) {
            LOGGER.warn("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5546\u54c1\u4e2dSKU CODE\u5217\u8868\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)(skuList = this.mcPsSkuService.findBySkuCodes(skuCodes)))) {
            LOGGER.warn("\u672a\u627e\u5230\u4efb\u4f55SKU");
        }
        for (PsSkuVO skuVO : skuList) {
            skuMap.put(skuVO.getSkuCode(), skuVO);
        }
        Map<String, String> canSaleSkuMap = this.getCanSaleSkuMap(chnCode, psProductVO);
        Map<String, String> canSeeSkuMap = this.getCanSeeSkuMap(chnCode, psProductVO);
        ArrayList<PsSpvVO> newSpvList = new ArrayList<PsSpvVO>();
        PsBrandVO psBrandVO = new PsBrandVO();
        boolean flag = true;
        for (PsSpvVO spvVO : spvList) {
            spvVO.setProductId(productId);
            spvVO.setProductCode(psProductVO.getCode());
            if (psProductVO.getCombined().booleanValue()) {
                this.buildCombinedSpv(psProductVO, spvVO, (Map<String, PsSkuVO>)skuMap, matchCampaignCond);
            } else {
                this.buildSingleSpv(psProductVO, spvVO, (Map<String, PsSkuVO>)skuMap, matchCampaignCond);
            }
            if (this.isSpvAvailable(canSaleSkuMap, canSeeSkuMap, spvVO)) {
                newSpvList.add(spvVO);
            }
            if (!psProductVO.getCombined().booleanValue() || !flag) continue;
            PsSkuVO psSkuVO = ((PsSkuCombinationVO)spvVO.getSkuCombinationList().get(0)).getSubSkuVO();
            Long brandId = psSkuVO.getBrandId();
            String brandName = psSkuVO.getBrandName();
            String brandNameCn = psSkuVO.getBrandNameCN();
            String countryName = psSkuVO.getBrandCountryName();
            Long countryId = psSkuVO.getBrandCountryId();
            psBrandVO.setBrandCountryId(countryId);
            psBrandVO.setBrandCountryName(countryName);
            psBrandVO.setBrandId(brandId);
            psBrandVO.setBrandName(brandName);
            psBrandVO.setBrandNameCN(brandNameCn);
            flag = false;
        }
        if (psProductVO.getCombined().booleanValue()) {
            List brands = psProductVO.getBrands();
            brands.remove(psBrandVO);
            ArrayList<PsBrandVO> listCopy = new ArrayList<PsBrandVO>();
            listCopy.add(psBrandVO);
            listCopy.addAll(brands);
            psProductVO.setBrands(listCopy);
        }
        psProductVO.setSpvList(newSpvList);
        LOGGER.debug("\u3010\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u3011 \u7ed3\u679c CODE: {}, PROD:{}", (Object)productCode, (Object)psProductVO);
        return psProductVO;
    }

    private void buildCombinedSpv(PsProductVO productVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        this.calculateDiscountPrice(productVO, spvVO, matchCampaignCond);
        List skuCombinationList = spvVO.getSkuCombinationList();
        if (CollectionUtils.isEmpty((Collection)skuCombinationList)) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u7ec4\u5408SPV\u4e2d\u7684SKU\u7ec4\u5408\u4e3a\u7a7a");
            return;
        }
        for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
            String skuCode = skuCombinationVO.getSubSkuCode();
            PsSkuVO skuVO = this.getSkuFromCodeOrCache(skuCode, skuMap);
            skuCombinationVO.setSubSkuVO(skuVO);
        }
    }

    private void buildSingleSpv(PsProductVO psProductVO, PsSpvVO spvVO, Map<String, PsSkuVO> skuMap, PsMatchCampaignCond matchCampaignCond) {
        String skuCode = spvVO.getSkuCode();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)skuCode)) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5355\u54c1SPV\u4e2d\u7684SKU CODE\u4e3a\u7a7a");
            return;
        }
        PsSkuVO skuVO = this.getSkuFromCodeOrCache(skuCode, skuMap);
        spvVO.setSkuVO(skuVO);
        spvVO.setSalesPrice(new BigDecimal(skuVO.getSalesPrice()));
        spvVO.setCostPrice(skuVO.getCostPrice());
        spvVO.setDiscountPrice(skuVO.getDiscountPrice());
        spvVO.setAdvancePrice(skuVO.getAdvancePrice());
        spvVO = this.calculateDiscountPrice(psProductVO, spvVO, matchCampaignCond);
        skuVO.setDiscountPrice(spvVO.getDiscountPrice());
        String skuCategoryDesc = psProductVO.getSkuCategoryDesc();
        String skuCateName = skuVO.getSkuCateName();
        if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{skuCategoryDesc}) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)skuCateName)) {
            PsAttributeValuePairVO attributeValuePairVO = new PsAttributeValuePairVO();
            attributeValuePairVO.setCombined(Boolean.valueOf(false));
            attributeValuePairVO.setAttrName(skuCategoryDesc);
            attributeValuePairVO.setValue(skuCateName);
            spvVO.setAttributeValuePairList(Arrays.asList(attributeValuePairVO));
        }
    }

    private boolean isSpvAvailable(Map<String, String> canSaleMap, Map<String, String> canSeeMap, PsSpvVO spvVO) {
        if (spvVO.getCombined().booleanValue()) {
            List skuCombinationList = spvVO.getSkuCombinationList();
            for (PsSkuCombinationVO skuCombinationVO : skuCombinationList) {
                if (this.isSkuAvailable(canSaleMap, canSeeMap, skuCombinationVO.getSubSkuCode())) continue;
                return false;
            }
            return true;
        }
        return this.isSkuAvailable(canSaleMap, canSeeMap, spvVO.getSkuCode());
    }

    private boolean isSkuAvailable(Map<String, String> canSaleMap, Map<String, String> canSeeMap, String skuCode) {
        return canSaleMap.containsKey(skuCode) && canSeeMap.containsKey(skuCode);
    }

    private PsSkuVO getSkuFromCodeOrCache(String skuCode, Map<String, PsSkuVO> skuMap) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)skuCode)) {
            LOGGER.error("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5355\u54c1SPV\u4e2d\u7684SKU CODE\u4e3a\u7a7a");
            return null;
        }
        PsSkuVO skuVO = skuMap.get(skuCode);
        if (skuVO == null) {
            LOGGER.warn("\u3010\u5546\u54c1\u8be6\u60c5\u3011\u5355\u54c1SPV\u4e2d\u7684SKU[{}]\u672a\u80fd\u5728SKU CODE\u4e2d\u627e\u5230", (Object)skuCode);
            skuVO = this.mcPsSkuService.findBySkuCode(skuCode);
        }
        return skuVO;
    }

    private Map<String, String> getCanSeeSkuMap(String chnCode, PsProductVO psProductVO) {
        HashedMap canSeeSkuMap = new HashedMap();
        List canSeeSkuList = psProductVO.getChnCanSeeSKu();
        if (CollectionUtils.isEmpty((Collection)canSeeSkuList)) {
            return canSeeSkuMap;
        }
        PsChnProdSaleSkuVO canSeeSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSeeSkuList) {
            if (!StringUtils.equals((String)chnProdSaleSkuVO.getChnCode(), (String)chnCode)) continue;
            canSeeSku = chnProdSaleSkuVO;
            break;
        }
        if (canSeeSku != null) {
            for (String skuCode : canSeeSku.getCanSkus()) {
                canSeeSkuMap.put(skuCode, skuCode);
            }
        }
        return canSeeSkuMap;
    }

    private Map<String, String> getCanSaleSkuMap(String chnCode, PsProductVO psProductVO) {
        HashedMap canSaleSkuMap = new HashedMap();
        List canSaleSkuList = psProductVO.getChnCanSaleSKu();
        if (CollectionUtils.isEmpty((Collection)canSaleSkuList)) {
            return canSaleSkuMap;
        }
        PsChnProdSaleSkuVO canSaleSku = null;
        for (PsChnProdSaleSkuVO chnProdSaleSkuVO : canSaleSkuList) {
            if (!StringUtils.equals((String)chnProdSaleSkuVO.getChnCode(), (String)chnCode)) continue;
            canSaleSku = chnProdSaleSkuVO;
            break;
        }
        if (canSaleSku != null) {
            for (String skuCode : canSaleSku.getCanSkus()) {
                canSaleSkuMap.put(skuCode, skuCode);
            }
        }
        return canSaleSkuMap;
    }

    private void handleProductList(List<PsProductVO> productVOList, PsMatchCampaignCond matchCampaignCond) {
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.campaignDomain.matchListPageCampaigns(productVOList, matchCampaignCond);
        }
        if (matchCampaignCond != null) {
            this.calculateDiscountPrice(productVOList, matchCampaignCond.getDiscount(), matchCampaignCond);
        }
    }

    public List<PsProductVO> addOnItemList(String chnCode, int pagenum, PsMatchCampaignCond matchCampaignCond) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("stocks.soldOut", QueryBuilders.termQuery((String)"stocks.soldOut", (int)0));
        RangeQueryBuilder listPriceRangeQueryBuilder = QueryBuilders.rangeQuery((String)"listPrice").gt(0).lte(99);
        params.put("listPrice", listPriceRangeQueryBuilder);
        params.put("currpage", 1);
        params.put("pagenum", pagenum);
        LinkedHashMap<String, String> seqMap = new LinkedHashMap<String, String>();
        ArrayList<String> sortUpdateTime = new ArrayList<String>();
        sortUpdateTime.add("updateTime");
        sortUpdateTime.add("asc");
        ArrayList<String> sortCode = new ArrayList<String>();
        sortCode.add("code");
        sortCode.add("asc");
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        sNestedMap.put("stocks.chnCode", chnCode);
        seqMap.put("listPrice", "asc");
        seqMap.put("saleStartDate", "desc");
        params.put("sort", seqMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        if (matchCampaignCond != null && matchCampaignCond.getMatchCampaign().booleanValue()) {
            this.campaignDomain.matchListPageCampaigns(productVOList, matchCampaignCond);
            productVOList = this.calculateDiscountPrice(productVOList, matchCampaignCond.getDiscount(), matchCampaignCond);
        }
        return productVOList;
    }

    public List<PsProductVO> prodDetailsList(String chnCode, Long brandId, Long categoryId, Integer startListPrices, Integer endListPrice, int pagenum, PsMatchCampaignCond matchCampaignCond) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("stocks.soldOut", QueryBuilders.termQuery((String)"stocks.soldOut", (int)0));
        params.put("listPrice", QueryBuilders.rangeQuery((String)"listPrice").gt((Object)startListPrices).lte((Object)endListPrice));
        params.put("currpage", 1);
        params.put("pagenum", pagenum);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (categoryId != null) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"frontCategories.categoryId", (Object)categoryId));
        }
        if (brandId != null) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"brandList.brandId", (Object)brandId));
        }
        params.put("or", boolQueryBuilder);
        LinkedHashMap<String, String> sortMap = new LinkedHashMap<String, String>();
        sortMap.put("_id", "desc");
        params.put("sort", sortMap);
        List<PsProductVO> productVOList = this.client.findByFields(params, SearchType.ANDLIKE);
        this.handleProductList(productVOList, matchCampaignCond);
        return productVOList;
    }

    private Integer getAppFirstGiftKey(Integer memberLevel) {
        if (memberLevel == null) {
            return -1;
        }
        switch (memberLevel) {
            case -1: {
                return 1;
            }
            case 0: 
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 3;
            }
        }
        return -2;
    }

    private static List<PsCampaignSectionVO> buildCampaignSections(Long productId) {
        ArrayList campaignSectionList = Lists.newArrayList();
        PsCampaignSectionVO sectionVO = new PsCampaignSectionVO();
        sectionVO.setLine(BigDecimal.ZERO);
        sectionVO.setConditionType(Integer.valueOf(1));
        sectionVO.setFactorType(Integer.valueOf(1));
        sectionVO.setFactor(new BigDecimal(1));
        sectionVO.setRanking(Double.valueOf(1.0));
        ArrayList campaignSectionProducts = Lists.newArrayList();
        PsCampaignSectionProductVO sectionProductVO = new PsCampaignSectionProductVO();
        sectionProductVO.setProductId(productId);
        sectionProductVO.setPricePrice(BigDecimal.ZERO);
        sectionProductVO.setPriceCount(Integer.valueOf(1));
        campaignSectionProducts.add(sectionProductVO);
        sectionVO.setCampaignSectionProducts((List)campaignSectionProducts);
        campaignSectionList.add(sectionVO);
        return campaignSectionList;
    }

    private static PsCampaignVO buildAppFirstGiftCampaign(List<Integer> accessWayIds, List<Integer> memberLevels, Long productId) {
        PsCampaignVO appFirstGift = new PsCampaignVO();
        appFirstGift.setId(Long.valueOf(-1L));
        appFirstGift.setCode("xxx");
        appFirstGift.setName("\u9996\u5355\u8d60");
        appFirstGift.setTitle("\u9996\u5355\u8d60\u597d\u793c");
        appFirstGift.setState(Integer.valueOf(2));
        Date now = new Date();
        appFirstGift.setStartTime(now);
        appFirstGift.setExpireTime(DateUtils.addYears((Date)now, (int)5));
        appFirstGift.setProductScopeId(Integer.valueOf(3));
        appFirstGift.setDiscountTypeId(Integer.valueOf(3));
        appFirstGift.setDiscountTypeName("\u9996\u5355\u8d60");
        appFirstGift.setAccessWayIds(accessWayIds);
        appFirstGift.setMemberLevels(memberLevels);
        appFirstGift.setCumulative(Integer.valueOf(0));
        appFirstGift.setCreateTime(now);
        appFirstGift.setApprovalState(Integer.valueOf(4));
        List<PsCampaignSectionVO> campaignSectionList = McPsProductServiceImpl.buildCampaignSections(productId);
        appFirstGift.setCampaignSectionList(campaignSectionList);
        return appFirstGift;
    }

    public void queryNewProductCategoryListCron() {
        ProdSearchCond prodSearchCond = new ProdSearchCond();
        prodSearchCond.setFrom(Integer.valueOf(0));
        prodSearchCond.setSize(Integer.valueOf(1000));
        prodSearchCond.setIsNew(Boolean.valueOf(true));
        List<PsProductVO> prodList = this.findByProdSearchCondVO(CHN2018, null, prodSearchCond);
        List<Object> combinedCategoryList = new ArrayList();
        ArrayList<String> idList = new ArrayList<String>();
        for (PsProductVO psProductVO : prodList) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if (combined.booleanValue()) {
                List skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList = this.pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
                continue;
            }
            idList.add(psProductVO.getId());
        }
        PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
        cond.setProductIds(idList);
        List categoryList = this.mcPcsSkuCategoryService.findByCondCategoryCron(cond);
        categoryList.addAll(combinedCategoryList);
        ArrayList categories = new ArrayList(new HashSet(categoryList));
        this.redisClient.putCache(CHN2018 + "NewProdCategory", categories);
        List<Object> combinedCategoryList2 = new ArrayList();
        List<PsProductVO> prodList2 = this.findByProdSearchCondVO(CHN2049, null, prodSearchCond);
        ArrayList<String> idList2 = new ArrayList<String>();
        for (PsProductVO psProductVO : prodList2) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if (combined.booleanValue()) {
                List skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList2 = this.pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
                continue;
            }
            idList2.add(psProductVO.getId());
        }
        PcsSkuCategoryCond cond2 = new PcsSkuCategoryCond();
        cond2.setProductIds(idList2);
        List categoryList2 = this.mcPcsSkuCategoryService.findByCondCategoryCron(cond2);
        categoryList2.addAll(combinedCategoryList2);
        ArrayList categories2 = new ArrayList(new HashSet(categoryList2));
        this.redisClient.putCache(CHN2049 + "NewProdCategory", categories2);
    }

    public void queryDiscountProductCategoryListCron() {
        ProdSearchCond prodSearchCond = new ProdSearchCond();
        prodSearchCond.setFrom(Integer.valueOf(0));
        prodSearchCond.setSize(Integer.valueOf(1000));
        List<PsProductVO> prodList = this.findDiscountListByProdSearchCondVO(CHN2018, null, prodSearchCond);
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> combinedCategoryList = new ArrayList();
        for (PsProductVO psProductVO : prodList) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if (combined.booleanValue()) {
                List skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList = this.pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
                continue;
            }
            idList.add(psProductVO.getId());
        }
        PcsSkuCategoryCond cond = new PcsSkuCategoryCond();
        cond.setProductIds(idList);
        List categoryList = this.mcPcsSkuCategoryService.findByCondCategoryCron(cond);
        categoryList.addAll(combinedCategoryList);
        ArrayList categories = new ArrayList(new HashSet(categoryList));
        this.redisClient.putCache(CHN2018 + "DiscountProdCategory", categories);
        List<Object> combinedCategoryList2 = new ArrayList();
        List<PsProductVO> prodList2 = this.findDiscountListByProdSearchCondVO(CHN2049, null, prodSearchCond);
        ArrayList<String> idList2 = new ArrayList<String>();
        for (PsProductVO psProductVO : prodList2) {
            Boolean combined = psProductVO.getCombined() == null ? false : psProductVO.getCombined();
            if (combined.booleanValue()) {
                List skuCodes = psProductVO.getSkuCodes();
                combinedCategoryList2 = this.pcsSkuCategoryMapper.findCodeBySkuCodeList(skuCodes);
                continue;
            }
            idList2.add(psProductVO.getId());
        }
        PcsSkuCategoryCond cond2 = new PcsSkuCategoryCond();
        cond2.setProductIds(idList2);
        List categoryList2 = this.mcPcsSkuCategoryService.findByCondCategoryCron(cond2);
        categoryList2.addAll(combinedCategoryList2);
        ArrayList categories2 = new ArrayList(new HashSet(categoryList2));
        this.redisClient.putCache(CHN2049 + "DiscountProdCategory", categories2);
    }

    public PcsSkuCategoryBrandLabelVO queryNewtCategoryBrandLabel(ProdSearchCond prodSearchCond) {
        PcsBrandCond cond;
        List<Long> brandIds;
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
        prodSearchCond.setIsNew(Boolean.valueOf(true));
        prodSearchCond.setAggs(Integer.valueOf(1));
        String chncode = prodSearchCond.getChannelCode();
        List brands = new ArrayList();
        List labels = new ArrayList();
        List categorys = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getBrandIds()) && CollectionUtils.isNotEmpty(brandIds = this.findNewProdListByAggs(chncode, null, prodSearchCond))) {
            cond = new PcsBrandCond();
            cond.setBrandIds(brandIds);
            brands = this.mcPcsBrandService.findByCondIds(cond);
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(Integer.valueOf(2));
            List<Long> labelIds = this.findNewProdListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = this.mcOpLabelService.findByIds((OpLabelCond)cond);
            }
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getCategoryCodes())) {
            prodSearchCond.setAggs(Integer.valueOf(3));
            List<Long> categoryIds = this.findNewProdListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                cond = new PcsSkuCategoryCond();
                cond.setIds(categoryIds);
                categorys = this.mcPcsSkuCategoryService.findCategoryByIds((PcsSkuCategoryCond)cond);
            }
        }
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    public PcsSkuCategoryBrandLabelVO queryDiscountCategoryBrandLabel(ProdSearchCond prodSearchCond) {
        PcsBrandCond cond;
        List<Long> brandIds;
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
        prodSearchCond.setAggs(Integer.valueOf(1));
        String chncode = prodSearchCond.getChannelCode();
        List brands = new ArrayList();
        List labels = new ArrayList();
        List categorys = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getBrandIds()) && CollectionUtils.isNotEmpty(brandIds = this.findDiscountListByAggs(chncode, null, prodSearchCond))) {
            cond = new PcsBrandCond();
            cond.setBrandIds(brandIds);
            brands = this.mcPcsBrandService.findByCondIds(cond);
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(Integer.valueOf(2));
            List<Long> labelIds = this.findDiscountListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = this.mcOpLabelService.findByIds((OpLabelCond)cond);
            }
        }
        if (!CHN2018.equals(chncode) && CollectionUtils.isEmpty((Collection)prodSearchCond.getCategoryCodes())) {
            prodSearchCond.setAggs(Integer.valueOf(3));
            List<Long> categoryIds = this.findDiscountListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                cond = new PcsSkuCategoryCond();
                cond.setIds(categoryIds);
                categorys = this.mcPcsSkuCategoryService.findCategoryByIds((PcsSkuCategoryCond)cond);
            }
        }
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    public PcsSkuCategoryBrandLabelVO queryCrossBorderCategoryBrandLabel(ProdSearchCond prodSearchCond) {
        PcsBrandCond cond;
        List<Long> brandIds;
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
        prodSearchCond.setIsCrossBorder(Boolean.valueOf(true));
        prodSearchCond.setAggs(Integer.valueOf(1));
        String chncode = prodSearchCond.getChannelCode();
        List brands = new ArrayList();
        List labels = new ArrayList();
        Long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getBrandIds()) && CollectionUtils.isNotEmpty(brandIds = this.findCrossBorderListByAggs(chncode, null, prodSearchCond))) {
            cond = new PcsBrandCond();
            cond.setBrandIds(brandIds);
            brands = this.mcPcsBrandService.findByCondIds(cond);
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(Integer.valueOf(2));
            List<Long> labelIds = this.findCrossBorderListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = this.mcOpLabelService.findByIds((OpLabelCond)cond);
            }
        }
        vo.setBrands(brands);
        vo.setLabels(labels);
        return vo;
    }

    public PcsSkuCategoryBrandLabelVO queryCategoryBrandLabelByCodes(ProdSearchCond prodSearchCond) {
        PcsBrandCond cond;
        List<Long> brandIds;
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
        prodSearchCond.setAggs(Integer.valueOf(1));
        String chncode = prodSearchCond.getChannelCode();
        List brands = new ArrayList();
        List labels = new ArrayList();
        List categorys = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getBrandIds()) && CollectionUtils.isNotEmpty(brandIds = this.findProdListByAggs(chncode, null, prodSearchCond))) {
            cond = new PcsBrandCond();
            cond.setBrandIds(brandIds);
            brands = this.mcPcsBrandService.findByCondIds(cond);
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(Integer.valueOf(2));
            List<Long> labelIds = this.findProdListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = this.mcOpLabelService.findByIds((OpLabelCond)cond);
            }
        }
        if (!CHN2018.equals(chncode) && CollectionUtils.isNotEmpty((Collection)prodSearchCond.getCategoryCodes())) {
            PcsSkuCategoryCond cond2 = new PcsSkuCategoryCond();
            cond2.setCodes(prodSearchCond.getCategoryCodes());
            categorys = this.mcPcsSkuCategoryService.findCategoryByIds(cond2);
        }
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    public PcsSkuCategoryBrandLabelVO queryCategoryBrandLabelByBrandId(ProdSearchCond prodSearchCond) {
        OpLabelCond cond;
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
        String brandId = prodSearchCond.getBrandId();
        String chncode = prodSearchCond.getChannelCode();
        ArrayList<PcsBrandVO> brands = new ArrayList<PcsBrandVO>();
        List labels = new ArrayList();
        List categorys = new ArrayList();
        if (brandId != null) {
            PcsBrandVO brandVO = this.mcPcsBrandService.findById(Long.valueOf(brandId).longValue());
            brands.add(brandVO);
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(Integer.valueOf(2));
            List<Long> labelIds = this.findBrandListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = this.mcOpLabelService.findByIds(cond);
            }
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getCategoryCodes())) {
            prodSearchCond.setAggs(Integer.valueOf(3));
            List<Long> categoryIds = this.findBrandListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                cond = new PcsSkuCategoryCond();
                cond.setIds(categoryIds);
                categorys = this.mcPcsSkuCategoryService.findCategoryByIds((PcsSkuCategoryCond)cond);
            }
        }
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    public List<Long> findCrossBorderListByAggs(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findCrossBorderListByProdSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        ArrayList<Long> cateIds = new ArrayList<Long>();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        Boolean isCrossBorder = prodSearchCondVO.getIsCrossBorder() == null ? false : prodSearchCondVO.getIsCrossBorder();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if (CollectionUtils.isNotEmpty(categoriesList)) {
            cateIds = new ArrayList(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }
        LinkedHashMap sortMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>();
        HashMap slMap = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            params.put("frontCategories.categoryId", cateIds);
        }
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            paramsMap.put("categoryIds", cateIds);
        }
        map.put("order", "asc");
        map.put("mode", "min");
        params.put("sort", sortMap);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("isCrossBorder", isCrossBorder);
        selectMap.put("aggs", aggs);
        List<Long> ids = this.client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("\u3010\u6d77\u6dd8\u5546\u54c1\u67e5\u8be2\u54c1\u724c\u6807\u7b7e\u63a5\u53e3\u8017\u65f6\u3011 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return ids;
    }

    public List<Long> findDiscountListByAggs(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findDiscountListByProdSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        ArrayList<Long> cateIds = new ArrayList<Long>();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if (CollectionUtils.isNotEmpty(categoriesList)) {
            cateIds = new ArrayList(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }
        LinkedHashMap sortMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap paramsMap = new HashMap();
        HashMap slMap = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            params.put("frontCategories.categoryId", cateIds);
        }
        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");
        params.put("sort", sortMap);
        selectMap.put("discountTypeId", 1);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("aggs", aggs);
        List<Long> ids = this.client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("\u3010\u6298\u6263\u6807\u7b7e\u54c1\u724c\u67e5\u8be2\u63a5\u53e3\u8017\u65f6\u3011 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return ids;
    }

    public List<Long> findNewProdListByAggs(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},prodSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        LinkedHashMap sortMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap paramsMap = new HashMap();
        HashMap slMap = new HashMap();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                Object category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        ArrayList<Long> cateIds = new ArrayList<Long>(categoriesList.size());
        for (Object category : categoriesList) {
            cateIds.add(category.getId());
        }
        if (!isNew.booleanValue() && CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);
        if (isNew.booleanValue()) {
            DateRange dateRange = prodSearchCondVO.getDateRange();
            if (dateRange == null) {
                dateRange = new DateRange();
                Date end = new Date();
                dateRange.setEnd(end);
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(end);
                ((Calendar)calendar).add(5, -14);
                Date start = calendar.getTime();
                dateRange.setStart(start);
            }
            params.put("channelProdInfo.createTime", dateRange);
        }
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        paramsMap.put("categoryIds", cateIds);
        map.put("order", "asc");
        map.put("mode", "min");
        params.put("sort", sortMap);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("aggs", aggs);
        List<Long> ids = this.client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("\u3010\u6700\u65b0\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return ids;
    }

    public List<Long> findProdListByAggs(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},prodSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        Boolean isNew = prodSearchCondVO.getIsNew() == null ? false : prodSearchCondVO.getIsNew();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        LinkedHashMap sortMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap paramsMap = new HashMap();
        HashMap slMap = new HashMap();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                Object category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        ArrayList<Long> cateIds = new ArrayList<Long>(categoriesList.size());
        for (Object category : categoriesList) {
            cateIds.add(category.getId());
        }
        if (!isNew.booleanValue() && CollectionUtils.isEmpty(cateIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        params.put("frontCategories.categoryId", cateIds);
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        paramsMap.put("categoryIds", cateIds);
        map.put("order", "asc");
        map.put("mode", "min");
        params.put("sort", sortMap);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("aggs", aggs);
        List<Long> ids = this.client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("\u3010\u6700\u65b0\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return ids;
    }

    public List<Long> findBrandListByAggs(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findDiscountListByProdSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        ArrayList<Long> cateIds = new ArrayList<Long>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        List labelIds = prodSearchCondVO.getLabelIds();
        ArrayList<String> brandIds = new ArrayList<String>();
        String brandId = prodSearchCondVO.getBrandId();
        brandIds.add(brandId);
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if (CollectionUtils.isNotEmpty(categoriesList)) {
            cateIds = new ArrayList(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }
        LinkedHashMap sortMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap paramsMap = new HashMap();
        HashMap slMap = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            params.put("frontCategories.categoryId", cateIds);
        }
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        map.put("order", "asc");
        map.put("mode", "min");
        params.put("sort", sortMap);
        if (CollectionUtils.isNotEmpty(brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("aggs", aggs);
        List<Long> ids = this.client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("\u3010\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return ids;
    }

    public List<PsProductVO> findSpecialDiscountListByProdSearchCondVO(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findCrossBorderListByProdSearchCondVO={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        ArrayList<Long> cateIds = new ArrayList<Long>();
        Integer from = prodSearchCondVO.getFrom() != null && prodSearchCondVO.getFrom() > 0 ? prodSearchCondVO.getFrom() : 0;
        Integer size = prodSearchCondVO.getSize() != null && prodSearchCondVO.getSize() > 0 ? prodSearchCondVO.getSize() : 20;
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if (CollectionUtils.isNotEmpty(categoriesList)) {
            cateIds = new ArrayList(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }
        LinkedHashMap<String, Object> sortMap = new LinkedHashMap<String, Object>();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>();
        HashMap<String, String> slMap = new HashMap<String, String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            params.put("frontCategories.categoryId", cateIds);
        }
        String sortField = prodSearchCondVO.getSortField();
        String sortOrder = prodSearchCondVO.getSortOrder();
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            paramsMap.put("categoryIds", cateIds);
        }
        map.put("order", "asc");
        map.put("mode", "min");
        if (Strings.isNullOrEmpty((String)sortField) || Strings.isNullOrEmpty((String)sortOrder)) {
            sortMap.put("saleStartDate", "desc");
        } else if ("create_time".equals(sortField)) {
            sortMap.put("channelProdInfo.createTime", slMap);
            slMap.put("order", sortOrder);
            slMap.put("mode", "min");
        } else if ("price".equals(sortField)) {
            sortMap.put("listPrice", sortOrder);
        }
        params.put("sort", sortMap);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("isDiscount", 1);
        List<PsProductVO> productVOList = this.client.findByFieldWithSelectMap(params, SearchType.ANDLIKE, selectMap, from, size);
        LOGGER.info("\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u91cf\u4e3a={}", (Object)productVOList.size());
        this.handleProductList(productVOList, matchCampaignCond);
        sw.stop();
        LOGGER.info("\u3010\u7279\u6b8a\u6298\u6263\u5546\u54c1\u63a5\u53e3\u8017\u65f6\u3011\u7279\u6b8a\u6298\u6263\u5546\u54c1\u67e5\u8be2\u5217\u8868 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return productVOList;
    }

    public PcsSkuCategoryBrandLabelVO querySpecialDiscountBrandLabel(ProdSearchCond prodSearchCond) {
        PcsBrandCond cond;
        List<Long> brandIds;
        PcsSkuCategoryBrandLabelVO vo = new PcsSkuCategoryBrandLabelVO();
        prodSearchCond.setAggs(Integer.valueOf(1));
        String chncode = prodSearchCond.getChannelCode();
        List brands = new ArrayList();
        List labels = new ArrayList();
        List categorys = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getBrandIds()) && CollectionUtils.isNotEmpty(brandIds = this.findSpecialDiscountListByAggs(chncode, null, prodSearchCond))) {
            cond = new PcsBrandCond();
            cond.setBrandIds(brandIds);
            brands = this.mcPcsBrandService.findByCondIds(cond);
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getLabelIds())) {
            prodSearchCond.setAggs(Integer.valueOf(2));
            List<Long> labelIds = this.findSpecialDiscountListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(labelIds)) {
                cond = new OpLabelCond();
                cond.setLabelIds(labelIds);
                labels = this.mcOpLabelService.findByIds((OpLabelCond)cond);
            }
        }
        if (CollectionUtils.isEmpty((Collection)prodSearchCond.getCategoryCodes())) {
            prodSearchCond.setAggs(Integer.valueOf(3));
            List<Long> categoryIds = this.findSpecialDiscountListByAggs(chncode, null, prodSearchCond);
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                cond = new PcsSkuCategoryCond();
                cond.setIds(categoryIds);
                categorys = this.mcPcsSkuCategoryService.findCategoryByIds((PcsSkuCategoryCond)cond);
            }
        }
        vo.setBrands(brands);
        vo.setLabels(labels);
        vo.setCategoryList(categorys);
        return vo;
    }

    public List<Long> findSpecialDiscountListByAggs(String chnCode, PsMatchCampaignCond matchCampaignCond, ProdSearchCond prodSearchCondVO) {
        StopWatch sw = new StopWatch();
        sw.start();
        LOGGER.info("====\u67e5\u8be2es \u53c2\u6570\u4e3a chnCode= {},findSpecialDiscountListByAggs={}", (Object)chnCode, (Object)prodSearchCondVO);
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        ArrayList<Long> cateIds = new ArrayList<Long>();
        Integer aggs = prodSearchCondVO.getAggs() == null ? 0 : prodSearchCondVO.getAggs();
        List labelIds = prodSearchCondVO.getLabelIds();
        List brandIds = prodSearchCondVO.getBrandIds();
        List cateCodes = prodSearchCondVO.getCategoryCodes();
        ArrayList categoriesList = new ArrayList();
        if (cateCodes != null && cateCodes.size() > 0) {
            for (String cateCode : cateCodes) {
                List category = this.mcPcsSkuCategoryService.findByCodeAndRightLikeCode(cateCode);
                categoriesList.addAll(category);
            }
        }
        if (CollectionUtils.isNotEmpty(categoriesList)) {
            cateIds = new ArrayList(categoriesList.size());
            for (PcsSkuCategoryVO category : categoriesList) {
                cateIds.add(category.getId());
            }
        }
        LinkedHashMap sortMap = new LinkedHashMap();
        HashMap<String, Object> sMap = new HashMap<String, Object>();
        HashMap sMap2 = new HashMap();
        HashMap<String, String> sNestedMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>();
        HashMap slMap = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chnCode", chnCode);
        params.put("chnCanSaleSKu.chnCode", chnCode);
        params.put("chnCanSeeSKu.chnCode", chnCode);
        params.put("onShelfChnCodes", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            params.put("frontCategories.categoryId", cateIds);
        }
        sortMap.put("stocks.soldOut", sMap);
        sMap.put("order", "asc");
        sMap.put("mode", "min");
        sMap.put("nested_filter", sNestedMap);
        sNestedMap.put("stocks.chnCode", chnCode);
        if (CollectionUtils.isNotEmpty(cateIds)) {
            paramsMap.put("categoryIds", cateIds);
        }
        map.put("order", "asc");
        map.put("mode", "min");
        params.put("sort", sortMap);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            params.put("brandList.brandId", brandIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelIds)) {
            params.put("labels.labelId", labelIds);
        }
        selectMap.put("aggs", aggs);
        selectMap.put("isDiscount", 1);
        List<Long> ids = this.client.findByFieldWithAggsSortMap(params, SearchType.ANDLIKE, selectMap);
        sw.stop();
        LOGGER.info("\u3010\u5217\u8868\u7279\u6b8a\u5546\u54c1\u67e5\u8be2\u54c1\u724c\u6807\u7b7e\u63a5\u53e3\u8017\u65f6\u3011 {}", (Object)DurationFormatUtils.formatDurationHMS((long)sw.getTime()));
        return ids;
    }

    BigDecimal specialDiscount(PsProductVO psProductVO, PsMatchCampaignCond matchCampaignCond, BigDecimal discountAmount) {
        if (this.discountTime().booleanValue() && psProductVO.getIsDiscount() != null && psProductVO.getIsDiscount() == 1 && discountAmount.doubleValue() == NORMAL_DISCOUNT) {
            matchCampaignCond.setDiscount(SPECIAL_DISCOUNT);
            discountAmount = SPECIAL_DISCOUNT;
        }
        return discountAmount;
    }

    Boolean discountTime() {
        Date now;
        String time = "2017-08-01 00:00:00";
        Date startTime = DateUtil.parse((String)time, (String)"yyyy-MM-dd hh:mm:ss");
        return startTime.compareTo(now = new Date()) < 0;
    }

    static {
        PsCampaignVO specialCampaign = new PsCampaignVO();
        specialCampaign.setProductScopeId(Integer.valueOf(3));
        specialCampaign.setDiscountTypeId(Integer.valueOf(4));
        specialExcludeCampaignMap = McPsProductServiceImpl.getSpecialCampaignMap(Lists.newArrayList((Object[])new PsCampaignVO[]{specialCampaign}));
        ArrayList<Integer> accessWayIds = new ArrayList<Integer>(){
            {
                this.add(2);
            }
        };
        ArrayList<Integer> memberLevels = new ArrayList<Integer>(){
            {
                this.add(-1);
            }
        };
        PsCampaignVO appFirstGift1 = McPsProductServiceImpl.buildAppFirstGiftCampaign((List<Integer>)accessWayIds, (List<Integer>)memberLevels, 1016938L);
        memberLevels = new ArrayList<Integer>(){
            {
                this.add(0);
                this.add(1);
            }
        };
        PsCampaignVO appFirstGift2 = McPsProductServiceImpl.buildAppFirstGiftCampaign((List<Integer>)accessWayIds, (List<Integer>)memberLevels, 1018581L);
        memberLevels = new ArrayList<Integer>(){
            {
                this.add(2);
                this.add(3);
            }
        };
        PsCampaignVO appFirstGift3 = McPsProductServiceImpl.buildAppFirstGiftCampaign((List<Integer>)accessWayIds, (List<Integer>)memberLevels, 1018580L);
        appFirstGiftMap.put(1, appFirstGift1);
        appFirstGiftMap.put(2, appFirstGift2);
        appFirstGiftMap.put(3, appFirstGift3);
        flowerMonthDeliveryProductCodeList.add("PROD001018194");
        flowerMonthDeliveryProductCodeList.add("PROD001018196");
        flowerMonthDeliveryProductCodeList.add("PROD001018197");
    }
}

