/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsQualificationCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsQualificationDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsQualification;
import com.thebeastshop.pegasus.merchandise.service.McPcsQualificationService;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualificationVO;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/qualification")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsQualificationService")
public class McPcsQualificationServiceImpl
implements McPcsQualificationService {
    @Autowired
    private PcsQualificationDomain pcsQualificationDomain;

    @POST
    public Long create(PcsQualificationVO vo) {
        return this.pcsQualificationDomain.create(this.pcsQualificationDomain.buildFromVO(vo));
    }

    public List<Long> createPcsQualifications(List<PcsQualificationVO> list) {
        return this.createPcsQualifications(list, null);
    }

    public List<Long> createPcsQualifications(List<PcsQualificationVO> qualificationVOs, Long qualifyId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PcsQualificationVO vo : qualificationVOs) {
            if (qualifyId != null) {
                vo.setQualifyId(qualifyId);
            }
            ids.add(this.create(vo));
        }
        return ids;
    }

    @DELETE
    public int deleteById(Long id) {
        return this.pcsQualificationDomain.deleteByPrimaryKey(id);
    }

    @DELETE
    public Long deleteByQualifyId(Long qualifyId) {
        return this.pcsQualificationDomain.deleteByQualifyId(qualifyId);
    }

    @PUT
    public Boolean update(PcsQualificationVO vo) {
        return this.pcsQualificationDomain.update(this.pcsQualificationDomain.buildFromVO(vo));
    }

    @GET
    @Path(value="{id:\\d+}")
    public PcsQualificationVO findById(@PathParam(value="id") Long id) {
        PcsQualification record = this.pcsQualificationDomain.findById(id);
        PcsQualificationVO vo = this.pcsQualificationDomain.buildFromModel(record);
        return vo;
    }

    @GET
    @Path(value="{qualifyId:\\d+}")
    public List<PcsQualificationVO> findByQualifyId(@PathParam(value="qualifyId") Long qualifyId) {
        List<PcsQualification> recordList = this.pcsQualificationDomain.findByQualifyId(qualifyId);
        ArrayList<PcsQualificationVO> vos = new ArrayList<PcsQualificationVO>(recordList.size());
        for (PcsQualification record : recordList) {
            PcsQualificationVO vo = this.pcsQualificationDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsQualificationVO> findByCond(PcsQualificationCond cond) {
        List<PcsQualificationVO> recordList = this.pcsQualificationDomain.findByCond(cond);
        return recordList;
    }

    public List<PcsQualificationVO> findByCriteria(PcsQualificationCond cond) {
        List<PcsQualification> recordList = this.pcsQualificationDomain.findByCriteria(cond);
        ArrayList<PcsQualificationVO> vos = new ArrayList<PcsQualificationVO>(recordList.size());
        for (PcsQualification record : recordList) {
            PcsQualificationVO vo = this.pcsQualificationDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsQualificationVO> findByIds(List<Long> ids) {
        List<PcsQualification> recordList = this.pcsQualificationDomain.findByIds(ids);
        ArrayList<PcsQualificationVO> vos = new ArrayList<PcsQualificationVO>(recordList.size());
        for (PcsQualification record : recordList) {
            PcsQualificationVO vo = this.pcsQualificationDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @GET
    public long countByCond(PcsQualificationCond cond) {
        return this.pcsQualificationDomain.countByCond(cond);
    }
}

