/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsImportDocCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsImportDocDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsImportDoc;
import com.thebeastshop.pegasus.merchandise.service.McPcsImportDocService;
import com.thebeastshop.pegasus.merchandise.vo.PcsImportDocVO;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/importDoc")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsImportDocService")
public class McPcsImportDocServiceImpl
implements McPcsImportDocService {
    @Autowired
    private PcsImportDocDomain pcsImportDocDomain;

    @POST
    public Long create(PcsImportDocVO vo) {
        return this.pcsImportDocDomain.create(this.pcsImportDocDomain.buildFromVO(vo));
    }

    public List<Long> createPcsImportDocs(List<PcsImportDocVO> list) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PcsImportDocVO vo : list) {
            ids.add(this.create(vo));
        }
        return ids;
    }

    public boolean createPcsImportDocs(List<PcsImportDocVO> importDocVOs, Long qualifyId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PcsImportDocVO vo : importDocVOs) {
            vo.setQualifyId(qualifyId);
            ids.add(this.create(vo));
        }
        return ids.size() == importDocVOs.size();
    }

    @DELETE
    public int deleteById(Long id) {
        return this.pcsImportDocDomain.deleteByPrimaryKey(id);
    }

    @DELETE
    public Long deleteByQualifyId(Long qualifyId) {
        return this.pcsImportDocDomain.deleteByQualifyId(qualifyId);
    }

    @PUT
    public Boolean update(PcsImportDocVO vo) {
        return this.pcsImportDocDomain.update(this.pcsImportDocDomain.buildFromVO(vo));
    }

    @GET
    @Path(value="{id:\\d+}")
    public PcsImportDocVO findById(@PathParam(value="id") Long id) {
        PcsImportDoc record = this.pcsImportDocDomain.findById(id);
        PcsImportDocVO vo = this.pcsImportDocDomain.buildFromModel(record);
        return vo;
    }

    @GET
    @Path(value="{qualifyId:\\d+}")
    public List<PcsImportDocVO> findByQualifyId(@PathParam(value="qualifyId") Long qualifyId) {
        List<PcsImportDoc> recordList = this.pcsImportDocDomain.findByQualifyId(qualifyId);
        ArrayList<PcsImportDocVO> vos = new ArrayList<PcsImportDocVO>(recordList.size());
        for (PcsImportDoc record : recordList) {
            PcsImportDocVO vo = this.pcsImportDocDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsImportDocVO> findByCond(PcsImportDocCond cond) {
        List<PcsImportDocVO> recordList = this.pcsImportDocDomain.findByCond(cond);
        return recordList;
    }

    public List<PcsImportDocVO> findByCriteria(PcsImportDocCond cond) {
        List<PcsImportDoc> recordList = this.pcsImportDocDomain.findByCriteria(cond);
        ArrayList<PcsImportDocVO> vos = new ArrayList<PcsImportDocVO>(recordList.size());
        for (PcsImportDoc record : recordList) {
            PcsImportDocVO vo = this.pcsImportDocDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsImportDocVO> findByIds(List<Long> ids) {
        List<PcsImportDoc> recordList = this.pcsImportDocDomain.findByIds(ids);
        ArrayList<PcsImportDocVO> vos = new ArrayList<PcsImportDocVO>(recordList.size());
        for (PcsImportDoc record : recordList) {
            PcsImportDocVO vo = this.pcsImportDocDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @GET
    public long countByCond(PcsImportDocCond cond) {
        return this.pcsImportDocDomain.countByCond(cond);
    }
}

