/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.cond.PcsCustomizeElementCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeElementDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsCustomizeElement;
import com.thebeastshop.pegasus.merchandise.service.McPcsCustomizeElementService;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeColorVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeElementVO;
import com.thebeastshop.pegasus.merchandise.vo.SupportTypeVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcPcsCustomizeElementService")
public class McPcsCustomizeElementServiceImpl
implements McPcsCustomizeElementService {
    @Autowired
    private PcsCustomizeElementDomain pcsCustomizeElementDomain;

    public Long create(PcsCustomizeElementVO record) {
        return this.pcsCustomizeElementDomain.create((PcsCustomizeElement)this.pcsCustomizeElementDomain.buildFromVO(record));
    }

    public boolean update(PcsCustomizeElementVO record) {
        return this.pcsCustomizeElementDomain.update((PcsCustomizeElement)this.pcsCustomizeElementDomain.buildFromVO(record));
    }

    public List<PcsCustomizeElementVO> findByCode(String code) {
        return this.pcsCustomizeElementDomain.findByCode(code);
    }

    public List<PcsCustomizeElementVO> findByCond(PcsCustomizeElementCond cond) {
        List<PcsCustomizeElementVO> list = this.pcsCustomizeElementDomain.findByCond(cond);
        for (PcsCustomizeElementVO vo : list) {
            Integer type = vo.getElementType();
            ArrayList<PcsCustomizeColorVO> colorVOs = new ArrayList<PcsCustomizeColorVO>();
            String color = vo.getColor();
            List ListObj = (List)JSON.parseObject((String)color, List.class);
            if (CollectionUtils.isNotEmpty((Collection)ListObj)) {
                for (List listVO : ListObj) {
                    int colorListSize = listVO.size();
                    PcsCustomizeColorVO colorVO = new PcsCustomizeColorVO();
                    colorVO.setColorName((String)listVO.get(0));
                    colorVO.setColorValue((String)listVO.get(1));
                    if (colorListSize > 2) {
                        colorVO.setBackgroundColorValue((String)listVO.get(2));
                        colorVO.setWordColorValue((String)listVO.get(3));
                    }
                    colorVOs.add(colorVO);
                }
            }
            vo.setColorList(colorVOs);
            if (type == null || !"2".equals(type.toString())) continue;
            String supportType = vo.getSupportType();
            SupportTypeVO supportTypeVO = new SupportTypeVO();
            if (supportType.contains("1")) {
                supportTypeVO.setUppercaseLetter("1");
            }
            if (supportType.contains("0")) {
                supportTypeVO.setLowercaseLetter("1");
            }
            if (supportType.contains("2")) {
                supportTypeVO.setNumber("1");
            }
            if (supportType.contains("3")) {
                supportTypeVO.setExpression("1");
            }
            vo.setSupportTypeVO(supportTypeVO);
        }
        return list;
    }
}

