/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsCopywriterCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsCopywriterDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsCopywriter;
import com.thebeastshop.pegasus.merchandise.service.McPcsCopywriterService;
import com.thebeastshop.pegasus.merchandise.vo.PcsCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcPcsCopywriterService")
public class McPcsCopywriterServiceImpl
implements McPcsCopywriterService {
    private static Logger log = LoggerFactory.getLogger(McPcsCopywriterServiceImpl.class);
    @Autowired
    private PcsCopywriterDomain pcsCopywriterDomain;

    public Long addCopywriter(PcsCopywriterVO copywriterVO) {
        PcsCopywriter pcsCopywriter = (PcsCopywriter)BeanUtil.buildFrom((Object)copywriterVO, PcsCopywriter.class);
        this.pcsCopywriterDomain.addCopywriter(pcsCopywriter);
        return pcsCopywriter.getId();
    }

    public int updateCopywriter(PcsCopywriterVO copywriterVO) {
        return this.pcsCopywriterDomain.updateCopywriter(copywriterVO);
    }

    public int updateProdCopywriterByCodeList(ProdSkuVO prod, List<String> copywriterCodeList, boolean isEmptyBeforeUpdate) {
        return this.pcsCopywriterDomain.updateProdCopywriterByCodeList(prod, copywriterCodeList, isEmptyBeforeUpdate);
    }

    public PcsCopywriterVO findCopywriterById(Long id) {
        return this.pcsCopywriterDomain.findCopywriterById(id);
    }

    public List<ProdSkuVO> queryProdCopywriterList(PcsCopywriterCond cond) {
        return this.pcsCopywriterDomain.queryProdCopywriterList(cond);
    }

    public int deleteProdCopywriterByIds(List<String> idList) {
        return this.pcsCopywriterDomain.deleteProdCopywriterByIds(idList);
    }

    public List<PcsCopywriterVO> queryPcsCopywriterVOListByCond(PcsCopywriterCond cond) {
        return this.pcsCopywriterDomain.queryPcsCopywriterVOListByCond(cond);
    }

    public ProdSkuVO queryProductByProdCode(String prodCode) {
        return this.pcsCopywriterDomain.queryProductByProdCode(prodCode);
    }

    public void updateCopywriterValidStatus() {
        this.pcsCopywriterDomain.updateCopywriterValidStatus();
    }

    public Map<String, ProductCopywriterVO> selectProductCopywriterByProdCodes(List<String> codes) {
        return this.pcsCopywriterDomain.selectProductCopywriterByProdCodes(codes);
    }

    public void updateActiveCopywriter() {
        this.pcsCopywriterDomain.updateActiveFalseCopywriter();
        this.pcsCopywriterDomain.updateActiveTrueCopywriter();
    }

    public void updateValidStatus() {
        this.pcsCopywriterDomain.updateValidStatusPendingEffect();
        this.pcsCopywriterDomain.updateValidStatusAlreadyInForce();
        this.pcsCopywriterDomain.updateValidStatusExpired();
    }
}

