/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpChannelCond;
import com.thebeastshop.pegasus.merchandise.domain.OpChannelDomain;
import com.thebeastshop.pegasus.merchandise.model.OpChannel;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.vo.ChannelSelectorVO;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcOpChannelService")
public class McOpChannelServiceImpl
implements McOpChannelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(McOpChannelServiceImpl.class);
    @Autowired
    private OpChannelDomain opChannelDomain;

    public Long create(OpChannelVO channel) {
        this.opChannelDomain.create((OpChannel)this.opChannelDomain.buildFromVO(channel));
        return channel.getId();
    }

    public boolean update(OpChannelVO channel) {
        return this.opChannelDomain.update((OpChannel)this.opChannelDomain.buildFromVO(channel));
    }

    public boolean deleteById(Long id) {
        return this.opChannelDomain.deleteById(id);
    }

    public OpChannelVO findById(Long id) {
        OpChannel opChannel = this.opChannelDomain.findById(id);
        return (OpChannelVO)this.opChannelDomain.buildFromModel(opChannel);
    }

    public List<OpChannelVO> findChannelByCond(String cond) {
        List<OpChannel> list = this.opChannelDomain.findChannelByCond(cond);
        return BeanUtil.buildListFrom(list, OpChannelVO.class);
    }

    public List<OpChannelVO> findByCriteria(OpChannelCond cond) {
        List<OpChannel> list = this.opChannelDomain.findByCriteria(cond);
        return BeanUtil.buildListFrom(list, OpChannelVO.class);
    }

    public OpChannelVO findByCode(String code) {
        return (OpChannelVO)this.opChannelDomain.buildFromModel(this.opChannelDomain.findByCode(code));
    }

    public List<OpChannelVO> findAll() {
        return BeanUtil.buildListFrom(this.opChannelDomain.findAll(), OpChannelVO.class);
    }

    public List<OpChannelVO> selectAllFlowerShops() {
        return BeanUtil.buildListFrom(this.opChannelDomain.selectAllFlowerShops(), OpChannelVO.class);
    }

    public List<OpChannelVO> findChannelByType(int type) {
        return BeanUtil.buildListFrom(this.opChannelDomain.selectAllFlowerShops(), OpChannelVO.class);
    }

    public List<ChannelSelectorVO> findByChannelType(Integer type) {
        return BeanUtil.buildListFrom(this.opChannelDomain.findByChannelType(type), ChannelSelectorVO.class);
    }
}

