/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.pegasus.merchandise.IService.IRecommendService;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.impl.McPsProductServiceImpl;
import com.thebeastshop.pegasus.merchandise.vo.PsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.scm.dao.RecommendDao;
import com.thebeastshop.scm.dao.RecommendProductAutoDao;
import com.thebeastshop.scm.dao.RecommendProductDao;
import com.thebeastshop.scm.po.Recommend;
import com.thebeastshop.scm.po.RecommendProductAuto;
import com.thebeastshop.scm.vo.recommend.OrderFinishRecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendAutoListVO;
import com.thebeastshop.scm.vo.recommend.RecommendAutoProdSaveVO;
import com.thebeastshop.scm.vo.recommend.RecommendEditVO;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendSaveVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pers.richard.ormybatis.util.ObjUtils;

@Service
public class RecommendService
implements IRecommendService {
    private static final Logger log = LoggerFactory.getLogger(RecommendService.class);
    @Resource
    McPsProductServiceImpl mcPsProductService;
    @Resource
    RecommendDao recommendDao;
    @Resource
    RecommendProductDao recommendProductDao;
    @Resource
    RecommendProductAutoDao recommendProductAutoDao;
    private final String APP_CHANNEL_CODE = "CHN2049";

    public List<Recommend> list() {
        return this.recommendDao.findAll();
    }

    public void save(RecommendSaveVO vo) {
        Recommend recommend = vo.toRecommend();
        this.recommendDao.saveByPosition(recommend);
        this.recommendProductDao.save(vo.getProductCode(), recommend.getId());
    }

    public void saveAutoProd(RecommendAutoProdSaveVO vo) {
        List list = vo.toRecommendAutoProdList();
        this.recommendProductAutoDao.save(vo.getPosition(), vo.getSourceProductCode(), list);
    }

    public List<RecommendAutoListVO> autoList(RecommendProductAuto.Position Position2, RecommendProductAuto.Type type, String sourceProductCode) {
        List recommendProductAutoList = this.recommendProductAutoDao.autoList(Position2.toString(), type.toString(), sourceProductCode);
        ArrayList<RecommendAutoListVO> result = new ArrayList<RecommendAutoListVO>();
        for (RecommendProductAuto recommendProductAuto : recommendProductAutoList) {
            PsCategoryVO psCategoryVO;
            PsProductVO psProductVO = this.mcPsProductService.findProdByCode(recommendProductAuto.getRecommendProductCode());
            RecommendAutoListVO recommendAutoListVO = new RecommendAutoListVO();
            String brandNameCn = "";
            String categoryName = "";
            PsBrandVO psBrandVO = (PsBrandVO)ObjUtils.get((List)psProductVO.getBrands(), (int)0);
            if (psBrandVO != null) {
                brandNameCn = psBrandVO.getBrandNameCN();
            }
            if ((psCategoryVO = (PsCategoryVO)ObjUtils.get((List)psProductVO.getFrontCategories(), (int)0)) != null) {
                categoryName = psCategoryVO.getCategoryFullName();
            }
            recommendAutoListVO.setBrandNameCn(brandNameCn);
            recommendAutoListVO.setCategoryName(categoryName);
            recommendAutoListVO.setCode(psProductVO.getCode());
            recommendAutoListVO.setId(recommendProductAuto.getId());
            recommendAutoListVO.setNameCn(psProductVO.getNameCn());
            recommendAutoListVO.setSalesPrice(psProductVO.getListPrice());
            recommendAutoListVO.setSort(recommendProductAuto.getSort());
            recommendAutoListVO.setStatus(recommendProductAuto.getStatus());
            result.add(recommendAutoListVO);
        }
        return result;
    }

    public List<RecommendAutoListVO> addOnItemList(Integer pagenum) {
        List<PsProductVO> psProductVOList = this.mcPsProductService.addOnItemList(this.APP_CHANNEL_CODE, pagenum, null);
        return this.toRecommendAutoListVOByPsProductVOList(RecommendProductAuto.Position.ADD_ON_ITEM.toString(), null, psProductVOList);
    }

    public List<RecommendAutoListVO> prodDetailsList(String productCode) {
        List<PsProductVO> psProductVOList = this.prodDetailsPsProductVOList(this.APP_CHANNEL_CODE, productCode, 50, null);
        return this.toRecommendAutoListVOByPsProductVOList(RecommendProductAuto.Position.PROD_DETAIL.toString(), productCode, psProductVOList);
    }

    public RecommendEditVO edit(Integer recommendId) {
        Recommend recommend = (Recommend)this.recommendDao.selectOne((Number)recommendId);
        List list = this.recommendProductDao.getProductListMapByRecommendId(recommendId);
        return new RecommendEditVO(recommend, list);
    }

    public List<PsProductVO> getShoppingCartProcutList(RecommendParamVO paramVO) {
        log.info("\u63a8\u8350\u5546\u54c1 \u8d2d\u7269\u8f66\u5165\u53c2:{}", (Object)paramVO);
        String rule = this.recommendDao.getRuleByCart();
        List productCodeList = this.recommendProductDao.getProductCodeByCart(rule, Integer.valueOf(200));
        PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();
        psMatchCampaignCond.setAccessWay(paramVO.getAccessWay());
        psMatchCampaignCond.setMemberLevel(paramVO.getMemberLevel());
        psMatchCampaignCond.setDiscount(paramVO.getDiscount());
        psMatchCampaignCond.setBdDiscount(paramVO.getBdDiscount());
        psMatchCampaignCond.setMatchCampaign(Boolean.valueOf(true));
        List<PsProductVO> productVOs = this.mcPsProductService.findRecommondProdByCodes(paramVO.getChnCode(), productCodeList, psMatchCampaignCond, 1, 200);
        HashMap<String, PsProductVO> map = new HashMap<String, PsProductVO>();
        for (PsProductVO psProductVO : productVOs) {
            map.put(psProductVO.getCode(), psProductVO);
        }
        ArrayList<PsProductVO> result = new ArrayList<PsProductVO>();
        for (String code : productCodeList) {
            PsProductVO vo = (PsProductVO)map.get(code);
            if (vo == null) continue;
            result.add(vo);
        }
        int toIndex = result.size() < paramVO.getLimitSize() ? result.size() : paramVO.getLimitSize().intValue();
        return result.subList(0, toIndex);
    }

    public List<PsProductVO> autoRecommend(RecommendParamVO paramVO) {
        log.info("\u81ea\u52a8\u63a8\u8350\u5546\u54c1\u5165\u53c2:{}", (Object)paramVO);
        PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();
        psMatchCampaignCond.setAccessWay(paramVO.getAccessWay());
        psMatchCampaignCond.setMemberLevel(paramVO.getMemberLevel());
        psMatchCampaignCond.setDiscount(paramVO.getDiscount());
        psMatchCampaignCond.setBdDiscount(paramVO.getBdDiscount());
        psMatchCampaignCond.setMatchCampaign(Boolean.valueOf(true));
        Integer limitSize = paramVO.getLimitSize();
        ArrayList<PsProductVO> result = new ArrayList<PsProductVO>();
        List productCodes = this.recommendProductAutoDao.getProcutCodeByPosition(paramVO.getType().toString(), paramVO.getProductCode(), limitSize);
        if (CollectionUtils.isNotEmpty((Collection)productCodes)) {
            List<PsProductVO> productVOs = this.mcPsProductService.findRecommondProdByCodes(paramVO.getChnCode(), productCodes, psMatchCampaignCond, 1, limitSize);
            HashMap<String, PsProductVO> map = new HashMap<String, PsProductVO>();
            for (PsProductVO psProductVO : productVOs) {
                map.put(psProductVO.getCode(), psProductVO);
            }
            for (String code : productCodes) {
                PsProductVO vo = (PsProductVO)map.get(code);
                if (vo == null) continue;
                result.add(vo);
            }
        }
        if (result.size() < limitSize) {
            int pagenum = limitSize * 2;
            List<Object> psProductVOList = new ArrayList();
            psProductVOList = paramVO.getType().equals((Object)RecommendParamVO.Type.ADD_ON_ITEM) ? this.mcPsProductService.addOnItemList(paramVO.getChnCode(), pagenum, psMatchCampaignCond) : this.prodDetailsPsProductVOList(paramVO.getChnCode(), paramVO.getProductCode(), pagenum, psMatchCampaignCond);
            CopyOnWriteArrayList psProductVOCowList = new CopyOnWriteArrayList(psProductVOList);
            if (CollectionUtils.isEmpty(psProductVOCowList)) {
                return result;
            }
            List maskingProductCodes = this.recommendProductAutoDao.getMaskingProcutCodeByPosition(RecommendProductAuto.Position.PROD_DETAIL, paramVO.getProductCode());
            for (PsProductVO psProductVO : psProductVOCowList) {
                for (String maskingProductCode : maskingProductCodes) {
                    if (!psProductVO.getCode().equals(maskingProductCode)) continue;
                    psProductVOCowList.remove(psProductVO);
                }
                for (PsProductVO productVO : result) {
                    if (!psProductVO.getCode().equals(productVO.getCode())) continue;
                    psProductVOCowList.remove(psProductVO);
                }
            }
            result.addAll(psProductVOCowList);
        }
        int toIndex = result.size() < limitSize ? result.size() : limitSize.intValue();
        return result.subList(0, toIndex);
    }

    public List<PsProductVO> orderFinishRecommend(OrderFinishRecommendParamVO paramVO) {
        log.info("\u8ba2\u5355\u5b8c\u6210\u81ea\u52a8\u63a8\u8350\u5165\u53c2:{}", (Object)paramVO);
        PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();
        psMatchCampaignCond.setAccessWay(paramVO.getAccessWay());
        psMatchCampaignCond.setMemberLevel(paramVO.getMemberLevel());
        psMatchCampaignCond.setDiscount(paramVO.getDiscount());
        psMatchCampaignCond.setBdDiscount(paramVO.getBdDiscount());
        psMatchCampaignCond.setMatchCampaign(Boolean.valueOf(true));
        Integer limitSize = paramVO.getLimitSize();
        List productCodes = this.recommendProductAutoDao.getProcutCodesByProdDetail(paramVO.getProductCodes(), limitSize);
        List<PsProductVO> productVOs = this.mcPsProductService.findRecommondProdByCodes(paramVO.getChnCode(), productCodes, psMatchCampaignCond, 1, limitSize);
        HashMap<String, PsProductVO> map = new HashMap<String, PsProductVO>();
        for (PsProductVO psProductVO : productVOs) {
            map.put(psProductVO.getCode(), psProductVO);
        }
        CopyOnWriteArrayList<PsProductVO> result = new CopyOnWriteArrayList<PsProductVO>();
        for (String code : productCodes) {
            PsProductVO vo = (PsProductVO)map.get(code);
            if (vo == null) continue;
            result.add(vo);
        }
        if (result.size() < limitSize) {
            int pagenum = limitSize * 2;
            List<PsProductVO> psProductVOList = this.prodDetailsPsProductVOList(paramVO.getChnCode(), paramVO.getProductCodes(), pagenum, psMatchCampaignCond);
            CopyOnWriteArrayList<PsProductVO> psProductVOCowList = new CopyOnWriteArrayList<PsProductVO>(psProductVOList);
            if (CollectionUtils.isEmpty(psProductVOCowList)) {
                return result;
            }
            List maskingProductCodes = this.recommendProductAutoDao.getMaskingProcutCodesByProdDetail(paramVO.getProductCodes());
            for (PsProductVO psProductVO : psProductVOCowList) {
                for (String maskingProductCode : maskingProductCodes) {
                    if (!psProductVO.getCode().equals(maskingProductCode)) continue;
                    psProductVOCowList.remove(psProductVO);
                }
                for (PsProductVO productVO : result) {
                    if (!psProductVO.getCode().equals(productVO.getCode())) continue;
                    psProductVOCowList.remove(psProductVO);
                }
            }
            result.addAll(psProductVOCowList);
        }
        for (PsProductVO productVO : result) {
            for (String productCode : paramVO.getProductCodes()) {
                if (!productCode.equals(productVO.getCode())) continue;
                result.remove(productVO);
            }
        }
        int toIndex = result.size() < limitSize ? result.size() : limitSize.intValue();
        return result.subList(0, toIndex);
    }

    private List<RecommendAutoListVO> toRecommendAutoListVOByPsProductVOList(String position, String sourceProductCode, List<PsProductVO> psProductVOList) {
        ArrayList<RecommendAutoListVO> result = new ArrayList<RecommendAutoListVO>();
        ArrayList<String> productCodes = new ArrayList<String>();
        for (PsProductVO psProductVO : psProductVOList) {
            productCodes.add(psProductVO.getCode());
        }
        Map recommendProductAutoMap = this.recommendProductAutoDao.byRecommendProductCodes(position, sourceProductCode, productCodes);
        for (PsProductVO psProductVO : psProductVOList) {
            PsCategoryVO psCategoryVO;
            RecommendProductAuto recommendProductAuto = (RecommendProductAuto)recommendProductAutoMap.get(psProductVO.getCode());
            RecommendAutoListVO recommendAutoListVO = new RecommendAutoListVO();
            if (recommendProductAuto == null) {
                recommendAutoListVO.setStatus(Integer.valueOf(1));
            } else {
                recommendAutoListVO.setStatus(recommendProductAuto.getStatus());
                recommendAutoListVO.setSort(recommendProductAuto.getSort());
                if (recommendProductAuto.getSort() != null) continue;
            }
            String brandNameCn = "";
            String categoryName = "";
            PsBrandVO psBrandVO = (PsBrandVO)ObjUtils.get((List)psProductVO.getBrands(), (int)0);
            if (psBrandVO != null) {
                brandNameCn = psBrandVO.getBrandNameCN();
            }
            if ((psCategoryVO = (PsCategoryVO)ObjUtils.get((List)psProductVO.getFrontCategories(), (int)0)) != null) {
                categoryName = psCategoryVO.getCategoryFullName();
            }
            recommendAutoListVO.setBrandNameCn(brandNameCn);
            recommendAutoListVO.setCategoryName(categoryName);
            recommendAutoListVO.setCode(psProductVO.getCode());
            recommendAutoListVO.setNameCn(psProductVO.getNameCn());
            recommendAutoListVO.setSalesPrice(psProductVO.getListPrice());
            result.add(recommendAutoListVO);
        }
        return result;
    }

    private List<PsProductVO> prodDetailsPsProductVOList(String chnCode, String productCode, int pagenum, PsMatchCampaignCond matchCampaignCond) {
        PsCategoryVO psCategoryVO;
        PsProductVO productVO = this.mcPsProductService.findProdByCode(productCode);
        Long brandId = null;
        Long categoryId = null;
        PsBrandVO psBrandVO = (PsBrandVO)ObjUtils.get((List)productVO.getBrands(), (int)0);
        if (psBrandVO != null) {
            brandId = psBrandVO.getBrandId();
        }
        if ((psCategoryVO = (PsCategoryVO)ObjUtils.get((List)productVO.getFrontCategories(), (int)0)) != null) {
            categoryId = psCategoryVO.getCategoryId();
        }
        BigDecimal big03 = productVO.getListPrice().multiply(new BigDecimal(0.3));
        int startListPrices = productVO.getListPrice().subtract(big03).intValue();
        int endListPrice = productVO.getListPrice().add(big03).intValue();
        List<PsProductVO> psProductVOList = this.mcPsProductService.prodDetailsList(chnCode, brandId, categoryId, startListPrices, endListPrice, pagenum, matchCampaignCond);
        for (PsProductVO psProductVO : psProductVOList) {
            if (!productCode.equals(psProductVO.getCode())) continue;
            psProductVOList.remove(psProductVO);
            break;
        }
        return psProductVOList;
    }

    private List<PsProductVO> prodDetailsPsProductVOList(String chnCode, List<String> productCodes, int pagenum, PsMatchCampaignCond matchCampaignCond) {
        HashSet<PsProductVO> result = new HashSet<PsProductVO>();
        for (String productCode : productCodes) {
            List<PsProductVO> list = this.prodDetailsPsProductVOList(chnCode, productCode, pagenum, matchCampaignCond);
            result.addAll(list);
        }
        return new ArrayList<PsProductVO>(result);
    }

    public static void main(String[] args) {
        Collection psProductVOList = null;
        CopyOnWriteArrayList psProductVOCowList = new CopyOnWriteArrayList(psProductVOList);
    }
}

