/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.pegasus.merchandise.IService.IProdDiscountService;
import com.thebeastshop.pegasus.merchandise.cond.OpProdDiscountCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProdDiscountMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProductMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProductDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProdDiscount;
import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdDiscountSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdDiscountVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prodDiscountService")
public class ProdDiscountService
implements IProdDiscountService {
    private static final Logger logger = LoggerFactory.getLogger(ProdDiscountService.class);
    @Autowired
    private OpProdDiscountMapper mapper;
    @Autowired
    private OpProductMapper productMapper;
    @Autowired
    private OpProductDomain opProductDomain;
    private static final String MEMBER_LEVEL_ID = "2,3";
    private static final Float DISCOUNT = Float.valueOf(0.88f);

    public int addByProdId(Long prodId, Long operatorId, String operatorName) {
        if (prodId == null) {
            throw new RuntimeException("prodId must be not null");
        }
        if (operatorId == null) {
            throw new RuntimeException("operatorName must be not null");
        }
        if (operatorName == null) {
            throw new RuntimeException("operatorName must be not null");
        }
        OpProdDiscount record = new OpProdDiscount();
        record.setProductId(prodId);
        record.setMemberLevelId(MEMBER_LEVEL_ID);
        record.setDiscount(DISCOUNT);
        record.setOperatorId(operatorId);
        record.setOperatorName(operatorName);
        record.setOperateTime(new Date());
        record.setActive(1);
        return this.mapper.insert(record);
    }

    public int batchAddByProdId(List<Long> prodIds, Long operatorId, String operatorName) {
        if (CollectionUtils.isEmpty(prodIds)) {
            throw new RuntimeException("prodIds must be not null");
        }
        if (operatorId == null) {
            throw new RuntimeException("operatorId must be not null");
        }
        if (StringUtils.isBlank((String)operatorName)) {
            throw new RuntimeException("operatorNam must be not null");
        }
        ArrayList<OpProdDiscount> records = new ArrayList<OpProdDiscount>();
        for (Long prodId : prodIds) {
            OpProdDiscount record = new OpProdDiscount();
            record.setProductId(prodId);
            record.setMemberLevelId(MEMBER_LEVEL_ID);
            record.setDiscount(Float.valueOf(0.88f));
            record.setOperatorId(operatorId);
            record.setOperatorName(operatorName);
            record.setOperateTime(new Date());
            record.setActive(1);
            records.add(record);
        }
        return this.mapper.batchInsert(records);
    }

    public int add(String code, Long operatorId, String operatorName) {
        if (StringUtils.isBlank((String)code)) {
            throw new RuntimeException("code must be not null");
        }
        if (operatorId == null) {
            throw new RuntimeException("operatorId must be not null");
        }
        if (operatorName == null) {
            throw new RuntimeException("operatorName must be not null");
        }
        OpProduct product = this.productMapper.selectByCode(code);
        OpProdDiscount record = new OpProdDiscount();
        record.setProductId(product.getId());
        record.setMemberLevelId(MEMBER_LEVEL_ID);
        record.setDiscount(DISCOUNT);
        record.setOperatorId(operatorId);
        record.setOperatorName(operatorName);
        record.setOperateTime(new Date());
        record.setActive(1);
        return this.mapper.insert(record);
    }

    public int batchAdd(List<String> codes, Long operatorId, String operatorName) {
        List<OpProduct> products;
        if (CollectionUtils.isEmpty(codes)) {
            throw new RuntimeException("codes must be not null");
        }
        if (operatorId == null) {
            throw new RuntimeException("operatorId must be not null");
        }
        if (operatorName == null) {
            throw new RuntimeException("operatorName must be not null");
        }
        ArrayList<OpProdDiscount> records = new ArrayList<OpProdDiscount>();
        try {
            products = this.mapper.selectProdByCodes(codes);
        }
        catch (Exception e) {
            logger.error("batchAdd-->selectProdByCodes\u9519\u8bef{}", (Throwable)e);
            throw e;
        }
        Date now = new Date();
        for (OpProduct product : products) {
            OpProdDiscount record = new OpProdDiscount();
            record.setProductId(product.getId());
            record.setMemberLevelId(MEMBER_LEVEL_ID);
            record.setDiscount(Float.valueOf(0.88f));
            record.setOperatorId(operatorId);
            record.setOperatorName(operatorName);
            record.setOperateTime(now);
            record.setActive(1);
            records.add(record);
        }
        return CollectionUtils.isNotEmpty(records) ? this.mapper.batchInsert(records) : -1;
    }

    public boolean checkProdCode(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RuntimeException("code must be not null");
        }
        return this.productMapper.selectByCode(code) != null;
    }

    public List<String> checkProdCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            throw new RuntimeException("codes must be not null");
        }
        return this.mapper.checkProdByCodes(codes);
    }

    public List<Long> checkExistProdIds(List<Long> productIds) {
        if (CollectionUtils.isEmpty(productIds)) {
            throw new RuntimeException("productIds must be not null");
        }
        return this.mapper.checkExistProdIds(productIds);
    }

    public List<ProdDiscountVO> queryProdByCodes(List<String> codes) {
        List<Map<String, Object>> prodList;
        if (CollectionUtils.isEmpty(codes)) {
            throw new RuntimeException("codes must be not null");
        }
        try {
            prodList = this.mapper.queryProdByCodes(codes);
        }
        catch (Exception e) {
            logger.error("queryProdByCodes-->queryProdByCodes\u9519\u8bef{}", (Throwable)e);
            throw e;
        }
        ArrayList<ProdDiscountVO> vos = new ArrayList<ProdDiscountVO>();
        for (Map<String, Object> prod : prodList) {
            ProdDiscountVO vo = new ProdDiscountVO();
            vo.setProdId(Long.valueOf(((Integer)prod.get("prodId")).longValue()));
            vo.setProdName((String)prod.get("prodName"));
            String prodCode = (String)prod.get("prodCode");
            vo.setProdCode(prodCode);
            vo.setSkuVOs(this.getSkuList(prodCode));
            vos.add(vo);
        }
        return vos;
    }

    public int deleteByProdCode(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RuntimeException("code must be not null");
        }
        return this.mapper.deleteByProCode(code);
    }

    public int deleteByProdCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            throw new RuntimeException("codes must be not null");
        }
        return this.mapper.batchDeleteByProCodes(codes);
    }

    public List<ProdDiscountVO> queryByCond(OpProdDiscountCond cond) {
        List<ProdDiscountVO> vos;
        try {
            vos = this.mapper.queryByCond(cond);
        }
        catch (Exception e) {
            logger.error("queryByCond-->queryByCond\u51fa\u9519,{}", (Throwable)e);
            throw e;
        }
        for (ProdDiscountVO vo : vos) {
            vo.setSkuVOs(this.getSkuList(vo.getProdCode()));
        }
        return vos;
    }

    public int deleteById(Long id) {
        if (id == null) {
            throw new RuntimeException("id must be not null");
        }
        return this.mapper.deleteById(id);
    }

    public int deleteByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("ids must be not null");
        }
        return this.mapper.deleteByIds(ids);
    }

    public List<ProdDiscountVO> queryByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("ids must be not null");
        }
        List<ProdDiscountVO> vos = this.mapper.queryProdByIds(ids);
        for (ProdDiscountVO vo : vos) {
            String prodCode = vo.getProdCode();
            vo.setSkuVOs(this.getSkuList(prodCode));
        }
        return vos;
    }

    public List<ProdDiscountVO> queryAllProd() {
        List<ProdDiscountVO> skuList = this.mapper.queryAllProd();
        return skuList;
    }

    private List<ProdDiscountSkuVO> getSkuList(String prodCode) {
        List<Object> opSkus = new LinkedList();
        try {
            opSkus = this.opProductDomain.getSkuListByProductCode(prodCode);
        }
        catch (Exception e) {
            logger.error("getSkuList-->getSkuListByProductCode\u9519\u8bef{}", (Throwable)e);
        }
        LinkedList<ProdDiscountSkuVO> skuList = new LinkedList<ProdDiscountSkuVO>();
        for (PcsSkuVO pcsSkuVO : opSkus) {
            ProdDiscountSkuVO sku = new ProdDiscountSkuVO();
            sku.setSkuCode(pcsSkuVO.getCode());
            sku.setSkuName(pcsSkuVO.getNameCn());
            skuList.add(sku);
        }
        return skuList;
    }
}

