/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.thebeastshop.member.point.constant.MemberPointConstant;
import com.thebeastshop.member.point.cron.MemberCommonPointCron;
import com.thebeastshop.member.point.exception.ArgumentException;
import com.thebeastshop.member.point.service.MemberPointService;
import com.thebeastshop.member.point.vo.MemberResponseVO;
import com.thebeastshop.pegasus.component.coupon.client.CouponClient;
import com.thebeastshop.pegasus.component.coupon.vo.SendCouponUserVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.merchandise.IService.ILotteryActivityService;
import com.thebeastshop.pegasus.merchandise.service.InterestGoodsService;
import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.scm.dao.InterestGoodsSkuDao;
import com.thebeastshop.scm.dao.LotteryActivityAwardDao;
import com.thebeastshop.scm.dao.LotteryActivityAwardTypeDao;
import com.thebeastshop.scm.dao.LotteryActivityDao;
import com.thebeastshop.scm.dao.LotteryActivityManageLogDao;
import com.thebeastshop.scm.dao.LotteryActivityPrizeDao;
import com.thebeastshop.scm.dao.LotteryActivityPrizeRecordDao;
import com.thebeastshop.scm.dao.MemberDao;
import com.thebeastshop.scm.po.LotteryActivity;
import com.thebeastshop.scm.po.LotteryActivityAward;
import com.thebeastshop.scm.po.LotteryActivityManageLog;
import com.thebeastshop.scm.po.LotteryActivityPrize;
import com.thebeastshop.scm.po.LotteryActivityPrizeRecord;
import com.thebeastshop.scm.po.Member;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import com.thebeastshop.scm.vo.lottery.DrawResultException;
import com.thebeastshop.scm.vo.lottery.LotteryActivityAwardEditVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityDrawParamVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityDrawResultVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityEditVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityRecordVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivitySaveVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pers.richard.ormybatis.domain.po.IdPo;
import pers.richard.ormybatis.util.ObjUtils;

@Service
public class LotteryActivityService
implements ILotteryActivityService {
    protected static final Logger log = LoggerFactory.getLogger(LotteryActivityService.class);
    @Resource
    private MemberDao memberDao;
    @Resource
    private LotteryActivityDao lotteryActivityDao;
    @Resource
    private LotteryActivityAwardDao lotteryActivityAwardDao;
    @Resource
    private LotteryActivityAwardTypeDao lotteryActivityAwardTypeDao;
    @Resource
    private LotteryActivityPrizeDao lotteryActivityPrizeDao;
    @Resource
    private LotteryActivityPrizeRecordDao lotteryActivityPrizeRecordDao;
    @Resource
    private LotteryActivityManageLogDao lotteryActivityManageLogDao;
    @Resource
    private InterestGoodsSkuDao interestGoodsSkuDao;
    @Resource
    private MemberPointService memberPointService;
    @Resource
    private InterestGoodsService interestGoodsService;
    private static Hashtable<String, Boolean> hashtable = new Hashtable();
    @Autowired
    private CouponClient couponClient;

    public List<LotteryActivity> findAll() {
        log.info("\u67e5\u6240\u6709\u7684\u62bd\u5956\u6d3b\u52a8\u5217\u8868");
        return this.lotteryActivityDao.findAll();
    }

    public List<Map> winListByAwardId(Integer awardId) {
        List list = this.lotteryActivityPrizeRecordDao.winListByAwardId(awardId);
        for (Map map : list) {
            int title = MapUtils.getIntValue((Map)map, (Object)"title");
            String titleName = "";
            if (title == 1) {
                titleName = "\u5148\u751f";
            } else if (title == 2) {
                titleName = "\u5973\u58eb";
            } else if (title == 3) {
                titleName = "\u5c0f\u59d0";
            } else if (title == 4 && title == 0) {
                titleName = "\u4fdd\u5bc6";
            }
            map.put("titleName", titleName);
        }
        return list;
    }

    public void save(LotteryActivitySaveVO vo) {
        LotteryActivity lotteryActivity = vo.toLotteryActivity();
        log.info("\u4fdd\u5b58\u62bd\u5956\u6d3b\u52a8 LotteryActivitySaveVO:{}", (Object)vo);
        this.lotteryActivityDao.insertOrUpdate((IdPo)lotteryActivity);
        List lotteryActivityAwardList = vo.toLotteryActivityAwardList(lotteryActivity.getId());
        this.lotteryActivityAwardDao.batchSave(lotteryActivityAwardList);
        for (int i = 0; i < lotteryActivityAwardList.size(); ++i) {
            LotteryActivityAward lotteryActivityAward = (LotteryActivityAward)lotteryActivityAwardList.get(i);
            log.info("\u4fdd\u5b58\u62bd\u5956\u6d3b\u52a8\u7684\u5956\u9879\u8868:{}", (Object)lotteryActivityAward);
            Integer lotteryActivityAwardId = lotteryActivityAward.getId();
            LotteryActivityPrize lotteryActivityPrize = vo.toLotteryActivityPrize(lotteryActivityAwardId, i);
            this.lotteryActivityPrizeDao.deleteByAwardId(lotteryActivityAwardId);
            this.lotteryActivityPrizeDao.insertOrUpdate((IdPo)lotteryActivityPrize);
        }
        this.saveLog(lotteryActivity, lotteryActivityAwardList, vo);
    }

    public LotteryActivityEditVO byLotteryActivityId(Integer lotteryActivityId) {
        LotteryActivity lotteryActivity = (LotteryActivity)this.lotteryActivityDao.selectOne((Number)lotteryActivityId);
        List lotteryActivityAwardEditVOList = this.lotteryActivityAwardDao.getLotteryActivityAwardEditVOByLotteryActivityId(lotteryActivityId);
        for (LotteryActivityAwardEditVO lotteryActivityAwardEditVO : lotteryActivityAwardEditVOList) {
            if (!LotteryActivityPrize.Type.PRODUCT.toString().equals(lotteryActivityAwardEditVO.getPrizeType())) continue;
            int InterestId = NumberUtils.toInt((String)lotteryActivityAwardEditVO.getPrizeTypeNum());
            int totalSkuQuantity = this.interestGoodsSkuDao.sumQuantityByInterestId(Integer.valueOf(InterestId));
            lotteryActivityAwardEditVO.setAwardQuantity(Integer.valueOf(totalSkuQuantity));
        }
        return new LotteryActivityEditVO(lotteryActivity, lotteryActivityAwardEditVOList);
    }

    public List<LotteryActivityRecordVO> winList(Integer memberId, Integer lotteryActivityId) {
        return this.lotteryActivityPrizeRecordDao.getWinByMemberIdAndLotteryActivityId(memberId, lotteryActivityId);
    }

    public LotteryActivityRecordVO byLotteryActivityPrizeRecordId(Integer lotteryActivityPrizeRecordId) {
        return this.lotteryActivityPrizeRecordDao.getLotteryActivityRecordVOById(lotteryActivityPrizeRecordId);
    }

    public List<LotteryActivityRecordVO> queryLastWinRecord(Integer limit) {
        List recordList = this.lotteryActivityPrizeRecordDao.lastNewest(limit);
        return recordList;
    }

    public LotteryActivityDrawResultVO drawLottery(LotteryActivityDrawParamVO paramVO) {
        log.info("\u62bd\u5956\u53c2\u6570:{}", (Object)paramVO);
        Integer memberId = paramVO.getMemberId();
        Integer lotteryActivityId = paramVO.getLotteryActivityId();
        String sysId = paramVO.getSysId();
        try {
            LotteryActivityPrizeRecord lotteryActivityPrizeRecord;
            LotteryActivityRecordVO recordVO;
            boolean isSuccess;
            int random;
            List<LotteryActivityAward> lotteryActivityAwardList;
            LotteryActivityAward lotteryActivityAward;
            DrawResultException drawResultException;
            if (paramVO.getIsCheck().booleanValue() && (drawResultException = this.checkDrawLottery(memberId, lotteryActivityId, sysId)) != null) {
                return LotteryActivityDrawResultVO.newInstanceFail((DrawResultException)drawResultException);
            }
            LotteryActivity lotteryActivity = (LotteryActivity)this.lotteryActivityDao.selectOne((Number)lotteryActivityId);
            Member member = (Member)this.memberDao.selectOne((Number)memberId);
            if (lotteryActivity.getConsumePoint() > 0) {
                MemberCommonPointCron subtractionMemberCommonPointCron = new MemberCommonPointCron();
                subtractionMemberCommonPointCron.setMemberCode(member.getCode());
                subtractionMemberCommonPointCron.setMemberId(Long.valueOf(member.getId().longValue()));
                subtractionMemberCommonPointCron.setMemberPointType(MemberPointConstant.Pont_Type_Id.TYPE_LUCK_ACTIVITY_SUB);
                subtractionMemberCommonPointCron.setPoint(new BigDecimal(lotteryActivity.getConsumePoint()));
                MemberResponseVO responseVO = this.memberPointService.subtractionMemberCommonPoint(subtractionMemberCommonPointCron);
                if (responseVO.getMeta().getErrno() != 0) {
                    return LotteryActivityDrawResultVO.newInstanceFail((DrawResultException)DrawResultException.POINT_INTERFACE_ERROR);
                }
            }
            if ((lotteryActivityAward = (LotteryActivityAward)ObjUtils.get(lotteryActivityAwardList = this.createLotteryList(lotteryActivityId), (int)(random = RandomUtils.nextInt((int)0, (int)100)))) != null && !(isSuccess = this.lotteryActivityAwardDao.updateStock(lotteryActivityAward.getId()))) {
                lotteryActivityAward = null;
            }
            InterestGoodsGetVO interestGoodsGetVO = null;
            if (lotteryActivityAward != null) {
                Long cstpId;
                ApiResult result;
                LotteryActivityPrize lotteryActivityPrize = this.lotteryActivityPrizeDao.byAwardId(lotteryActivityAward.getId());
                String type = lotteryActivityPrize.getType();
                String typeNum = lotteryActivityPrize.getTypeNum();
                if (LotteryActivityPrize.Type.COUPON.toString().equals(type)) {
                    SendCouponUserVO sendCouponUserVO = new SendCouponUserVO();
                    sendCouponUserVO.setCouponSampleId(Long.valueOf(NumberUtils.toLong((String)typeNum)));
                    sendCouponUserVO.setMemberIds(Arrays.asList(memberId.longValue()));
                    ApiResult apiResult = this.couponClient.sendCouponUsers(sendCouponUserVO);
                    if (apiResult.getData() == null) {
                        lotteryActivityAward = null;
                    }
                } else if (LotteryActivityPrize.Type.POINT.toString().equals(type)) {
                    MemberCommonPointCron memberCommonPointCron = new MemberCommonPointCron();
                    memberCommonPointCron.setMemberCode(member.getCode());
                    memberCommonPointCron.setMemberId(Long.valueOf(member.getId().longValue()));
                    memberCommonPointCron.setMemberPointType(MemberPointConstant.Pont_Type_Id.TYPE_LUCK_ACTIVITY_ADD);
                    memberCommonPointCron.setPoint(new BigDecimal(typeNum));
                    boolean bool = this.memberPointService.addMemberCommonPoint(memberCommonPointCron);
                    if (!bool) {
                        lotteryActivityAward = null;
                    }
                } else if (LotteryActivityPrize.Type.PRODUCT.toString().equals(type)) {
                    Integer interestId = NumberUtils.toInt((String)lotteryActivityPrize.getTypeNum());
                    interestGoodsGetVO = this.interestGoodsService.getInterestGoods(memberId, interestId);
                } else if (LotteryActivityPrize.Type.COUPON_THIRD.toString().equals(type) && (result = this.couponClient.exchangeToMember(cstpId = Long.valueOf(NumberUtils.toLong((String)typeNum)), Long.valueOf(memberId.longValue()))).getData() == null && !((Boolean)result.getData()).booleanValue()) {
                    lotteryActivityAward = null;
                }
            }
            if ((recordVO = this.lotteryActivityPrizeRecordDao.getLotteryActivityRecordVOById((lotteryActivityPrizeRecord = this.lotteryActivityPrizeRecordDao.save(memberId, lotteryActivityId, lotteryActivityAward, sysId)).getId())) == null) {
                return LotteryActivityDrawResultVO.newInstanceSuccess(null);
            }
            recordVO.setInterestGoodsGetVO(interestGoodsGetVO);
            return LotteryActivityDrawResultVO.newInstanceSuccess((LotteryActivityRecordVO)recordVO);
        }
        catch (ArgumentException e) {
            log.info(null, (Throwable)e);
            return LotteryActivityDrawResultVO.newInstanceFail((DrawResultException)DrawResultException.POINT_INTERFACE_ERROR);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return LotteryActivityDrawResultVO.newInstanceFail((DrawResultException)DrawResultException.ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawResultException checkDrawLottery(Integer memberId, Integer lotteryActivityId, String sysId) {
        log.info("\u8bf7\u6c42memberid:{} sysId:{}", (Object)memberId, (Object)sysId);
        String key = memberId + "_" + System.currentTimeMillis() / 2000L;
        Class<LotteryActivityService> clazz = LotteryActivityService.class;
        synchronized (LotteryActivityService.class) {
            Integer sysIdCount;
            Integer dayCount;
            Member member;
            if (hashtable.get(key) != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return DrawResultException.FREQUENCY_REQUEST;
            }
            hashtable.put(key, true);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (hashtable.size() > 1000) {
                hashtable.clear();
            }
            if ((member = (Member)this.memberDao.selectOne((Number)memberId)) == null) {
                return DrawResultException.MEMBER_NOT_FOUND;
            }
            LotteryActivity lotteryActivity = (LotteryActivity)this.lotteryActivityDao.selectOne((Number)lotteryActivityId);
            if (lotteryActivity == null) {
                return DrawResultException.ACTIVITY_ERROR;
            }
            if (lotteryActivity.getStartTime().after(DateUtils.getCurrentDateYMD())) {
                return DrawResultException.ACTIVITY_ERROR;
            }
            if (lotteryActivity.getEndTime().before(DateUtils.getCurrentDateYMD())) {
                return DrawResultException.ACTIVITY_ERROR;
            }
            String limitType = StringUtils.trim((String)lotteryActivity.getLimitType());
            Integer limitNum = lotteryActivity.getLimitNum();
            if (LotteryActivity.LimitType.DAY.toString().equals(limitType) ? (dayCount = this.lotteryActivityPrizeRecordDao.getDayCountByMemberIdAndLotteryActivityId(memberId, lotteryActivityId)) >= limitNum : StringUtils.equalsIgnoreCase((CharSequence)LotteryActivity.LimitType.SYS_ID.toString(), (CharSequence)limitType) && (sysIdCount = this.lotteryActivityPrizeRecordDao.bySysId(memberId, lotteryActivityId, sysId)) >= limitNum) {
                return DrawResultException.NO_CHANCE;
            }
            if (lotteryActivity.getConsumePoint() > 0) {
                BigDecimal memberPoint = this.memberPointService.findCommonValidMemberLevelByparam(Long.valueOf(memberId.longValue()), member.getCode());
                if (new BigDecimal(lotteryActivity.getConsumePoint()).compareTo(memberPoint) == 1) {
                    return DrawResultException.POINT_NOT_ENOUGH;
                }
            }
            return null;
        }
    }

    private List<LotteryActivityAward> createLotteryList(Integer lotteryActivityId) {
        ArrayList<LotteryActivityAward> result = new ArrayList<LotteryActivityAward>();
        List awardList = this.lotteryActivityAwardDao.byLotteryActivityIdAndStock(lotteryActivityId);
        for (LotteryActivityAward lotteryActivityAward : awardList) {
            for (int i = 0; i < lotteryActivityAward.getOdds(); ++i) {
                result.add(lotteryActivityAward);
            }
        }
        if (result.size() < 100) {
            int size = 100 - result.size();
            for (int i = 0; i < size; ++i) {
                result.add(null);
            }
        }
        return result;
    }

    private void saveLog(LotteryActivity lotteryActivity, List<LotteryActivityAward> lotteryActivityAwardList, LotteryActivitySaveVO vo) {
        Map lotteryActivityMap = lotteryActivity.toMap();
        lotteryActivityMap.remove("updateTime");
        ArrayList<Map> lotteryActivityAwardMapList = new ArrayList<Map>();
        for (LotteryActivityAward lotteryActivityAward : lotteryActivityAwardList) {
            Map lotteryActivityAwardMap = lotteryActivityAward.toMap();
            lotteryActivityAwardMap.remove("lotteryActivityId");
            lotteryActivityAwardMap.remove("winQuantity");
            lotteryActivityAwardMap.remove("version");
            lotteryActivityAwardMap.put("prizeList", this.lotteryActivityPrizeDao.byAwardId(lotteryActivityAward.getId()).toMap());
            lotteryActivityAwardMapList.add(lotteryActivityAwardMap);
        }
        lotteryActivityMap.put("award", lotteryActivityAwardMapList);
        LotteryActivityManageLog lotteryActivityManageLog = new LotteryActivityManageLog();
        lotteryActivityManageLog.setCreateTime(new Date());
        lotteryActivityManageLog.setCreateUserId(vo.getOperatorId());
        lotteryActivityManageLog.setCreateUserName(vo.getOperatorName());
        lotteryActivityManageLog.setLotteryActivityId(lotteryActivity.getId());
        lotteryActivityManageLog.setUpdateContent(JSONObject.toJSONString((Object)lotteryActivityMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        this.lotteryActivityManageLogDao.insert((IdPo)lotteryActivityManageLog);
    }
}

