/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.merchandise.IService.IInterestGoodsService;
import com.thebeastshop.pegasus.merchandise.exception.InterestException;
import com.thebeastshop.pegasus.merchandise.exception.InterestExceptionEnum;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.scm.cond.InterestGoodsCond;
import com.thebeastshop.scm.dao.InterestGoodsDao;
import com.thebeastshop.scm.dao.InterestGoodsProvideDao;
import com.thebeastshop.scm.dao.InterestGoodsSkuDao;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.scm.po.InterestGoodsProvide;
import com.thebeastshop.scm.po.InterestGoodsSku;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsProvideVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSaveVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsVO;
import com.thebeastshop.support.enums.CartPackSource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import pers.richard.ormybatis.domain.po.IdPo;

@Service
public class InterestGoodsService
implements IInterestGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(InterestGoodsService.class);
    @Resource
    private InterestGoodsDao interestGoodsDao;
    @Resource
    private InterestGoodsSkuDao interestGoodsSkuDao;
    @Resource
    private InterestGoodsProvideDao interestGoodsProvideDao;
    @Resource
    private CartService cartService;
    @Resource
    McPsProductService mcPsProductService;

    public List<Map> list(InterestGoodsCond cond) {
        return this.interestGoodsDao.list(cond);
    }

    public InterestGoods selectInterestById(Integer interestGoodsId) {
        return (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
    }

    public InterestGoodsVO selectInterestGoodsSku(Integer interestGoodsId) {
        InterestGoods interestGoods = (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
        List interestGoodsSkuList = this.interestGoodsSkuDao.byInterestGoodsId(interestGoodsId);
        return new InterestGoodsVO(interestGoods, interestGoodsSkuList);
    }

    public int sumQuantityByInterestId(Integer interestGoodsId) {
        return this.interestGoodsSkuDao.sumQuantityByInterestId(interestGoodsId);
    }

    @Transactional(value="scmDataSourceTx")
    public Integer save(InterestGoodsSaveVO vo) {
        InterestGoods interestGoods = vo.toInterestGoods();
        int res = this.interestGoodsDao.insertOrUpdate((IdPo)interestGoods);
        if (res != 1) {
            throw new InterestException(InterestExceptionEnum.ERROR_SAVE_INTEREST);
        }
        List interestGoodsSkuList = vo.toInterestGoodsSku(interestGoods.getId());
        for (InterestGoodsSku interestGoodsSku : interestGoodsSkuList) {
            res = this.interestGoodsSkuDao.insertOrUpdate((IdPo)interestGoodsSku);
            if (res == 1) continue;
            throw new InterestException(InterestExceptionEnum.ERROR_SAVE_INTEREST_SKU);
        }
        return interestGoods.getId();
    }

    @Transactional(value="scmDataSourceTx")
    public void delete(int interestGoodsId) {
        int res = this.interestGoodsDao.delete(new Number[]{interestGoodsId});
        if (res == 0) {
            throw new InterestException(InterestExceptionEnum.ERROR_DELETE_INTEREST);
        }
        res = this.interestGoodsSkuDao.deleteByInterestGoodsId(interestGoodsId);
        if (res == 0) {
            throw new InterestException(InterestExceptionEnum.ERROR_DELETE_INTEREST_SKU);
        }
    }

    public List<InterestGoodsProvideVO> getProvideRecord(InterestGoodsCond cond) {
        return this.interestGoodsProvideDao.queryProvideRecord(cond);
    }

    @Transactional(value="scmDataSourceTx")
    public InterestGoodsGetVO getInterestGoods(Integer memberId, Integer interestGoodsId) {
        logger.info("getInterestGoods param member:{},interestGoodsId:{}", (Object)memberId, (Object)interestGoodsId);
        if (memberId == null || interestGoodsId == null) {
            throw new InterestException(InterestExceptionEnum.ERROR_PARAM_MISS);
        }
        InterestGoods interestGoods = (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
        if (interestGoods == null) {
            logger.error(InterestExceptionEnum.ERROR_NOT_FOUND.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_NOT_FOUND);
        }
        if (interestGoods.getReceiptStartTime().after(DateUtils.getCurrentDate()) || interestGoods.getReceiptEndTime().before(DateUtils.getCurrentDate())) {
            throw new InterestException(InterestExceptionEnum.ERROR_RECEIVE_SPOCE);
        }
        InterestGoodsSku interestGoodsSku = this.interestGoodsSkuDao.getInStockByInterestGoodsId(interestGoodsId);
        if (interestGoodsSku == null) {
            logger.error(InterestExceptionEnum.ERROR_SKU_NO_STOCK.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_SKU_NO_STOCK);
        }
        boolean isSuccess = this.interestGoodsSkuDao.addReceiveQuantity(interestGoodsSku.getId());
        if (!isSuccess) {
            logger.error(InterestExceptionEnum.ERROR_UPDATE_RECEIVE.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_RECEIVE);
        }
        int res = this.interestGoodsProvideDao.save(memberId, interestGoodsId, interestGoodsSku.getId());
        if (res != 1) {
            logger.error(InterestExceptionEnum.ERROR_PROVIDE_INTEREST.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_PROVIDE_INTEREST);
        }
        InterestGoodsGetVO interestGoodsGetVO = new InterestGoodsGetVO(interestGoods, interestGoodsSku);
        logger.info("getInterestGoods success:{}", (Object)interestGoodsGetVO.toString());
        return interestGoodsGetVO;
    }

    @Transactional(value="scmDataSourceTx")
    public void cash(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        logger.info("interestGoods cash member:{},skuList:{}", (Object)memberId, (Object)interestGoodsSkuVOList.toString());
        if (ObjectUtils.isEmpty((Object)memberId) || CollectionUtils.isEmpty(interestGoodsSkuVOList)) {
            throw new InterestException(InterestExceptionEnum.ERROR_PARAM_NULL);
        }
        InterestGoods interestGoods = null;
        for (InterestGoodsSkuVO interestGoodsSkuVO : interestGoodsSkuVOList) {
            String skuCode;
            if (ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getCashQuantity()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getInterestGoodsId()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getSkuCode())) {
                throw new InterestException(InterestExceptionEnum.ERROR_PARAM_MISS);
            }
            Integer interestGoodsId = interestGoodsSkuVO.getInterestGoodsId();
            InterestGoodsSku interestGoodsSku = this.interestGoodsSkuDao.getInterestGoodsSku(interestGoodsId, skuCode = interestGoodsSkuVO.getSkuCode());
            if (ObjectUtils.isEmpty((Object)interestGoodsSku)) {
                throw new InterestException(InterestExceptionEnum.ERROR_NOT_FOUND);
            }
            interestGoods = (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
            if (interestGoods.getCashStartTime().after(DateUtils.getCurrentDate()) || interestGoods.getCashEndTime().before(DateUtils.getCurrentDate())) {
                throw new InterestException(InterestExceptionEnum.ERROR_CASH_SPOCE);
            }
            int unCashQuantity = this.interestGoodsProvideDao.countCashQuantity(memberId, interestGoodsId, interestGoodsSku.getId(), true);
            if (interestGoodsSkuVO.getCashQuantity() > unCashQuantity) {
                throw new InterestException(InterestExceptionEnum.ERROR_CASH_EXCESS);
            }
            interestGoodsSkuVO.setInterestGoodsSkuId(interestGoodsSku.getId());
        }
        if (!this.interestGoodsSkuDao.updateCash(interestGoodsSkuVOList)) {
            logger.error(InterestExceptionEnum.ERROR_UPDATE_EXCESS.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_EXCESS);
        }
        if (!this.interestGoodsProvideDao.updateCash(memberId, interestGoodsSkuVOList)) {
            logger.error(InterestExceptionEnum.ERROR_UPDATE_STATUS.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_STATUS);
        }
        logger.info("member:{} cash success ", (Object)memberId);
    }

    @Transactional(value="scmDataSourceTx")
    public void back(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        logger.info("back interestGoods member:{}, skuList:{}", (Object)memberId, (Object)interestGoodsSkuVOList.toString());
        if (ObjectUtils.isEmpty((Object)memberId) || CollectionUtils.isEmpty(interestGoodsSkuVOList)) {
            throw new InterestException(InterestExceptionEnum.ERROR_PARAM_NULL);
        }
        for (InterestGoodsSkuVO interestGoodsSkuVO : interestGoodsSkuVOList) {
            if (ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getCashQuantity()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getInterestGoodsId()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getSkuCode())) {
                throw new InterestException(InterestExceptionEnum.ERROR_PARAM_MISS);
            }
            Integer interestGoodsId = interestGoodsSkuVO.getInterestGoodsId();
            InterestGoods interestGoods = (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
            if (ObjectUtils.isEmpty((Object)interestGoods)) {
                logger.error(InterestExceptionEnum.ERROR_NOT_FOUND.getErrMsg());
                throw new InterestException(InterestExceptionEnum.ERROR_NOT_FOUND);
            }
            String skuCode = interestGoodsSkuVO.getSkuCode();
            InterestGoodsSku interestGoodsSku = this.interestGoodsSkuDao.getInterestGoodsSku(interestGoodsId, skuCode);
            if (ObjectUtils.isEmpty((Object)interestGoodsSku)) {
                logger.error(InterestExceptionEnum.ERROR_NOT_FOUND.getErrMsg());
                throw new InterestException(InterestExceptionEnum.ERROR_NOT_FOUND);
            }
            int usedQuantity = this.interestGoodsProvideDao.countCashQuantity(memberId, interestGoodsId, interestGoodsSku.getId(), false);
            if (interestGoodsSkuVO.getCashQuantity() > usedQuantity) {
                logger.error(InterestExceptionEnum.ERROR_BACK_EXCESS.getErrMsg());
                throw new InterestException(InterestExceptionEnum.ERROR_BACK_EXCESS);
            }
            interestGoodsSkuVO.setInterestGoodsSkuId(interestGoodsSku.getId());
            interestGoodsSkuVO.setProductCode(interestGoods.getProdCode());
        }
        boolean success = false;
        success = this.interestGoodsProvideDao.resetCash(memberId, interestGoodsSkuVOList);
        if (!success) {
            logger.error(InterestExceptionEnum.ERROR_UPDATE_STATUS.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_STATUS);
        }
        success = this.interestGoodsSkuDao.reduceCashQuantity(interestGoodsSkuVOList);
        if (!success) {
            logger.error(InterestExceptionEnum.ERROR_UPDATE_EXCESS.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_EXCESS);
        }
        success = this.backInterestProductToCart(memberId, interestGoodsSkuVOList);
        if (!success) {
            logger.error(InterestExceptionEnum.ERROR_PUT_CART.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_PUT_CART);
        }
    }

    private boolean backInterestProductToCart(Integer memberId, List<InterestGoodsSkuVO> InterestGoodsSkuVOList) {
        ArrayList cartProductPackList = Lists.newArrayList();
        for (InterestGoodsSkuVO interestGoodsSkuVO : InterestGoodsSkuVOList) {
            CartProductPack cartProductPack = new CartProductPack();
            cartProductPack.setSource(CartPackSource.INTEREST);
            cartProductPack.setOwnerId(Long.valueOf(memberId + ""));
            cartProductPack.setFactProductPrice(BigDecimal.ZERO);
            cartProductPack.setCount(interestGoodsSkuVO.getCashQuantity().intValue());
            PsProductVO psProductVO = this.mcPsProductService.findProdByCode(interestGoodsSkuVO.getProductCode());
            for (PsSpvVO spv : psProductVO.getSpvList()) {
                if (!spv.getSkuCode().equalsIgnoreCase(interestGoodsSkuVO.getSkuCode())) continue;
                cartProductPack.setSpvId(spv.getSpvId());
                cartProductPack.setProductId(spv.getProductId());
                cartProductPack.setSourceBindVal(interestGoodsSkuVO.getInterestGoodsId() + "");
                break;
            }
            cartProductPackList.add(cartProductPack);
        }
        ServiceResp resp = this.cartService.batchSaveInterestPack((List)cartProductPackList);
        return resp.isSuccess();
    }

    @Transactional(value="scmDataSourceTx")
    public boolean changeInterestGoodsSku(Integer memberId, Integer sourceInterestGoodsSkuId, Integer destInterestGoodsSkuId) {
        logger.info("change product memberId:{},sourceGoodsSkuId:{}, destGoodsSkuId:{}", new Object[]{memberId, sourceInterestGoodsSkuId, destInterestGoodsSkuId});
        boolean isSuccess = this.interestGoodsSkuDao.reduceReceiveQuantity(sourceInterestGoodsSkuId);
        if (!isSuccess) {
            logger.error("reduce source goods sku error");
            return false;
        }
        isSuccess = this.interestGoodsSkuDao.addReceiveQuantity(destInterestGoodsSkuId);
        if (!isSuccess) {
            logger.error(InterestExceptionEnum.ERROR_UPDATE_RECEIVE.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_RECEIVE);
        }
        int res = this.interestGoodsProvideDao.changeInterestGoodsSkuId(memberId, sourceInterestGoodsSkuId, destInterestGoodsSkuId);
        if (res != 1) {
            logger.error(InterestExceptionEnum.ERROR_UPDATE_CHANGE.getErrMsg());
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_CHANGE);
        }
        return true;
    }

    public Map<Integer, Integer> getCashQuantity(List<Integer> interestGoodsSkuIds) {
        return this.interestGoodsProvideDao.getCashQuantity(interestGoodsSkuIds);
    }

    public List<InterestGoodsSku> getIdByValidity() {
        List interestGoodsList = this.interestGoodsDao.getInterestByTime(DateUtils.getCurrentDate());
        ArrayList<InterestGoodsSku> result = new ArrayList<InterestGoodsSku>();
        for (InterestGoods interestGoods : interestGoodsList) {
            result.addAll(this.interestGoodsSkuDao.byInterestGoodsId(interestGoods.getId()));
        }
        return result;
    }

    public List<InterestGoodsGetVO> getPreExpiration(Integer day) {
        ArrayList InterestGoodsGetVOList = Lists.newArrayList();
        List interestGoodsList = this.interestGoodsDao.getInterestByTime(DateUtil.addDay((Date)DateUtils.getCurrentDate(), (int)day));
        if (CollectionUtils.isEmpty((Collection)interestGoodsList)) {
            return InterestGoodsGetVOList;
        }
        for (InterestGoods interestGoods : interestGoodsList) {
            List interestGoodsProvideList = this.interestGoodsProvideDao.queryInterestGoodsProvide(interestGoods.getId());
            for (InterestGoodsProvide interestGoodsProvide : interestGoodsProvideList) {
                InterestGoodsSku sku = (InterestGoodsSku)this.interestGoodsSkuDao.selectOne((Number)interestGoodsProvide.getInterestGoodsSkuId());
                InterestGoodsGetVO interestGoodsGetVO = new InterestGoodsGetVO(interestGoods, sku);
                interestGoodsGetVO.setMemberId(interestGoodsProvide.getMemberId());
                InterestGoodsGetVOList.add(interestGoodsGetVO);
            }
        }
        return InterestGoodsGetVOList;
    }

    public void batchUpdateStatus(List<Integer> interestGoodsIds) {
        logger.info("batch update interestGoods status param:", interestGoodsIds);
        int res = this.interestGoodsDao.batchUpdateStatus(interestGoodsIds);
        if (res != interestGoodsIds.size()) {
            logger.error("update interestGoods status error");
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_DB);
        }
        logger.info("batch update interestGoods status success");
    }
}

