/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;
import com.thebeastshop.pegasus.merchandise.price.AbstractPriceCalculator;
import com.thebeastshop.pegasus.merchandise.price.PriceCalculator;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import java.math.BigDecimal;
import java.util.List;

public class VIPDiscountPriceCalculator
extends AbstractPriceCalculator
implements PriceCalculator {
    private BigDecimal discountAmount;
    private boolean hasRush = false;
    private boolean allowVipDiscount = false;

    public VIPDiscountPriceCalculator(PriceCalculator sourcePriceCalculator, BigDecimal discountAmount, boolean hasRush, boolean allowVipDiscount) {
        super(sourcePriceCalculator);
        this.discountAmount = discountAmount;
        this.hasRush = hasRush;
        this.allowVipDiscount = allowVipDiscount;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = this.getPrevPrice(results);
        PriceCalResultVO result = new PriceCalResultVO();
        result.setType(PriceCalTypeEnum.MEMBER_LEVEL);
        result.setOriginalPrice(targetPrice);
        if (this.allowVipDiscount && !this.hasRush) {
            targetPrice = targetPrice.multiply(this.discountAmount);
        }
        if (results != null) {
            result.setFinalPrice(targetPrice);
            results.add(result);
        }
        return targetPrice;
    }
}

