/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.exception.PublicException;
import com.thebeastshop.pegasus.merchandise.price.PriceCalculator;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import java.math.BigDecimal;
import java.util.List;

public abstract class AbstractPriceCalculator
implements PriceCalculator {
    protected PriceCalculator sourcePriceCalculator;

    public AbstractPriceCalculator(PriceCalculator sourcePriceCalculator) {
        this.sourcePriceCalculator = sourcePriceCalculator;
    }

    @Override
    public boolean getHasRush() {
        return false;
    }

    @Override
    public PriceCalculator getPrevPriceCalculator() {
        return this.sourcePriceCalculator;
    }

    @Override
    public BigDecimal getPrevPrice(List<PriceCalResultVO> results) {
        if (this.sourcePriceCalculator == null) {
            throw new PublicException("\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38\uff1a\u539f\u4ef7\u4e3a\u7a7a");
        }
        BigDecimal targetPrice = this.sourcePriceCalculator.calculate(results);
        return targetPrice;
    }
}

