/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuReceiveStandardMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuReceiveStandardRuleMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuReceiveStandardDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuReceiveStandard;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuReceiveStandardRule;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsSkuReceiveStandardDomain")
public class PcsSkuReceiveStandardDomainImpl
implements PcsSkuReceiveStandardDomain {
    @Autowired
    private PcsSkuReceiveStandardMapper pcsSkuReceiveStandardMapper;
    @Autowired
    private PcsSkuReceiveStandardRuleMapper pcsSkuReceiveStandardRuleMapper;

    @Override
    public List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond) {
        return this.pcsSkuReceiveStandardMapper.listSkuByCond(cond);
    }

    @Override
    @Transactional
    public boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        if (EmptyUtil.isEmpty((Object)vo.getId())) {
            return this.createSkuReceiveStandard(vo);
        }
        return this.editSkuReceiveStandard(vo);
    }

    @Override
    @Transactional
    public boolean saveReceiveStandardBySkuCode(List<PcsSkuReceiveStandardVO> voList) {
        boolean result = false;
        for (PcsSkuReceiveStandardVO standardVO : voList) {
            result = this.saveReceiveStandardBySkuCode(standardVO);
            if (result) continue;
            throw new PurchaseException("PC0002", "\u4fdd\u5b58\u5931\u8d25!");
        }
        return result;
    }

    private boolean saveReceiveStandardBySkuCode(PcsSkuReceiveStandardVO vo) {
        boolean updateSuccess = this.updateReceiveStandardBySkuCode(vo);
        if (!updateSuccess) {
            updateSuccess = this.saveReceiveStandard(vo);
        }
        if (updateSuccess) {
            this.updateSkuReciveStandardRule(vo);
        }
        return updateSuccess;
    }

    private boolean updateReceiveStandardBySkuCode(PcsSkuReceiveStandardVO vo) {
        int result = this.pcsSkuReceiveStandardMapper.updateReceiveStandardBySkuCode(vo);
        return result == 1;
    }

    private boolean saveReceiveStandard(PcsSkuReceiveStandardVO vo) {
        this.pcsSkuReceiveStandardMapper.saveReceiveStandard(vo);
        return true;
    }

    @Override
    public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(String skuCode) {
        return this.findPcsSkuReceiveStandardBySkuCode(skuCode, false);
    }

    @Override
    public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(String skuCode, boolean cascade) {
        PcsSkuReceiveStandardVO standardVO = this.pcsSkuReceiveStandardMapper.findPcsSkuReceiveStandardBySkuCode(skuCode);
        if (NullUtil.isNotNull((Object)standardVO) && cascade) {
            List<Long> ruleIds = this.pcsSkuReceiveStandardMapper.findReceiveRuleIdsBySkuCode(skuCode);
            standardVO.setReceiveRuleIds(ruleIds);
        }
        return standardVO;
    }

    @Override
    @Transactional
    public boolean editSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        this.updateSkuReciveStandardRule(vo);
        PcsSkuReceiveStandard record = (PcsSkuReceiveStandard)BeanUtil.buildFrom((Object)vo, PcsSkuReceiveStandard.class);
        return this.pcsSkuReceiveStandardMapper.updateByPrimaryKeySelective(record) == 1;
    }

    @Override
    @Transactional
    public boolean createSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        this.updateSkuReciveStandardRule(vo);
        PcsSkuReceiveStandard record = (PcsSkuReceiveStandard)BeanUtil.buildFrom((Object)vo, PcsSkuReceiveStandard.class);
        return this.pcsSkuReceiveStandardMapper.insert(record) == 1;
    }

    private void updateSkuReciveStandardRule(PcsSkuReceiveStandardVO vo) {
        this.pcsSkuReceiveStandardMapper.deleteSkuReceiveStandardRuleBySkuCode(vo.getSkuCode());
        if (EmptyUtil.isNotEmpty((List)vo.getReceiveRuleIds())) {
            for (Long ruleId : vo.getReceiveRuleIds()) {
                this.pcsSkuReceiveStandardMapper.insertSkuReceiveStandardRule(vo.getSkuCode(), ruleId);
            }
        }
    }

    @Override
    @Deprecated
    public List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule() {
        return this.pcsSkuReceiveStandardRuleMapper.findAllReceiveStandardRule();
    }

    @Override
    @Deprecated
    public List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(String skuCode) {
        return this.pcsSkuReceiveStandardRuleMapper.findSkuReceiveStandardRule(skuCode);
    }

    @Override
    @Deprecated
    public PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id) {
        PcsSkuReceiveStandardRule rule = this.pcsSkuReceiveStandardRuleMapper.selectByPrimaryKey(id);
        PcsSkuReceiveStandardRuleVO ruleVO = new PcsSkuReceiveStandardRuleVO();
        BeanUtils.copyProperties((Object)rule, (Object)ruleVO);
        return ruleVO;
    }

    @Override
    @Transactional
    @Deprecated
    public boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo) {
        vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_ON);
        PcsSkuReceiveStandardRule record = (PcsSkuReceiveStandardRule)BeanUtil.buildFrom((Object)vo, PcsSkuReceiveStandardRule.class);
        return this.pcsSkuReceiveStandardRuleMapper.insert(record) == 1;
    }

    @Override
    @Transactional
    @Deprecated
    public boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo) {
        PcsSkuReceiveStandardRule record = (PcsSkuReceiveStandardRule)BeanUtil.buildFrom((Object)vo, PcsSkuReceiveStandardRule.class);
        return this.pcsSkuReceiveStandardRuleMapper.updateByPrimaryKeySelective(record) == 1;
    }

    @Override
    @Transactional
    @Deprecated
    public boolean deleteReceiveStandardRule(Long id) {
        PcsSkuReceiveStandardRuleVO vo = new PcsSkuReceiveStandardRuleVO();
        vo.setId(id);
        vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_OFF);
        return this.updateReceiveStandardRule(vo);
    }
}

