/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.merchandise.cond.ApprovalRecordCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuQualifyCond;
import com.thebeastshop.pegasus.merchandise.constants.PcsSkuQualifyConstants;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuQualifyMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuQualifyDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQualify;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQualifyExample;
import com.thebeastshop.pegasus.merchandise.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQualifyVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsSkuQualifyDomain")
public class PcsSkuQualifyDomainImpl
implements PcsSkuQualifyDomain,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsSkuQualifyDomainImpl.class);
    @Autowired
    private PcsSkuQualifyMapper pcsSkuQualifyMapper;

    @Override
    public PcsSkuQualify buildFromVO(PcsSkuQualifyVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsSkuQualify record = new PcsSkuQualify();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsSkuQualifyVO buildFromModel(PcsSkuQualify record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsSkuQualifyVO vo = new PcsSkuQualifyVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsSkuQualify record) {
        record.setCreateTime(new Date());
        this.pcsSkuQualifyMapper.insertSelective(record);
        return record.getId();
    }

    @Override
    @Transactional
    public Boolean update(PcsSkuQualify record) {
        record.setModifyTime(new Date());
        return this.pcsSkuQualifyMapper.updateByPrimaryKeySelective(record) != 0;
    }

    private void sendNotice(String code, UserInfo userInfo) {
        SmsUtil smsUtil = SmsUtil.getInstance();
        SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("finance.Approval.Mobile");
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if (userInfo != null) {
            String[] categoryManager = new String[]{userInfo.getMobile()};
            smsVO.setMobileList(Arrays.asList(categoryManager));
        } else {
            smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        }
        smsVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u4f9b\u5e94\u5546\u9700\u8981\u5ba1\u6279\uff0c\u4f9b\u5e94\u5546\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        smsUtil.send(smsVO);
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("finance.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        if (userInfo != null) {
            String[] categoryManager = new String[]{userInfo.getEmail()};
            emailVO.setToAddressList(Arrays.asList(categoryManager));
        } else {
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        }
        emailVO.setSubject("\u4f9b\u5e94\u5546\u5ba1\u6279");
        emailVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u4f9b\u5e94\u5546\u9700\u8981\u5ba1\u6279\uff0c\u4f9b\u5e94\u5546\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public PcsSkuQualify findById(Long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsSkuQualifyMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuQualifyVO> findByCond(PcsSkuQualifyCond cond) {
        List<PcsSkuQualifyVO> recordList = this.pcsSkuQualifyMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuQualify> findByCriteria(PcsSkuQualifyCond cond) {
        PcsSkuQualifyExample example = new PcsSkuQualifyExample();
        List<PcsSkuQualify> recordList = this.pcsSkuQualifyMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuQualify> findByIds(List<Long> ids) {
        ArrayList<PcsSkuQualify> recordList = new ArrayList<PcsSkuQualify>();
        for (long id : ids) {
            PcsSkuQualify record = this.findById(id);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public Boolean auditSkuQualify(Long userId, long id, Boolean isPass, Integer type) {
        PcsSkuQualify record = this.pcsSkuQualifyMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        boolean isPostMeeting = record.getIsPostMeeting() == PcsSkuQualifyConstants.AUDIT_IS_POST_MEETING;
        boolean isSetAuditStatus = false;
        if (type == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OWN_IMPORTED) {
            record.setFlowTrend((Integer)PcsSkuQualifyConstants.getOwnImportedFlowTrend((boolean)isPass).get(record.getAuditStatus()));
            if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE) {
                record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_QA_FIRST_AUDIT_PASS);
                isSetAuditStatus = true;
            } else if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_PASS) {
                record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
                isSetAuditStatus = true;
            }
        } else if (type == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OTHER_IMPORTED) {
            record.setFlowTrend((Integer)PcsSkuQualifyConstants.getOtherImportedFlowTrend((boolean)isPass, (boolean)isPostMeeting).get(record.getAuditStatus()));
            if (isPostMeeting && isPass.booleanValue()) {
                record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS_ISPOSTMEETING);
                isSetAuditStatus = true;
            }
        } else if (type == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_NOT_IMPORTED) {
            record.setFlowTrend((Integer)PcsSkuQualifyConstants.getNotImportedFlowTrend((boolean)isPass).get(record.getAuditStatus()));
        }
        if (!isSetAuditStatus) {
            if (!isPass.booleanValue()) {
                record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_REJECT);
            } else if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE) {
                record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
            } else {
                record.setAuditStatus(record.getFlowTrend());
            }
        }
        return this.pcsSkuQualifyMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public Boolean auditSkuQualify(ApprovalRecordVO vo, Boolean isPass, Integer importedType) {
        PcsSkuQualify record = this.pcsSkuQualifyMapper.selectByPrimaryKey(vo.getPendingId());
        record.setLastModifier(vo.getApproverId());
        record.setAuditDecision(vo.getAuditDecision());
        record.setAutonomousDetection(vo.getAutonomousDetection());
        record.setRiskLevel(vo.getRiskLevel());
        record.setRiskDesc(vo.getRiskDesc());
        record.setModifyTime(new Date());
        boolean isPostMeeting = record.getIsPostMeeting() == PcsSkuQualifyConstants.AUDIT_IS_POST_MEETING;
        boolean isSetAuditStatus = false;
        Integer flowTrend = record.getFlowTrend();
        if (importedType == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OWN_IMPORTED) {
            record.setFlowTrend((Integer)PcsSkuQualifyConstants.getOwnImportedFlowTrend((boolean)isPass).get(record.getFlowTrend()));
            if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE) {
                if (flowTrend == PcsSkuQualifyConstants.FLOW_TREND_QA_FINAL_AUDIT) {
                    if (isPass.booleanValue()) {
                        record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
                    } else {
                        record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_REJECT);
                    }
                } else {
                    record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_QA_FIRST_AUDIT_PASS);
                }
                isSetAuditStatus = true;
            } else if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_PASS) {
                record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
                isSetAuditStatus = true;
            }
        } else if (importedType == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OTHER_IMPORTED) {
            record.setFlowTrend((Integer)PcsSkuQualifyConstants.getOtherImportedFlowTrend((boolean)isPass, (boolean)isPostMeeting).get(record.getFlowTrend()));
        } else if (importedType == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_NOT_IMPORTED) {
            record.setFlowTrend((Integer)PcsSkuQualifyConstants.getNotImportedFlowTrend((boolean)isPass).get(record.getFlowTrend()));
        }
        if (!isSetAuditStatus) {
            if (!isPass.booleanValue()) {
                record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_REJECT);
            } else if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE) {
                if (isPostMeeting) {
                    record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS_ISPOSTMEETING);
                } else {
                    record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
                }
            } else {
                record.setAuditStatus(record.getFlowTrend());
            }
        }
        return this.pcsSkuQualifyMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public Boolean auditSkuQualify(long id, Boolean isPass, Integer type) {
        return null;
    }

    @Override
    public long countByCond(PcsSkuQualifyCond cond) {
        return this.pcsSkuQualifyMapper.countByCond(cond);
    }

    public Boolean check(Object obj) {
        return null;
    }

    @Override
    public PcsSkuQualify findBySkuCode(String skuCode) {
        PcsSkuQualifyVO vo = this.pcsSkuQualifyMapper.findBySkuCode(skuCode);
        return this.buildFromVO(vo);
    }

    @Override
    @Transactional
    public boolean createApprovalRecord(ApprovalRecordVO vo) {
        return this.pcsSkuQualifyMapper.createApprovalRecord(vo) == 1;
    }

    @Override
    public List<ApprovalRecordVO> findApprovalRecordsByCond(ApprovalRecordCond cond) {
        return this.pcsSkuQualifyMapper.findApprovalRecordsByCond(cond);
    }

    @Override
    public long getFileCountByCond(PcsSkuQualifyCond cond) {
        return this.pcsSkuQualifyMapper.getFileCountByCond(cond);
    }
}

