/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCustomMadeMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCmSplDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCustomMadeDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCustomMadeExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomMadeVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="pcsSkuCustomMadeDomain")
public class PcsSkuCustomMadeDomainImpl
extends AbstractBaseDomain<PcsSkuCustomMadeVO, PcsSkuCustomMade>
implements PcsSkuCustomMadeDomain,
CheckAble,
CodeAble {
    @Autowired
    private PcsSkuCustomMadeMapper pcsSkuCustomMadeMapper;
    @Autowired
    private PcsSkuCmSplDomain pcsSkuCmSplDomain;

    @Override
    @Transactional
    public PcsSkuCustomMade create(PcsSkuCustomMade record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            this.initDefaultValue(record);
            this.pcsSkuCustomMadeMapper.insertSelective(record);
            try {
                String code = this.generateCode(record.getId());
                if (this.check(code).booleanValue()) {
                    record.setCode(code);
                    this.pcsSkuCustomMadeMapper.updateByPrimaryKeySelective(record);
                    return record;
                }
                throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", "\u751f\u6210CODE\u5931\u8d25");
            }
        }
        return null;
    }

    private void initDefaultValue(PcsSkuCustomMade record) {
        record.setCreateTime(new Date());
        record.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY);
    }

    @Override
    @Transactional
    public boolean update(PcsSkuCustomMade record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            record.setCode(null);
            return this.pcsSkuCustomMadeMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsSkuCustomMadeVO findSkuCustomMadeById(long id) {
        return this.pcsSkuCustomMadeMapper.findSkuCustomMadeById(id);
    }

    @Override
    public PcsSkuCustomMade findById(long id) {
        return this.pcsSkuCustomMadeMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuCustomMade findSkuCustomMadeByCode(String code) {
        PcsSkuCustomMadeExample example = new PcsSkuCustomMadeExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSkuCustomMade> poList = this.pcsSkuCustomMadeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        }
        if (poList.size() > 1) {
            throw new PurchaseException("PC0005", " \u6839\u636ecode[" + code + "]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return poList.get(0);
    }

    @Override
    public List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond) {
        return this.pcsSkuCustomMadeMapper.findSkuCustomMadeByCond(cond);
    }

    @Override
    @Transactional
    public Boolean createCustomMadeAndLine(PcsSkuCustomMade pcsSkuCustomMade, List<PcsSkuCmSpl> pcsSkuCmSplList) {
        if (pcsSkuCmSplList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        if (EmptyUtil.isEmpty((Object)(pcsSkuCustomMade = this.create(pcsSkuCustomMade)).getId())) {
            throw new PurchaseException("PC0009", "SKU\u5b9a\u5236\u5934\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsSkuCustomMade.toString());
        }
        for (PcsSkuCmSpl spl : pcsSkuCmSplList) {
            spl.setSkuCustomMadeId(pcsSkuCustomMade.getId());
            if (this.pcsSkuCmSplDomain.create(spl).compareTo(0L) >= 1) continue;
            throw new PurchaseException("PC0009", "SKU\u5b9a\u5236\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + spl.toString());
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateCustomMadeAndLine(PcsSkuCustomMade pcsSkuCustomMade, List<PcsSkuCmSpl> pcsSkuCmSplList) {
        Boolean madeUpdate;
        if (pcsSkuCmSplList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        PcsSkuCustomMade old = this.findById(pcsSkuCustomMade.getId());
        if (old.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_MODIFY)) {
            pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY);
        }
        if ((madeUpdate = Boolean.valueOf(this.update(pcsSkuCustomMade))).booleanValue()) {
            for (PcsSkuCmSpl spl : pcsSkuCmSplList) {
                if (EmptyUtil.isEmpty((Object)spl.getId())) {
                    spl.setSkuCustomMadeId(pcsSkuCustomMade.getId());
                    if (this.pcsSkuCmSplDomain.create(spl).compareTo(0L) >= 1) continue;
                    throw new PurchaseException("PC0009", "SKU\u5b9a\u5236\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + spl.toString());
                }
                if (this.pcsSkuCmSplDomain.update(spl)) continue;
                throw new PurchaseException("PC0010", "SKU\u5b9a\u5236\u884c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + spl.toString());
            }
            return true;
        }
        throw new PurchaseException("PC0010", "SKU\u5b9a\u5236\u5934\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsSkuCustomMade.toString());
    }

    @Override
    @Transactional
    public Boolean deletePcsCmSpl(long skuCustomMadeId, long skuCmSplId) {
        PcsSkuCustomMadeVO pcsSkuCustomMade = this.findSkuCustomMadeById(skuCustomMadeId);
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade) && EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade.getSkuStatus()) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_MODIFY)) {
            PcsSkuCmSpl pcsSkuCmSpl = this.pcsSkuCmSplDomain.findById(skuCmSplId);
            if (EmptyUtil.isNotEmpty((Object)pcsSkuCmSpl) && EmptyUtil.isNotEmpty((Object)pcsSkuCmSpl.getSkuCustomMadeId()) && pcsSkuCmSpl.getSkuCustomMadeId().equals(skuCustomMadeId)) {
                return this.pcsSkuCmSplDomain.deleteById(skuCmSplId);
            }
            throw new PurchaseException("PC0001", "skuCmSplId \u5f02\u5e38");
        }
        throw new PurchaseException("PC0002", "\u53ea\u6709\u5f85\u4fee\u6539\u72b6\u6001\u7684\u5b9a\u5236\u5355\u53ef\u4ee5\u5220\u51cf\u4f9b\u5e94\u5546\u884c\u4fe1\u606f");
    }

    @Override
    @Transactional
    public Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId) {
        PcsSkuCustomMade pcsSkuCustomMade = this.findById(skuCustomMadeId);
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade) && EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade.getSkuStatus()) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY)) {
            PcsSkuCmSpl pcsSkuCmSpl = this.pcsSkuCmSplDomain.findById(skuCmSplId);
            if (EmptyUtil.isNotEmpty((Object)pcsSkuCmSpl) && EmptyUtil.isNotEmpty((Object)pcsSkuCmSpl.getSkuCustomMadeId()) && pcsSkuCmSpl.getSkuCustomMadeId().equals(skuCustomMadeId)) {
                pcsSkuCmSpl.setIsSelected(1);
                if (this.pcsSkuCmSplDomain.update(pcsSkuCmSpl)) {
                    pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_WAITING_CONVERT);
                    if (this.update(pcsSkuCustomMade)) {
                        return true;
                    }
                    throw new PurchaseException("PC0010", "PcsSkuCustomMade \u66f4\u65b0\u5931\u8d25");
                }
                throw new PurchaseException("PC0010", "PcsSkuCmSpl \u66f4\u65b0\u5931\u8d25");
            }
            throw new PurchaseException("PC0001", "skuCmSplId \u5f02\u5e38");
        }
        throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u5ba1\u6838\u72b6\u6001\u7684\u5b9a\u5236\u5355");
    }

    @Override
    @Transactional
    public Boolean rejectCustomMade(long skuCustomMadeId) {
        PcsSkuCustomMade pcsSkuCustomMade = this.findById(skuCustomMadeId);
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade) && EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade.getSkuStatus()) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_VERIFY)) {
            pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_MODIFY);
            return this.update(pcsSkuCustomMade);
        }
        throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u5ba1\u6838\u72b6\u6001\u7684\u5b9a\u5236\u5355");
    }

    public Boolean check(Object obj) {
        PcsSkuCustomMade record = (PcsSkuCustomMade)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsSkuCustomMade record, Boolean isCreate) {
        PcsSkuCustomMade oldRecord;
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && NullUtil.isNotNull((Object)(oldRecord = this.pcsSkuCustomMadeMapper.selectByPrimaryKey(record.getId()))) && EmptyUtil.isNotEmpty((Object)oldRecord.getFileId()) && EmptyUtil.isNotEmpty((Object)record.getFileId()) && !oldRecord.getFileId().equals(record.getFileId())) {
            PegasusUtilFacade.getInstance().deleteFileById((long)oldRecord.getFileId().intValue());
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull((Object)this.findSkuCustomMadeByCode(code));
    }

    public String generateCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_SKU_CUSTOM_MADE", params);
        return code;
    }
}

